/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.fluent.collections.ImmutableSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class DocumentWhitelist {
    private static final Logger log = LogManager.getLogger(DocumentWhitelist.class);
    private static final DocumentWhitelist EMPTY = new DocumentWhitelist((ImmutableSet<Entry>)ImmutableSet.empty());
    private final ImmutableSet<Entry> entries;

    public static DocumentWhitelist get(ThreadContext threadContext) {
        String docWhitelistHeader = threadContext.getHeader("_sg_doc_whitelist");
        if (docWhitelistHeader == null) {
            return EMPTY;
        }
        try {
            return DocumentWhitelist.parse(docWhitelistHeader);
        }
        catch (Exception e) {
            log.error("Error while handling document whitelist: " + docWhitelistHeader, (Throwable)e);
            return EMPTY;
        }
    }

    public DocumentWhitelist(ImmutableSet<Entry> entries) {
        this.entries = entries;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void applyTo(ThreadContext threadContext) {
        if (!this.isEmpty()) {
            threadContext.putHeader("_sg_doc_whitelist", this.toString());
        }
    }

    public boolean isWhitelisted(String index, String id) {
        for (Entry entry : this.entries) {
            if (!entry.index.equals(index) || !entry.id.equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean isWhitelistForIndexPresent(String index) {
        for (Entry entry : this.entries) {
            if (!entry.index.equals(index)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.entries.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry entry : this.entries) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append(entry.index).append("/").append(DocumentWhitelist.escapeId(entry.id));
        }
        return stringBuilder.toString();
    }

    public static DocumentWhitelist parse(String string) {
        int length = string.length();
        if (length == 0) {
            return EMPTY;
        }
        ImmutableSet.Builder entries = new ImmutableSet.Builder();
        int entryStart = 0;
        String index = null;
        int i = 0;
        while (true) {
            int c = i < length ? (int)string.charAt(i) : 124;
            while (c == 92) {
                c = string.charAt(i += 2);
            }
            if (c == 47) {
                index = string.substring(entryStart, i);
                entryStart = i + 1;
            } else if (c == 124) {
                if (index == null) {
                    throw new IllegalArgumentException("Malformed DocumentWhitelist string: " + string);
                }
                String id = DocumentWhitelist.unescapeId(string.substring(entryStart, i));
                entries.add((Object)new Entry(index, id));
                index = null;
                entryStart = i + 1;
            }
            if (i >= length) break;
            ++i;
        }
        return new DocumentWhitelist((ImmutableSet<Entry>)entries.build());
    }

    private static String escapeId(String id) {
        int length = id.length();
        boolean needsEscaping = false;
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (c != '/' && c != '|' && c != '\\') continue;
            needsEscaping = true;
            break;
        }
        if (!needsEscaping) {
            return id;
        }
        StringBuilder result = new StringBuilder(id.length() + 10);
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (c == '/' || c == '|' || c == '\\') {
                result.append('\\');
            }
            result.append(c);
        }
        return result.toString();
    }

    private static String unescapeId(String id) {
        int length = id.length();
        boolean needsEscaping = false;
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (c != '\\') continue;
            needsEscaping = true;
            break;
        }
        if (!needsEscaping) {
            return id;
        }
        StringBuilder result = new StringBuilder(id.length());
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (c == '\\') {
                c = id.charAt(++i);
            }
            result.append(c);
        }
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentWhitelist other = (DocumentWhitelist)obj;
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    public static class Entry {
        private final String index;
        private final String id;

        Entry(String index, String id) {
            if (index.indexOf(47) != -1 || index.indexOf(124) != -1) {
                throw new IllegalArgumentException("Invalid index name: " + index);
            }
            this.index = index;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.index == null ? other.index != null : !this.index.equals(other.index));
        }

        public String toString() {
            return "DocumentWhitelist.Entry [index=" + this.index + ", id=" + this.id + "]";
        }
    }

    public static class Builder {
        private ImmutableSet.Builder<Entry> entries = new ImmutableSet.Builder();

        public void add(String index, String id) {
            this.add(new Entry(index, id));
        }

        public void add(Entry entry) {
            this.entries.add((Object)entry);
        }

        public DocumentWhitelist build() {
            return new DocumentWhitelist((ImmutableSet<Entry>)this.entries.build());
        }
    }
}

