/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.actions;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.SearchGuardModulesRegistry;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.whoami.WhoAmIAction;
import com.floragunn.searchguard.authc.internal_users_db.InternalUsersConfigApi;
import com.floragunn.searchguard.authc.session.GetActivatedFrontendConfigAction;
import com.floragunn.searchguard.authc.session.backend.SessionApi;
import com.floragunn.searchguard.authz.ActionAuthorization;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.configuration.api.BulkConfigApi;
import com.floragunn.searchguard.configuration.variables.ConfigVarApi;
import com.floragunn.searchguard.configuration.variables.ConfigVarRefreshAction;
import com.floragunn.searchguard.modules.api.GetComponentStateAction;
import com.floragunn.searchsupport.meta.Meta;
import com.floragunn.searchsupport.reflection.ReflectiveAttributeAccessors;
import com.floragunn.searchsupport.xcontent.AttributeValueFromXContent;
import com.floragunn.searchsupport.xcontent.XContentObjectConverter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.xcontent.ToXContent;

public class Actions {
    private final ImmutableMap<String, Action> actionMap;
    private final ImmutableSet<Action.WellKnownAction<?, ?, ?>> indexLikeActions;
    private final ImmutableSet<Action.WellKnownAction<?, ?, ?>> indexLikeActionsPerformanceCritical;
    private final ImmutableSet<Action.WellKnownAction<?, ?, ?>> clusterActions;
    private final ImmutableSet<Action.WellKnownAction<?, ?, ?>> tenantActions;
    private final ImmutableSet<Action.WellKnownAction<?, ?, ?>> openActions;
    private final ImmutableSet<Action.WellKnownAction<?, ?, ?>> allActions;
    private Builder builder = new Builder();
    private static Actions forTestsInstance;

    public Actions(SearchGuardModulesRegistry modulesRegistry) {
        this.indexLike("indices:data/write/index").performanceCritical().aliasesResolveToWriteTarget();
        this.indexLike("indices:data/read/get").performanceCritical();
        this.indexLike("indices:data/read/tv").performanceCritical();
        this.indexLike("indices:data/write/delete").performanceCritical();
        this.indexLike("indices:data/write/update").performanceCritical();
        this.indexLike("indices:data/read/search").performanceCritical();
        this.indexLike("indices:data/read/explain").performanceCritical();
        this.indexLike("indices:admin/resolve/index").performanceCritical();
        this.indexLike("indices:admin/resolve/cluster").performanceCritical();
        this.index("indices:data/write/update/byquery").performanceCritical();
        this.index("indices:data/write/delete/byquery").performanceCritical();
        this.index("indices:data/write/bulk[s]").performanceCritical().requestType(BulkShardRequest.class).requestItemsA(BulkShardRequest::items, item -> item.request().opType()).requiresAdditionalPrivilegesForItemType(DocWriteRequest.OpType.DELETE, "indices:data/write/delete", new String[0]).requiresAdditionalPrivilegesForItemType(DocWriteRequest.OpType.INDEX, "indices:data/write/index", new String[0]).requiresAdditionalPrivilegesForItemType(DocWriteRequest.OpType.CREATE, "indices:data/write/index", new String[0]).requiresAdditionalPrivilegesForItemType(DocWriteRequest.OpType.UPDATE, "indices:data/write/index", new String[0]);
        this.index("indices:admin/shards/search_shards").performanceCritical().requiresAdditionalPrivileges(Actions.always(), "indices:data/read/search", new String[0]);
        this.index("indices:admin/search/search_shards").performanceCritical().requiresAdditionalPrivileges(Actions.always(), "indices:data/read/search", new String[0]);
        this.indexLike("indices:data/read/mget[shard]").performanceCritical();
        this.indexLike("indices:data/read/open_point_in_time").performanceCritical();
        this.cluster("indices:data/read/close_point_in_time");
        this.cluster("indices:data/read/mget");
        this.cluster("indices:data/write/bulk");
        this.cluster("indices:data/read/scroll");
        this.cluster("indices:data/read/msearch");
        this.cluster("indices:data/read/mtv");
        this.cluster("indices:data/read/search/template");
        this.cluster("indices:data/read/msearch/template");
        this.indexLike("indices:monitor/stats");
        this.indexLike("indices:monitor/segments");
        this.indexLike("indices:monitor/shard_stores");
        this.indexLike("indices:admin/create").performanceCritical().requestType(CreateIndexRequest.class).requiresAdditionalPrivileges(Actions.ifNotEmpty(CreateIndexRequest::aliases), "indices:admin/aliases", new String[0]).additionalDimensions(Action.AdditionalDimension.MANAGE_ALIASES);
        this.index("indices:admin/resize").additionalDimensions(Action.AdditionalDimension.RESIZE_TARGET);
        this.index("indices:admin/xpack/downsample").additionalDimensions(Action.AdditionalDimension.DOWNSAMPLE_TARGET);
        this.indexLike("indices:admin/rollover");
        this.indexLike("indices:admin/delete");
        this.indexLike("indices:admin/get");
        this.index("indices:admin/open");
        this.index("indices:admin/close");
        this.indexLike("indices:admin/block/add");
        this.indexLike("indices:admin/mappings/get");
        this.indexLike("indices:admin/mappings/fields/get");
        this.indexLike("indices:admin/mapping/put").performanceCritical();
        this.indexLike("indices:admin/mapping/auto_put").performanceCritical();
        this.indexLike("indices:admin/aliases").requestType(IndicesAliasesRequest.class).requestItems(IndicesAliasesRequest::getAliasActions, IndicesAliasesRequest.AliasActions::actionType).requiresAdditionalPrivilegesForItemType(IndicesAliasesRequest.AliasActions.Type.REMOVE_INDEX, "indices:admin/delete", new String[0]).additionalDimensions(Action.AdditionalDimension.ALIASES);
        this.indexLike("indices:admin/settings/update");
        this.indexLike("indices:admin/analyze");
        this.indexLike("indices:admin/auto_create").performanceCritical();
        this.cluster("indices:data/read/scroll/clear");
        this.cluster("indices:monitor/recovery");
        this.cluster("cluster:admin/nodes/reload_secure_settings");
        this.cluster("indices:data/read/async_search/submit").createsResource("async_search", ReflectiveAttributeAccessors.objectAttr((String)"id"), Actions.xContentInstantFromMillis("expiration_time_in_millis"));
        this.cluster("indices:data/read/async_search/get").uses(new Action.WellKnownAction.Resource("async_search", ReflectiveAttributeAccessors.objectAttr((String)"id")).ownerCheckBypassPermission("indices:searchguard:async_search/_all_owners"));
        this.cluster("indices:data/read/async_search/delete").deletes(new Action.WellKnownAction.Resource("async_search", ReflectiveAttributeAccessors.objectAttr((String)"id")).ownerCheckBypassPermission("indices:searchguard:async_search/_all_owners"));
        this.cluster("indices:searchguard:async_search/_all_owners");
        this.cluster("indices:data/read/sql");
        this.cluster("indices:data/read/sql/translate");
        this.cluster("indices:data/read/sql/close_cursor");
        this.cluster("cluster:monitor/main");
        this.cluster("cluster:monitor/nodes/info");
        this.cluster("cluster:monitor/remote/info");
        this.cluster("cluster:monitor/nodes/stats");
        this.cluster("cluster:monitor/nodes/usage");
        this.cluster("cluster:monitor/nodes/hot_threads");
        this.cluster("cluster:monitor/tasks/lists");
        this.cluster("cluster:monitor/task/get");
        this.cluster("cluster:admin/tasks/cancel");
        this.cluster("cluster:admin/voting_config/add_exclusions");
        this.cluster("cluster:admin/voting_config/clear_exclusions");
        this.cluster("cluster:monitor/allocation/explain");
        this.cluster("cluster:monitor/stats");
        this.cluster("cluster:monitor/state");
        this.cluster("cluster:monitor/health");
        this.cluster("cluster:admin/settings/update");
        this.cluster("cluster:admin/reroute");
        this.cluster("cluster:monitor/task");
        this.cluster("cluster:admin/repository/put");
        this.cluster("cluster:admin/repository/get");
        this.cluster("cluster:admin/repository/delete");
        this.cluster("cluster:admin/repository/verify");
        this.cluster("cluster:admin/repository/_cleanup");
        this.cluster("cluster:admin/snapshot/get");
        this.cluster("cluster:admin/snapshot/delete");
        this.cluster("cluster:admin/snapshot/create");
        this.cluster("cluster:admin/snapshot/clone");
        this.cluster("cluster:admin/snapshot/restore").requestType(RestoreSnapshotRequest.class).requiresAdditionalPrivileges(Actions.always(), "indices:admin/create", "indices:data/write/index");
        this.cluster("cluster:admin/snapshot/status");
        this.cluster("indices:data/write/reindex");
        this.cluster("indices:admin/template/put");
        this.cluster("indices:admin/template/get");
        this.cluster("indices:admin/template/delete");
        this.cluster("cluster:admin/component_template/put");
        this.cluster("cluster:admin/component_template/get");
        this.cluster("cluster:admin/component_template/delete");
        this.cluster("indices:admin/index_template/put");
        this.cluster("indices:admin/index_template/get");
        this.cluster("indices:admin/index_template/delete");
        this.cluster("indices:admin/index_template/simulate_index");
        this.cluster("indices:admin/index_template/simulate");
        this.indexLike("indices:admin/validate/query");
        this.indexLike("indices:admin/refresh").performanceCritical();
        this.indexLike("indices:admin/refresh[s]").performanceCritical();
        this.indexLike("indices:admin/flush");
        this.indexLike("indices:admin/forcemerge");
        this.indexLike("indices:admin/cache/clear");
        this.indexLike("indices:admin/aliases/get").additionalDimensions(Action.AdditionalDimension.ALIASES);
        this.index("indices:monitor/settings/get");
        this.indexLike("indices:data/read/field_caps").performanceCritical();
        this.cluster("cluster:admin/script/put");
        this.cluster("cluster:admin/script/get");
        this.cluster("cluster:admin/script/delete");
        this.cluster("cluster:admin/script_context/get");
        this.cluster("cluster:admin/script_language/get");
        this.cluster("cluster:admin/ingest/pipeline/put");
        this.cluster("cluster:admin/ingest/pipeline/get");
        this.cluster("cluster:admin/ingest/pipeline/delete");
        this.cluster("cluster:admin/ingest/pipeline/simulate");
        this.cluster("cluster:admin/persistent/start");
        this.cluster("cluster:admin/persistent/update_status");
        this.cluster("cluster:admin/persistent/completion");
        this.cluster("cluster:admin/persistent/remove");
        this.cluster("cluster:admin/indices/dangling/list");
        this.cluster("cluster:admin/indices/dangling/import");
        this.cluster("cluster:admin/indices/dangling/delete");
        this.cluster("cluster:admin/indices/dangling/find");
        this.cluster("cluster:admin/snapshot/status[nodes]");
        this.open("indices:admin/seq_no/add_retention_lease");
        this.open("indices:admin/seq_no/renew_retention_lease");
        this.open("indices:admin/seq_no/remove_retention_lease");
        this.cluster(ConfigUpdateAction.INSTANCE);
        this.cluster(GetComponentStateAction.INSTANCE);
        this.cluster((ActionType<?>)BulkConfigApi.GetAction.INSTANCE);
        this.cluster((ActionType<?>)BulkConfigApi.UpdateAction.INSTANCE);
        this.cluster(ConfigVarRefreshAction.INSTANCE);
        this.cluster((ActionType<?>)ConfigVarApi.GetAction.INSTANCE);
        this.cluster((ActionType<?>)ConfigVarApi.UpdateAction.INSTANCE);
        this.cluster((ActionType<?>)ConfigVarApi.DeleteAction.INSTANCE);
        this.cluster((ActionType<?>)ConfigVarApi.GetAllAction.INSTANCE);
        this.cluster((ActionType<?>)ConfigVarApi.UpdateAllAction.INSTANCE);
        this.cluster((ActionType<?>)InternalUsersConfigApi.GetAction.INSTANCE);
        this.cluster((ActionType<?>)InternalUsersConfigApi.DeleteAction.INSTANCE);
        this.cluster((ActionType<?>)InternalUsersConfigApi.PutAction.INSTANCE);
        this.cluster((ActionType<?>)InternalUsersConfigApi.PatchAction.INSTANCE);
        this.cluster((ActionType<?>)GetActivatedFrontendConfigAction.INSTANCE);
        this.cluster((ActionType<?>)SessionApi.CreateAction.INSTANCE);
        this.cluster((ActionType<?>)SessionApi.DeleteAction.INSTANCE);
        this.cluster((ActionType<?>)SessionApi.GetExtendedInfoAction.INSTANCE);
        this.cluster("cluster:admin:searchguard:login/session");
        this.tenant("kibana:saved_objects/_/read");
        this.tenant("kibana:saved_objects/_/write");
        this.open("cluster:admin/searchguard/license/info");
        this.open(WhoAmIAction.INSTANCE);
        this.dataStream("indices:admin/data_stream/create");
        this.dataStream("indices:admin/data_stream/get");
        this.dataStream("indices:admin/data_stream/migrate");
        this.dataStream("indices:admin/data_stream/modify");
        this.dataStream("indices:admin/data_stream/promote");
        this.dataStream("indices:admin/data_stream/delete");
        this.dataStream("indices:monitor/data_stream/stats");
        if (modulesRegistry != null) {
            for (ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse> action : modulesRegistry.getActions()) {
                this.builder.action(action.getAction());
            }
        }
        this.actionMap = this.builder.build();
        ImmutableSet.Builder clusterActions = new ImmutableSet.Builder(this.actionMap.size());
        ImmutableSet.Builder indexLikeActions = new ImmutableSet.Builder(this.actionMap.size());
        ImmutableSet.Builder indexLikeActionsPerformanceCritical = new ImmutableSet.Builder(this.actionMap.size());
        ImmutableSet.Builder tenantActions = new ImmutableSet.Builder();
        ImmutableSet.Builder openActions = new ImmutableSet.Builder();
        ImmutableSet.Builder allActions = new ImmutableSet.Builder(this.actionMap.size());
        for (Action action : this.actionMap.values()) {
            if (action.isOpen()) {
                openActions.add((Object)((Action.WellKnownAction)action));
            } else if (action.isClusterPrivilege()) {
                clusterActions.add((Object)((Action.WellKnownAction)action));
            } else if (action.isTenantPrivilege()) {
                tenantActions.add((Object)((Action.WellKnownAction)action));
            } else {
                indexLikeActions.add((Object)((Action.WellKnownAction)action));
                if (((Action.WellKnownAction)action).isPerformanceCritical()) {
                    indexLikeActionsPerformanceCritical.add((Object)((Action.WellKnownAction)action));
                }
            }
            allActions.add((Object)((Action.WellKnownAction)action));
        }
        this.clusterActions = clusterActions.build();
        this.tenantActions = tenantActions.build();
        this.openActions = openActions.build();
        this.allActions = allActions.build();
        this.indexLikeActions = indexLikeActions.build();
        this.indexLikeActionsPerformanceCritical = indexLikeActionsPerformanceCritical.build();
    }

    public Action get(String actionName) {
        Action result = (Action)this.actionMap.get((Object)actionName);
        if (result != null) {
            return result;
        }
        return new Action.OtherAction(actionName, Actions.getScope(actionName));
    }

    public ImmutableSet<Action.WellKnownAction<?, ?, ?>> clusterActions() {
        return this.clusterActions;
    }

    public ImmutableSet<Action.WellKnownAction<?, ?, ?>> indexLikeActions() {
        return this.indexLikeActions;
    }

    public ImmutableSet<Action.WellKnownAction<?, ?, ?>> indexLikeActionsPerformanceCritical() {
        return this.indexLikeActionsPerformanceCritical;
    }

    public ImmutableSet<Action.WellKnownAction<?, ?, ?>> tenantActions() {
        return this.tenantActions;
    }

    public ImmutableSet<Action.WellKnownAction<?, ?, ?>> openActions() {
        return this.openActions;
    }

    public ImmutableSet<Action.WellKnownAction<?, ?, ?>> allActions() {
        return this.allActions;
    }

    private static Action.Scope getScope(String action) {
        if (action.startsWith("indices:admin/data_stream/")) {
            return Action.Scope.DATA_STREAM;
        }
        if (action.startsWith("cluster:admin:searchguard:tenant:") || action.startsWith("kibana:saved_objects/")) {
            return Action.Scope.TENANT;
        }
        if (action.startsWith("searchguard:cluster:") || action.startsWith("cluster:")) {
            return Action.Scope.CLUSTER;
        }
        return Action.Scope.INDEX_LIKE;
    }

    private <RequestType extends ActionRequest> ActionBuilder<RequestType, Void, Void> cluster(ActionType<?> actionType) {
        return this.builder.cluster(actionType);
    }

    private ActionBuilder<?, ?, ?> cluster(String action) {
        return this.builder.cluster(action);
    }

    private ActionBuilder<?, ?, ?> index(String action) {
        return this.builder.index(action);
    }

    private ActionBuilder<?, ?, ?> indexLike(String action) {
        return this.builder.indexLike(action);
    }

    private ActionBuilder<?, ?, ?> dataStream(String action) {
        return this.builder.dataStream(action);
    }

    private ActionBuilder<?, ?, ?> tenant(String action) {
        return this.builder.tenant(action);
    }

    private <RequestType extends ActionRequest> ActionBuilder<RequestType, Void, Void> open(ActionType<?> actionType) {
        return this.builder.open(actionType);
    }

    private ActionBuilder<?, ?, ?> open(String action) {
        return this.builder.open(action);
    }

    static <O> Function<O, Object> xContentAttr(String name) {
        return actionResponse -> AttributeValueFromXContent.get((ToXContent)XContentObjectConverter.convertOrNull((Object)actionResponse), (String)name);
    }

    static <O> Function<O, Instant> xContentInstantFromMillis(String name) {
        return actionResponse -> {
            Object value = AttributeValueFromXContent.get((ToXContent)XContentObjectConverter.convertOrNull((Object)actionResponse), (String)name);
            if (value instanceof Number) {
                return Instant.ofEpochMilli(((Number)value).longValue());
            }
            if (value == null) {
                return null;
            }
            throw new RuntimeException("Unexpected value " + value + " for attribute " + name);
        };
    }

    static <T> Predicate<T> ifNotEmpty(Function<T, Collection<?>> itemFunction) {
        return t -> {
            Collection items = (Collection)itemFunction.apply(t);
            return items != null && !items.isEmpty();
        };
    }

    static <Request extends ActionRequest> Predicate<Request> always() {
        return request -> true;
    }

    public static synchronized Actions forTests() {
        if (forTestsInstance == null) {
            LogConfigurator.configureESLogging();
            forTestsInstance = new Actions(null);
        }
        return forTestsInstance;
    }

    class Builder {
        private Map<String, ActionBuilder<?, ?, ?>> builders = new HashMap(300);

        Builder() {
        }

        <RequestType extends ActionRequest> ActionBuilder<RequestType, Void, Void> cluster(ActionType<?> actionType) {
            ActionBuilder builder = new ActionBuilder(actionType.name(), Action.Scope.CLUSTER);
            this.builders.put(actionType.name(), builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> cluster(String action) {
            ActionBuilder builder = new ActionBuilder(action, Action.Scope.CLUSTER);
            this.builders.put(action, builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> indexLike(ActionType<?> actionType) {
            ActionBuilder builder = new ActionBuilder(actionType.name(), Action.Scope.INDEX_LIKE);
            this.builders.put(actionType.name(), builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> indexLike(String action) {
            ActionBuilder builder = new ActionBuilder(action, Action.Scope.INDEX_LIKE);
            this.builders.put(action, builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> index(ActionType<?> actionType) {
            ActionBuilder builder = new ActionBuilder(actionType.name(), Action.Scope.INDEX);
            this.builders.put(actionType.name(), builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> index(String action) {
            ActionBuilder builder = new ActionBuilder(action, Action.Scope.INDEX);
            this.builders.put(action, builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> alias(ActionType<?> actionType) {
            ActionBuilder builder = new ActionBuilder(actionType.name(), Action.Scope.ALIAS);
            this.builders.put(actionType.name(), builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> dataStream(String action) {
            ActionBuilder builder = new ActionBuilder(action, Action.Scope.DATA_STREAM);
            this.builders.put(action, builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> tenant(String action) {
            ActionBuilder builder = new ActionBuilder(action, Action.Scope.TENANT);
            this.builders.put(action, builder);
            return builder;
        }

        <RequestType extends ActionRequest> ActionBuilder<RequestType, Void, Void> open(ActionType<?> actionType) {
            ActionBuilder builder = new ActionBuilder(actionType.name(), Action.Scope.OPEN);
            this.builders.put(actionType.name(), builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> open(String action) {
            ActionBuilder builder = new ActionBuilder(action, Action.Scope.OPEN);
            this.builders.put(action, builder);
            return builder;
        }

        ActionBuilder<?, ?, ?> action(ActionType<?> actionType) {
            ActionBuilder builder = new ActionBuilder(actionType.name(), Actions.getScope(actionType.name()));
            this.builders.put(actionType.name(), builder);
            return builder;
        }

        ImmutableMap<String, Action> build() {
            ImmutableMap.Builder result = new ImmutableMap.Builder(this.builders.size());
            for (ActionBuilder<?, ?, ?> builder : this.builders.values()) {
                Action action = builder.build();
                result.with((Object)builder.actionName, (Object)action);
            }
            this.builders = null;
            return result.build();
        }
    }

    class ActionBuilder<RequestType extends ActionRequest, RequestItem, RequestItemType> {
        private Class<RequestType> requestType;
        private String requestTypeName;
        private String actionName;
        private Class<Enum<?>> requestItemTypeEnum;
        private Action.WellKnownAction.NewResource createsResource;
        private List<Action.WellKnownAction.Resource> usesResources = new ArrayList<Action.WellKnownAction.Resource>();
        private List<Action.WellKnownAction.RequestPropertyModifier<?>> requestProperyModifiers = new ArrayList();
        private List<Action.WellKnownAction.AdditionalPrivileges<RequestType, RequestItem>> additionalPrivileges = new ArrayList<Action.WellKnownAction.AdditionalPrivileges<RequestType, RequestItem>>();
        private Map<RequestItemType, ImmutableSet<String>> additionalPrivilegesByItemType;
        private Action.Scope scope;
        private Function<RequestType, Collection<RequestItem>> requestItemFunction;
        private Function<RequestItem, RequestItemType> requestItemTypeFunction;
        private ActionAuthorization.AliasDataStreamHandling aliasDataStreamHandling = ActionAuthorization.AliasDataStreamHandling.RESOLVE_IF_NECESSARY;
        private Meta.Alias.ResolutionMode aliasResolutionMode = Meta.Alias.ResolutionMode.NORMAL;
        private ImmutableSet<Action.AdditionalDimension> additionalDimensions = ImmutableSet.empty();
        private boolean performanceCritical = false;

        ActionBuilder(String actionName, Action.Scope scope) {
            this.actionName = actionName;
            this.scope = scope;
        }

        <NewRequestType extends ActionRequest> ActionBuilder<NewRequestType, RequestItem, RequestItemType> requestType(Class<NewRequestType> requestType) {
            if (this.requestType != null && !this.requestType.equals(requestType)) {
                throw new IllegalStateException("Request type was already set: " + requestType + " vs " + this.requestType);
            }
            ActionBuilder newRequestTypeBuilder = this;
            newRequestTypeBuilder.requestType = requestType;
            return newRequestTypeBuilder;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> requestType(String requestType) {
            try {
                this.requestType = Class.forName(requestType);
            }
            catch (ClassNotFoundException e) {
                this.requestTypeName = requestType;
            }
            return this;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> performanceCritical() {
            this.performanceCritical = true;
            return this;
        }

        <NewRequestItem> ActionBuilder<RequestType, NewRequestItem, RequestItemType> requestItems(Function<RequestType, Collection<NewRequestItem>> function) {
            ActionBuilder newRequestTypeBuilder = this;
            newRequestTypeBuilder.requestItemFunction = function;
            return newRequestTypeBuilder;
        }

        <NewRequestItem, NewRequestItemType> ActionBuilder<RequestType, NewRequestItem, NewRequestItemType> requestItems(Function<RequestType, Collection<NewRequestItem>> function, Function<NewRequestItem, NewRequestItemType> requestItemTypeFunction) {
            ActionBuilder newRequestTypeBuilder = this;
            newRequestTypeBuilder.requestItemFunction = function;
            newRequestTypeBuilder.requestItemTypeFunction = requestItemTypeFunction;
            return newRequestTypeBuilder;
        }

        <NewRequestItem, NewRequestItemType> ActionBuilder<RequestType, NewRequestItem, NewRequestItemType> requestItemsA(Function<RequestType, NewRequestItem[]> function, Function<NewRequestItem, NewRequestItemType> requestItemTypeFunction) {
            ActionBuilder newRequestTypeBuilder = this;
            newRequestTypeBuilder.requestItemFunction = r -> Arrays.asList((Object[])function.apply(r));
            newRequestTypeBuilder.requestItemTypeFunction = requestItemTypeFunction;
            return newRequestTypeBuilder;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> requiresAdditionalPrivileges(Predicate<RequestType> condition, String privilege, String ... morePrivileges) {
            this.additionalPrivileges.add(new Action.WellKnownAction.AdditionalPrivileges((ImmutableSet<String>)ImmutableSet.of((Object)privilege, (Object[])morePrivileges), condition));
            return this;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> requiresAdditionalPrivilegesForItemType(RequestItemType requestItemType, String privilege, String ... morePrivileges) {
            ImmutableSet<String> existingPrivileges;
            ImmutableSet privileges = ImmutableSet.of((Object)privilege, (Object[])morePrivileges);
            if (this.additionalPrivilegesByItemType == null) {
                if (Enum.class.isAssignableFrom(requestItemType.getClass())) {
                    Class<?> requestItemTypeClass = requestItemType.getClass();
                    EnumMap additionalPrivilegesByItemType = new EnumMap(requestItemTypeClass);
                    this.additionalPrivilegesByItemType = additionalPrivilegesByItemType;
                    Class<?> enumClass = requestItemType.getClass();
                    this.requestItemTypeEnum = enumClass;
                } else {
                    this.additionalPrivilegesByItemType = new HashMap<RequestItemType, ImmutableSet<String>>();
                }
            }
            if ((existingPrivileges = this.additionalPrivilegesByItemType.get(requestItemType)) == null) {
                this.additionalPrivilegesByItemType.put(requestItemType, (ImmutableSet<String>)privileges);
            } else {
                this.additionalPrivilegesByItemType.put(requestItemType, (ImmutableSet<String>)privileges.with(existingPrivileges));
            }
            return this;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> additionalDimensions(Action.AdditionalDimension ... additionalDimensions) {
            this.additionalDimensions = ImmutableSet.ofArray((Object[])additionalDimensions);
            return this;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> createsResource(String type, Function<ActionResponse, Object> id, Function<ActionResponse, Instant> expiresAfter) {
            this.createsResource = new Action.WellKnownAction.NewResource(type, id, expiresAfter);
            return this;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> uses(Action.WellKnownAction.Resource resource) {
            this.usesResources.add(resource);
            return this;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> deletes(Action.WellKnownAction.Resource resource) {
            this.usesResources.add(resource.deleteAction(true));
            return this;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> doNotResolveAliasesOrDataStreams() {
            this.aliasDataStreamHandling = ActionAuthorization.AliasDataStreamHandling.DO_NOT_RESOLVE;
            return this;
        }

        ActionBuilder<RequestType, RequestItem, RequestItemType> aliasesResolveToWriteTarget() {
            this.aliasResolutionMode = Meta.Alias.ResolutionMode.TO_WRITE_TARGET;
            return this;
        }

        <PropertyType> ActionBuilder<RequestType, RequestItem, RequestItemType> setRequestProperty(String name, Class<PropertyType> type, Function<PropertyType, PropertyType> function) {
            this.requestProperyModifiers.add(new Action.WellKnownAction.RequestPropertyModifier<PropertyType>(ReflectiveAttributeAccessors.objectAttr((String)name, type), ReflectiveAttributeAccessors.setObjectAttr((String)name, type), type, function));
            return this;
        }

        Action build() {
            Action.WellKnownAction.Resources resources = null;
            if (this.createsResource != null || !this.usesResources.isEmpty()) {
                resources = new Action.WellKnownAction.Resources(this.createsResource, this.usesResources);
            }
            Action.WellKnownAction.RequestItems<RequestType, RequestItem, RequestItemType> requestItems = null;
            if (this.requestItemTypeFunction != null || this.requestItemTypeEnum != null || this.requestItemTypeFunction != null) {
                requestItems = new Action.WellKnownAction.RequestItems<RequestType, RequestItem, RequestItemType>(this.requestItemTypeFunction, this.requestItemFunction, this.additionalPrivilegesByItemType, this.requestItemTypeEnum, Actions.this);
            }
            return new Action.WellKnownAction<RequestType, RequestItem, RequestItemType>(this.actionName, this.scope, this.requestType, this.requestTypeName, ImmutableList.of(this.additionalPrivileges), this.additionalPrivilegesByItemType != null ? ImmutableMap.of(this.additionalPrivilegesByItemType) : ImmutableMap.empty(), requestItems, resources, this.aliasDataStreamHandling, this.aliasResolutionMode, this.additionalDimensions, this.performanceCritical, Actions.this);
        }
    }
}

