/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.codova.config.templates.PipeExpression;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;

class BcryptPipeFunction
implements PipeExpression.PipeFunction {
    public static final String NAME = "bcrypt";
    private final int cost;
    private final Supplier<byte[]> saltSupplier;

    BcryptPipeFunction(int cost, Supplier<byte[]> saltSupplier) {
        this.cost = cost;
        this.saltSupplier = Objects.requireNonNull(saltSupplier, "Salt supplier is required");
    }

    public BcryptPipeFunction() {
        this(12, () -> {
            byte[] salt = new byte[16];
            new SecureRandom().nextBytes(salt);
            return salt;
        });
    }

    public Object apply(Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            return this.bcrypt(stringValue);
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(v -> this.apply(v)).collect(Collectors.toList());
        }
        if (value == null) {
            return null;
        }
        return this.apply(value.toString());
    }

    private String bcrypt(String string) {
        byte[] salt = this.saltSupplier.get();
        return OpenBSDBCrypt.generate((char[])string.toCharArray(), (byte[])salt, (int)this.cost);
    }
}

