/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.codova.config.templates.PipeExpression;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocUpdateException;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.codova.documents.patch.PatchableDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.VariableResolvers;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchguard.SearchGuardModulesRegistry;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.configuration.BcryptPipeFunction;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConcurrentConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigUnavailableException;
import com.floragunn.searchguard.configuration.ConfigUpdateAlreadyInProgressException;
import com.floragunn.searchguard.configuration.ConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationLoader;
import com.floragunn.searchguard.configuration.NoSuchConfigEntryException;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.StaticSgConfig;
import com.floragunn.searchguard.configuration.validation.ConfigModificationValidators;
import com.floragunn.searchguard.configuration.variables.ConfigVarService;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.xcontent.XContentParserContext;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;

public class ConfigurationRepository
implements ComponentStateProvider {
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationRepository.class);
    private static final String OLD_INDEX_NAME_DEFAULT = "searchguard";
    private static final String NEW_INDEX_NAME_DEFAULT = ".searchguard";
    private static final StaticSettings.Attribute<String> OLD_INDEX_NAME = StaticSettings.Attribute.define((String)"searchguard.config_index_name").withDefault("searchguard").asString();
    private static final StaticSettings.Attribute<String> NEW_INDEX_NAME = StaticSettings.Attribute.define((String)"searchguard.config_repository.index_name").withDefault(".searchguard").asString();
    private static final StaticSettings.Attribute<Boolean> ALLOW_DEFAULT_INIT_SGINDEX = StaticSettings.Attribute.define((String)"searchguard.allow_default_init_sgindex").withDefault(false).asBoolean();
    private static final StaticSettings.Attribute<Boolean> BACKGROUND_INIT_IF_SGINDEX_NOT_EXIST = StaticSettings.Attribute.define((String)"searchguard.background_init_if_sgindex_not_exist").withDefault(true).asBoolean();
    public static final StaticSettings.AttributeSet STATIC_SETTINGS = StaticSettings.AttributeSet.of((StaticSettings.Attribute[])new StaticSettings.Attribute[]{OLD_INDEX_NAME, NEW_INDEX_NAME, ALLOW_DEFAULT_INIT_SGINDEX, BACKGROUND_INIT_IF_SGINDEX_NOT_EXIST});
    private final String configuredSearchguardIndexOld;
    private final String configuredSearchguardIndexNew;
    private final Pattern configuredSearchguardIndices;
    private final Client client;
    private volatile ConfigMap currentConfig;
    private final List<ConfigurationChangeListener> configurationChangedListener;
    private final ConfigurationLoader mainConfigLoader;
    private final ConfigurationLoader externalUseConfigLoader;
    private final StaticSettings settings;
    private final ClusterService clusterService;
    private final ComponentState componentState = new ComponentState(-1000, null, "config_repository", ConfigurationRepository.class);
    private final PrivilegedConfigClient privilegedConfigClient;
    private final ThreadPool threadPool;
    public static final ImmutableMap<String, Object> SG_INDEX_MAPPING = ImmutableMap.of((Object)"dynamic_templates", Collections.singletonList(ImmutableMap.of((Object)"encoded_config", (Object)ImmutableMap.of((Object)"match", (Object)"*", (Object)"match_mapping_type", (Object)"*", (Object)"mapping", (Object)ImmutableMap.of((Object)"type", (Object)"binary")))));
    private static final ImmutableMap<String, Object> SG_INDEX_SETTINGS = ImmutableMap.of((Object)"index.number_of_shards", (Object)1, (Object)"index.auto_expand_replicas", (Object)"0-all");
    private final VariableResolvers variableResolvers;
    private final Context parserContext;
    private final IndexNameExpressionResolver resolver;
    private final ConfigModificationValidators configModificationValidators;
    private final Lock LOCK = new ReentrantLock();

    public ConfigurationRepository(StaticSettings settings, ThreadPool threadPool, Client client, ClusterService clusterService, ConfigVarService configVarService, SearchGuardModulesRegistry modulesRegistry, StaticSgConfig staticSgConfig, NamedXContentRegistry xContentRegistry, Environment environment, IndexNameExpressionResolver resolver, ConfigModificationValidators configModificationValidators) {
        this.configuredSearchguardIndexOld = (String)settings.get(OLD_INDEX_NAME);
        this.configuredSearchguardIndexNew = (String)settings.get(NEW_INDEX_NAME);
        this.configuredSearchguardIndices = Pattern.createUnchecked((String)this.configuredSearchguardIndexNew, (String)this.configuredSearchguardIndexOld, (String[])new String[0]);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.configurationChangedListener = new ArrayList<ConfigurationChangeListener>();
        this.privilegedConfigClient = PrivilegedConfigClient.adapt(client);
        this.componentState.setMandatory(true);
        this.mainConfigLoader = new ConfigurationLoader(client, this.componentState, this, staticSgConfig);
        this.externalUseConfigLoader = new ConfigurationLoader(client, null, this, null);
        this.variableResolvers = new VariableResolvers().with("file", file -> VariableResolvers.FILE_PRIVILEGED.apply((Object)environment.configFile().resolve((String)file).toAbsolutePath().toString())).with("env", VariableResolvers.ENV).with("var", key -> configVarService.get((String)key)).with("json_file", file -> VariableResolvers.JSON_FILE_PRIVILEGED.apply((Object)environment.configFile().resolve((String)file).toAbsolutePath().toString()));
        ImmutableMap pipeFunctions = PipeExpression.PipeFunction.all().with((Object)"bcrypt", (Object)new BcryptPipeFunction());
        this.parserContext = new Context(this.variableResolvers, modulesRegistry, settings, xContentRegistry, (ImmutableMap<String, PipeExpression.PipeFunction>)pipeFunctions);
        this.threadPool = threadPool;
        configVarService.addChangeListener(() -> {
            if (this.currentConfig != null) {
                try {
                    this.reloadConfiguration(CType.all(), "Config variable update");
                }
                catch (Exception e) {
                    LOGGER.error("Error while reloading configuration after config var change", (Throwable)e);
                }
            }
        });
        this.resolver = resolver;
        this.configModificationValidators = configModificationValidators;
    }

    public void initOnNodeStart() {
        this.componentState.setState(ComponentState.State.INITIALIZING, "waiting_for_state_recovery");
        this.threadPool.generic().execute(() -> {
            ConfigurationRepository configurationRepository = this;
            synchronized (configurationRepository) {
                if (!this.checkClusterState(this.clusterService.state())) {
                    this.clusterService.addListener(new ClusterStateListener(){

                        public void clusterChanged(ClusterChangedEvent event) {
                            if (ConfigurationRepository.this.checkClusterState(event.state())) {
                                ConfigurationRepository.this.clusterService.removeListener((ClusterStateListener)this);
                            }
                        }
                    });
                }
            }
        });
    }

    private boolean checkClusterState(ClusterState clusterState) {
        if (!clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.componentState.setState(ComponentState.State.INITIALIZING, "cluster_state_recovered");
            LOGGER.info("Cluster state has been recovered. Starting config index initialization.");
            this.checkIndicesNow();
            return true;
        }
        return false;
    }

    private void checkIndicesNow() {
        LOGGER.debug("Check if one of the indices " + this.configuredSearchguardIndexNew + " or " + this.configuredSearchguardIndexOld + " does exist ...");
        try {
            if (this.resolver.hasIndexAbstraction(this.configuredSearchguardIndexNew, this.clusterService.state())) {
                LOGGER.info("{} index does exist. Loading configuration.", (Object)this.configuredSearchguardIndexNew);
                this.threadPool.generic().submit(() -> this.loadConfigurationOnStartup(this.configuredSearchguardIndexNew));
            } else if (this.resolver.hasIndexAbstraction(this.configuredSearchguardIndexOld, this.clusterService.state())) {
                LOGGER.info("Legacy {} index does exist. Loading configuration.", (Object)this.configuredSearchguardIndexOld);
                this.threadPool.generic().submit(() -> this.loadConfigurationOnStartup(this.configuredSearchguardIndexOld));
            } else if (((Boolean)this.settings.get(ALLOW_DEFAULT_INIT_SGINDEX)).booleanValue()) {
                LOGGER.info("{} index does not exist yet, so we create a default config", (Object)this.configuredSearchguardIndexNew);
                this.threadPool.generic().submit(() -> {
                    try {
                        this.installDefaultConfiguration(this.configuredSearchguardIndexNew);
                        this.loadConfigurationOnStartup(this.configuredSearchguardIndexNew);
                    }
                    catch (Exception e) {
                        LOGGER.error("An error occurred while initializing default config. Initialisation halted.", (Throwable)e);
                    }
                });
            } else if (((Boolean)this.settings.get(BACKGROUND_INIT_IF_SGINDEX_NOT_EXIST)).booleanValue()) {
                LOGGER.info("{} index does not exist yet, so no need to load config on node startup. Use sgctl to initialize cluster", (Object)this.configuredSearchguardIndexNew);
                this.threadPool.generic().submit(() -> this.waitForConfigIndex());
            } else {
                LOGGER.info("{} index does not exist yet, use sgctl to initialize the cluster. We will not perform background initialization", (Object)this.configuredSearchguardIndexNew);
                this.componentState.setState(ComponentState.State.SUSPENDED, "waiting_for_config_update");
            }
        }
        catch (Throwable e2) {
            LOGGER.error("Error during node initialization", e2);
            this.componentState.addLastException("initOnNodeStart", e2);
            this.componentState.setFailed(e2);
        }
    }

    public <T> SgDynamicConfiguration<T> getConfiguration(CType<T> configurationType) {
        if (this.currentConfig == null) {
            throw new RuntimeException("ConfigurationRepository is not yet initialized");
        }
        return this.currentConfig.get(configurationType);
    }

    public boolean isInitialized() {
        return this.currentConfig != null;
    }

    public boolean isIndexInitialized() {
        return this.getEffectiveSearchGuardIndex() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadConfiguration(Set<CType<?>> configTypes, String reason) throws ConfigUpdateAlreadyInProgressException, ConfigUnavailableException {
        block12: {
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                if (this.LOCK.tryLock(60L, TimeUnit.SECONDS)) {
                    try {
                        this.reloadConfiguration0(configTypes, reason);
                        break block12;
                    }
                    finally {
                        this.LOCK.unlock();
                    }
                }
                throw new ConfigUpdateAlreadyInProgressException("A config update is already in progress", new Object[0]);
            }
            catch (InterruptedException e) {
                throw new ConfigUpdateAlreadyInProgressException("Interrupted config update", e, new Object[0]);
            }
        }
    }

    private void waitForConfigIndex() {
        try {
            this.componentState.setState(ComponentState.State.INITIALIZING, "waiting_for_config_index");
            do {
                Thread.sleep(500L);
            } while (!this.resolver.hasIndexAbstraction(this.configuredSearchguardIndexNew, this.clusterService.state()) && !this.resolver.hasIndexAbstraction(this.configuredSearchguardIndexOld, this.clusterService.state()));
            if (this.resolver.hasIndexAbstraction(this.configuredSearchguardIndexNew, this.clusterService.state())) {
                this.loadConfigurationOnStartup(this.configuredSearchguardIndexNew);
            } else {
                this.loadConfigurationOnStartup(this.configuredSearchguardIndexOld);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while waiting for the configuration index to be created", (Throwable)e);
            this.componentState.setFailed((Throwable)e);
        }
    }

    private void loadConfigurationOnStartup(String searchguardIndex) {
        try {
            LOGGER.debug("Node started, try to initialize it. Wait for at least yellow state on index " + searchguardIndex);
            this.componentState.setState(ComponentState.State.INITIALIZING, "waiting_for_yellow_index");
            this.componentState.setConfigProperty("effective_main_config_index", (Object)searchguardIndex);
            ClusterHealthResponse response = null;
            TimeValue masterNodeTimeout = TimeValue.timeValueSeconds((long)30L);
            try {
                response = (ClusterHealthResponse)this.client.admin().cluster().health(new ClusterHealthRequest(masterNodeTimeout, new String[]{searchguardIndex}).waitForActiveShards(1).waitForYellowStatus()).actionGet();
            }
            catch (Exception e1) {
                LOGGER.debug("Catched a {} but we just try again ...", (Object)e1.toString());
            }
            while (response == null || response.isTimedOut() || response.getStatus() == ClusterHealthStatus.RED) {
                LOGGER.debug("index '{}' not healthy yet, we try again ... (Reason: {})", (Object)searchguardIndex, (Object)(response == null ? "no response" : (response.isTimedOut() ? "timeout" : "other, maybe red cluster")));
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(Strings.toString((ToXContent)response));
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                this.componentState.startNextTry();
                try {
                    response = (ClusterHealthResponse)this.client.admin().cluster().health(new ClusterHealthRequest(masterNodeTimeout, new String[]{searchguardIndex}).waitForActiveShards(1).waitForYellowStatus()).actionGet();
                }
                catch (Exception e1) {
                    LOGGER.debug("Catched again a {} but we just try again ...", (Object)e1.toString());
                }
            }
            int maxAttempts = 30;
            long requiredDocCount = CType.all().stream().filter(cType -> cType.isRequired()).count();
            this.componentState.setState(ComponentState.State.INITIALIZING, "waiting_for_docs_in_index");
            long docCount = 0L;
            for (int attempts = 0; docCount < requiredDocCount && attempts < 30; ++attempts) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    LOGGER.debug("Thread was interrupted so we cancel initialization");
                    break;
                }
                try {
                    Map aliasMetadata = ((GetAliasesResponse)this.client.admin().indices().getAliases(new GetAliasesRequest(new String[]{searchguardIndex})).actionGet()).getAliases();
                    if (aliasMetadata != null && aliasMetadata.size() == 1) {
                        String indexName = (String)aliasMetadata.keySet().iterator().next();
                        LOGGER.info("Resolved alias '{}' to index '{}' for looking up doc count", (Object)searchguardIndex, (Object)indexName);
                        this.client.admin().indices().refresh(new RefreshRequest(new String[]{indexName})).get();
                        docCount = ((IndicesStatsResponse)this.client.admin().indices().stats((IndicesStatsRequest)((IndicesStatsRequest)new IndicesStatsRequest().indices((String[])new String[]{indexName})).docs((boolean)true)).actionGet()).getIndex((String)indexName).getTotal().docs.getCount();
                    } else {
                        this.client.admin().indices().refresh(new RefreshRequest(new String[]{searchguardIndex})).get();
                        docCount = ((IndicesStatsResponse)this.client.admin().indices().stats((IndicesStatsRequest)((IndicesStatsRequest)new IndicesStatsRequest().indices((String[])new String[]{searchguardIndex})).docs((boolean)true)).actionGet()).getIndex((String)searchguardIndex).getTotal().docs.getCount();
                    }
                    if (docCount >= requiredDocCount) break;
                    LOGGER.info("Got {} documents, waiting for {} in total, we just try again ...", (Object)docCount, (Object)requiredDocCount);
                    continue;
                }
                catch (Exception e1) {
                    LOGGER.warn("Catched a {} but we just try again ...", (Object)e1.toString());
                }
            }
            this.componentState.setState(ComponentState.State.INITIALIZING, "loading");
            while (this.currentConfig == null) {
                this.componentState.startNextTry();
                try {
                    LOGGER.debug("Try to load config ...");
                    this.reloadConfiguration(CType.all(), "Initialization");
                }
                catch (Exception e) {
                    LOGGER.debug("Unable to load configuration due to {}", (Object)String.valueOf(ExceptionUtils.getRootCause((Throwable)e)));
                    try {
                        Thread.sleep(3000L);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("Thread was interrupted so we cancel initialization");
                    }
                }
                break;
            }
            LOGGER.info("Node '{}' initialized", (Object)this.clusterService.localNode().getName());
            this.componentState.setInitialized();
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception while initializing node " + e, (Throwable)e);
            this.componentState.setFailed((Throwable)e);
        }
    }

    private void installDefaultConfiguration(String searchguardIndex) throws ConfigUpdateException {
        block11: {
            try {
                this.componentState.setState(ComponentState.State.INITIALIZING, "install_default_config");
                String lookupDir = System.getProperty("sg.default_init.dir");
                File cd = lookupDir != null ? new File(lookupDir) : this.settings.getPlatformPluginsDirectory().resolve("search-guard-flx/sgconfig/").toAbsolutePath().toFile();
                File confFile = new File(cd, "sg_authc.yml");
                File legacyConfFile = new File(cd, "sg_config.yml");
                if (!confFile.exists() && !legacyConfFile.exists()) break block11;
                LOGGER.info("Will create {} index so we can apply default config", (Object)searchguardIndex);
                try {
                    this.createConfigIndex(searchguardIndex);
                }
                catch (ResourceAlreadyExistsException e) {
                    LOGGER.debug("Search Guard index was created in the meantime. Possibly by some other node in the cluster. Not applying default config", (Throwable)e);
                }
                if (new File(cd, "sg_authc.yml").exists()) {
                    ConfigurationRepository.uploadFile((Client)this.privilegedConfigClient, cd, "sg_authc.yml", searchguardIndex, CType.AUTHC, this.parserContext);
                } else if (new File(cd, "sg_config.yml").exists()) {
                    ConfigurationRepository.uploadFile((Client)this.privilegedConfigClient, cd, "sg_config.yml", searchguardIndex, CType.CONFIG, this.parserContext);
                }
                ConfigurationRepository.uploadFile((Client)this.privilegedConfigClient, cd, "sg_roles.yml", searchguardIndex, CType.ROLES, this.parserContext);
                ConfigurationRepository.uploadFile((Client)this.privilegedConfigClient, cd, "sg_roles_mapping.yml", searchguardIndex, CType.ROLESMAPPING, this.parserContext);
                ConfigurationRepository.uploadFile((Client)this.privilegedConfigClient, cd, "sg_internal_users.yml", searchguardIndex, CType.INTERNALUSERS, this.parserContext);
                ConfigurationRepository.uploadFile((Client)this.privilegedConfigClient, cd, "sg_action_groups.yml", searchguardIndex, CType.ACTIONGROUPS, this.parserContext);
                ConfigurationRepository.uploadFile((Client)this.privilegedConfigClient, cd, "sg_tenants.yml", searchguardIndex, CType.TENANTS, this.parserContext);
                ConfigurationRepository.uploadFile((Client)this.privilegedConfigClient, cd, "sg_frontend_authc.yml", searchguardIndex, CType.FRONTEND_AUTHC, this.parserContext);
                if (new File(cd, "sg_blocks.yml").exists()) {
                    ConfigurationRepository.uploadFile((Client)this.privilegedConfigClient, cd, "sg_blocks.yml", searchguardIndex, CType.BLOCKS, this.parserContext);
                }
                if (new File(cd, "sg_authz.yml").exists()) {
                    ConfigurationRepository.uploadFile((Client)this.privilegedConfigClient, cd, "sg_authz.yml", searchguardIndex, CType.AUTHZ, this.parserContext);
                }
                if (new File(cd, "sg_license_key.yml").exists()) {
                    ConfigurationRepository.uploadFile((Client)this.privilegedConfigClient, cd, "sg_license_key.yml", searchguardIndex, CType.LICENSE_KEY, this.parserContext);
                }
                LOGGER.info("Default config applied");
            }
            catch (ConfigUpdateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigUpdateException("Error while installing default configuration: " + e.getMessage(), e);
            }
        }
    }

    private void createConfigIndex(String searchguardIndex) throws ConfigUpdateException {
        boolean ok;
        ImmutableMap indexSettings = SG_INDEX_SETTINGS;
        if (searchguardIndex.startsWith(".")) {
            indexSettings = indexSettings.with((Object)"index.hidden", (Object)true);
        }
        if (!(ok = ((CreateIndexResponse)this.client.admin().indices().create(new CreateIndexRequest(searchguardIndex).settings((Map)indexSettings).mapping(SG_INDEX_MAPPING)).actionGet()).isAcknowledged())) {
            LOGGER.error("Can not create {} index", (Object)searchguardIndex);
            this.componentState.setFailed("Index creation was not acknowledged");
            throw new ConfigUpdateException("Creation of " + searchguardIndex + " was not acknowledged");
        }
    }

    public String getEffectiveSearchGuardIndex() {
        if (this.resolver.hasIndexAbstraction(this.configuredSearchguardIndexNew, this.clusterService.state())) {
            return this.configuredSearchguardIndexNew;
        }
        if (this.resolver.hasIndexAbstraction(this.configuredSearchguardIndexOld, this.clusterService.state())) {
            return this.configuredSearchguardIndexOld;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardResponse migrateIndex() {
        BulkRequest bulkRequest;
        String effectiveSearchGuardIndex = this.getEffectiveSearchGuardIndex();
        if (effectiveSearchGuardIndex == null) {
            return new StandardResponse(503, "Search Guard is not initialized; the config index does not exist.");
        }
        if (this.configuredSearchguardIndexNew.equals(effectiveSearchGuardIndex)) {
            return new StandardResponse(412, "Search Guard already uses the new-style index: " + effectiveSearchGuardIndex);
        }
        PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt(this.client);
        SearchResponse searchResponse = null;
        try {
            try {
                searchResponse = (SearchResponse)privilegedConfigClient.search(new SearchRequest(new String[]{effectiveSearchGuardIndex}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(1000))).actionGet();
                if (searchResponse.getHits().getHits().length == 0) {
                    throw new Exception("Search request returned too few entries: " + Strings.toString((ChunkedToXContent)searchResponse));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while reading data from existing index for migration", (Throwable)e);
                StandardResponse standardResponse = new StandardResponse(500, "Error while reading data from old index: " + e.getMessage());
                if (searchResponse != null) {
                    searchResponse.decRef();
                }
                return standardResponse;
            }
            try {
                this.createConfigIndex(this.configuredSearchguardIndexNew);
            }
            catch (Exception e) {
                LOGGER.error("Error while creating new index for migration", (Throwable)e);
                StandardResponse standardResponse = new StandardResponse(500, e.getMessage());
                if (searchResponse != null) {
                    searchResponse.decRef();
                }
                return standardResponse;
            }
            bulkRequest = new BulkRequest(this.configuredSearchguardIndexNew).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            for (SearchHit searchHit : searchResponse.getHits().getHits()) {
                bulkRequest.add(new IndexRequest(this.configuredSearchguardIndexNew).id(searchHit.getId()).source(searchHit.getSourceRef(), XContentType.JSON));
            }
        }
        finally {
            if (searchResponse != null) {
                searchResponse.decRef();
            }
        }
        try {
            BulkResponse bulkResponse = (BulkResponse)privilegedConfigClient.bulk(bulkRequest).actionGet();
            if (bulkResponse.hasFailures()) {
                throw new ConfigUpdateException("Update failed: " + bulkResponse.buildFailureMessage());
            }
            ConfigMap configMap = this.externalUseConfigLoader.loadSync(CType.all(), "Testing configuration after migration", this.parserContext);
            LOGGER.info("Configuration after migration: " + configMap);
            if (!configMap.getTypes().equals(this.currentConfig.getTypes())) {
                throw new Exception("Validation of migrated configuration failed");
            }
            ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0]));
            ConfigUpdateResponse configUpdateResponse = (ConfigUpdateResponse)((Object)privilegedConfigClient.execute(ConfigUpdateAction.INSTANCE, (ActionRequest)configUpdateRequest).actionGet());
            if (!configUpdateResponse.hasFailures()) {
                return new StandardResponse(200, "Index migration and configuration update was successful").data((Object)ImmutableMap.of((Object)"new_config", (Object)configMap.toString()));
            }
            return new StandardResponse(500, "Index migration was successful; however, some nodes reported failures. Please check these nodes.").data((Object)ImmutableMap.of((Object)"failures", (Object)configUpdateResponse.failures().toString()));
        }
        catch (Exception e) {
            LOGGER.error("Error while doing builk write for migration. Deleting index again", (Throwable)e);
            try {
                privilegedConfigClient.admin().indices().delete(new DeleteIndexRequest(this.configuredSearchguardIndexNew)).actionGet();
            }
            catch (Exception e2) {
                LOGGER.error("Error while deleting new search guard index due to previous error", (Throwable)e2);
            }
            return new StandardResponse(500, e.getMessage());
        }
    }

    public boolean usesLegacySearchGuardIndex() {
        return this.configuredSearchguardIndexOld.equals(this.getEffectiveSearchGuardIndex());
    }

    public String getEffectiveSearchGuardIndexAndCreateIfNecessary() throws ConfigUpdateException {
        String searchGuardIndex = this.getEffectiveSearchGuardIndex();
        if (searchGuardIndex != null) {
            return searchGuardIndex;
        }
        this.createConfigIndex(this.configuredSearchguardIndexNew);
        return this.configuredSearchguardIndexNew;
    }

    private void reloadConfiguration0(Set<CType<?>> configTypes, String reason) throws ConfigUnavailableException {
        try {
            ConfigMap discardedConfig;
            ConfigMap loadedConfig = this.mainConfigLoader.load(configTypes, reason, this.parserContext.withExternalResources()).get();
            boolean initialLoad = false;
            this.componentState.setConfigProperty("effective_main_config_index", (Object)loadedConfig.getSourceIndex());
            if (this.currentConfig == null) {
                this.currentConfig = loadedConfig;
                initialLoad = true;
                discardedConfig = null;
            } else {
                ConfigMap oldConfig = this.currentConfig;
                ConfigMap mergedConfig = oldConfig.with(loadedConfig);
                discardedConfig = oldConfig.only((Set<CType<?>>)loadedConfig.getTypes());
                this.currentConfig = mergedConfig;
            }
            this.notifyAboutChanges(this.currentConfig);
            if (initialLoad) {
                LOGGER.info("Search Guard configuration has been successfully initialized");
            }
            if (discardedConfig != null && !discardedConfig.isEmpty()) {
                this.threadPool.schedule(() -> {
                    LOGGER.debug("Destroying old configuration: " + discardedConfig);
                    discardedConfig.close();
                }, TimeValue.timeValueSeconds((long)10L), (Executor)this.threadPool.generic());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for configuration", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ConfigUnavailableException) {
                throw (ConfigUnavailableException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public synchronized void subscribeOnChange(ConfigurationChangeListener listener) {
        this.configurationChangedListener.add(listener);
    }

    private synchronized void notifyAboutChanges(ConfigMap configMap) {
        for (ConfigurationChangeListener listener : this.configurationChangedListener) {
            try {
                LOGGER.debug("Notify {} listener about change configuration with type {}", (Object)listener);
                listener.onChange(configMap);
            }
            catch (Exception e) {
                LOGGER.error("{} listener errored: " + e, (Object)listener, (Object)e);
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
        }
    }

    public <T> SgDynamicConfiguration<T> getConfigurationFromIndex(CType<T> configType, String reason) throws ConfigUnavailableException {
        return this.externalUseConfigLoader.loadSync(configType, reason, this.parserContext);
    }

    public <T> StandardResponse addOrUpdate(CType<T> ctype, String id, T entry, String matchETag) throws ConfigUpdateException, ConcurrentConfigUpdateException, ConfigValidationException {
        try {
            ValidationErrors validationErrors = new ValidationErrors();
            validationErrors.add(this.configModificationValidators.validateConfigEntry(entry));
            validationErrors.throwExceptionForPresentErrors();
            SgDynamicConfiguration<T> configInstance = this.getConfigurationFromIndex(ctype, "Update of entry " + id);
            if (matchETag != null && !configInstance.getETag().equals(matchETag)) {
                throw new ConcurrentConfigUpdateException("Unable to update configuration due to concurrent modification:\nIf-Match: " + matchETag + "; ETag: " + configInstance.getETag());
            }
            boolean alreadyExists = configInstance.getCEntry(id) != null;
            configInstance = configInstance.with(id, entry);
            this.update(ctype, configInstance, matchETag, false);
            if (!alreadyExists) {
                return new StandardResponse(201).message(ctype.getUiName() + " " + id + " has been created");
            }
            return new StandardResponse(200).message(ctype.getUiName() + " " + id + " has been updated");
        }
        catch (ConfigUnavailableException e) {
            throw new ConfigUpdateException(e);
        }
    }

    public <T> StandardResponse applyPatch(final CType<T> configType, DocPatch patch, String matchETag) throws ConfigUpdateException, ConcurrentConfigUpdateException, NoSuchConfigEntryException, ConfigValidationException {
        try {
            if (configType.getArity() == CType.Arity.SINGLE) {
                return this.applyPatch(configType, "default", patch, matchETag, PatchDefaultHandling.TREAT_MISSING_DOCUMENT_AS_EMPTY_DOCUMENT);
            }
            final SgDynamicConfiguration<T> configInstance = this.getConfigurationFromIndex(configType, "Update of entry");
            if (matchETag != null && !configInstance.getETag().equals(matchETag)) {
                throw new ConcurrentConfigUpdateException("Unable to update configuration due to concurrent modification:\nIf-Match: " + matchETag + "; ETag: " + configInstance.getETag());
            }
            PatchableDocument doc = new PatchableDocument<Map<String, T>>(){

                public Object toBasicObject() {
                    return configInstance.toBasicObject();
                }

                public Map<String, T> parseI(DocNode docNode, Parser.Context context) throws ConfigValidationException {
                    ValidationErrors validationErrors = new ValidationErrors();
                    if (!docNode.isMap()) {
                        throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)docNode, (Object)"A JSON object"));
                    }
                    LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                    for (Map.Entry entry : docNode.toMapOfNodes().entrySet()) {
                        ValidationResult parsedEntry = configType.getParser().parse((DocNode)entry.getValue(), (Parser.Context)ConfigurationRepository.this.parserContext.withExternalResources().withoutLenientValidation());
                        if (parsedEntry.hasErrors()) {
                            validationErrors.add((String)entry.getKey(), parsedEntry.getValidationErrors());
                        } else {
                            result.put((String)entry.getKey(), parsedEntry.peek());
                        }
                        if (!(parsedEntry.peek() instanceof AutoCloseable)) continue;
                        try {
                            ((AutoCloseable)parsedEntry.peek()).close();
                        }
                        catch (Exception e) {
                            LOGGER.warn("Error while closing {}", (Object)parsedEntry, (Object)e);
                        }
                    }
                    validationErrors.throwExceptionForPresentErrors();
                    return result;
                }
            };
            this.update(configType, SgDynamicConfiguration.of(configType, (Map)doc.patch(patch, (Parser.Context)this.parserContext)), matchETag, true);
            return new StandardResponse(200).message(configType.getUiName() + " has been updated");
        }
        catch (DocUpdateException | ConfigUnavailableException e) {
            throw new ConfigUpdateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> StandardResponse applyPatch(CType<T> configType, String id, DocPatch patch, String matchETag, PatchDefaultHandling patchDefaultHandling) throws ConfigUpdateException, ConcurrentConfigUpdateException, NoSuchConfigEntryException, ConfigValidationException {
        try {
            SgDynamicConfiguration<Object> configInstance = this.getConfigurationFromIndex(configType, "Update of entry " + id);
            if (matchETag != null && !configInstance.getETag().equals(matchETag)) {
                throw new ConcurrentConfigUpdateException("Unable to update configuration due to concurrent modification:\nIf-Match: " + matchETag + "; ETag: " + configInstance.getETag());
            }
            T document = configInstance.getCEntry(id);
            if (document == null) {
                if (patchDefaultHandling == PatchDefaultHandling.TREAT_MISSING_DOCUMENT_AS_EMPTY_DOCUMENT) {
                    document = configType.createDefaultInstance(this.parserContext);
                } else {
                    throw new NoSuchConfigEntryException(configType, id);
                }
            }
            if (!(document instanceof PatchableDocument)) {
                throw new ConfigUpdateException("The config type " + configType + " cannot be patched");
            }
            PatchableDocument entry = (PatchableDocument)document;
            Object newEntry = entry.patch(patch, (Parser.Context)this.parserContext.withExternalResources().withoutLenientValidation());
            try {
                ValidationErrors validationErrors = new ValidationErrors();
                validationErrors.add(this.configModificationValidators.validateConfigEntry(newEntry));
                validationErrors.throwExceptionForPresentErrors();
                this.update(configType, configInstance.with(id, newEntry), matchETag, false);
            }
            finally {
                if (newEntry instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)newEntry).close();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error while closing {}", newEntry, (Object)e);
                    }
                }
            }
            String message = configType.getArity() == CType.Arity.SINGLE ? configType.getUiName() + " has been updated" : configType.getUiName() + " " + id + " has been updated";
            return new StandardResponse(200).message(message);
        }
        catch (DocUpdateException | ConfigUnavailableException e) {
            throw new ConfigUpdateException(e);
        }
    }

    public <T> StandardResponse delete(CType<T> configType, String id) throws ConfigUpdateException, ConcurrentConfigUpdateException, NoSuchConfigEntryException {
        try {
            SgDynamicConfiguration<T> configInstance = this.getConfigurationFromIndex(configType, "Deletion of entry " + id);
            if (!configInstance.exists(id)) {
                throw new NoSuchConfigEntryException(configType, id);
            }
            this.update(configType, configInstance.without(id), null, false);
            return new StandardResponse(200).message(configType.getUiName() + " " + id + " has been deleted");
        }
        catch (ConfigValidationException | ConfigUnavailableException e) {
            throw new ConfigUpdateException(e);
        }
    }

    public <T> StandardResponse delete(CType<T> configType) throws ConfigUpdateException, ConcurrentConfigUpdateException {
        try {
            DeleteRequest request = new DeleteRequest(this.getEffectiveSearchGuardIndexAndCreateIfNecessary(), configType.toLCString());
            DeleteResponse response = (DeleteResponse)this.privilegedConfigClient.delete(request).actionGet();
            if (response.status() == RestStatus.NOT_FOUND) {
                return new StandardResponse(404).message(configType.toLCString() + " does not exist");
            }
            this.reloadConfiguration(Collections.singleton(configType), "Config deletion");
            return new StandardResponse(200).message(configType.toLCString() + " has been deleted");
        }
        catch (ConfigUnavailableException | ConfigUpdateException e) {
            return new StandardResponse(e);
        }
    }

    public <T> void update(CType<T> ctype, SgDynamicConfiguration<T> configInstance, String matchETag) throws ConfigUpdateException, ConcurrentConfigUpdateException, ConfigValidationException {
        this.update(ctype, configInstance, matchETag, true);
    }

    public <T> void update(CType<T> ctype, SgDynamicConfiguration<T> configInstance, String matchETag, boolean runValidations) throws ConfigUpdateException, ConcurrentConfigUpdateException, ConfigValidationException {
        if (runValidations) {
            ValidationErrors validationErrors = new ValidationErrors();
            validationErrors.add(this.configModificationValidators.validateConfig(configInstance));
            validationErrors.throwExceptionForPresentErrors();
        }
        IndexRequest indexRequest = new IndexRequest(this.getEffectiveSearchGuardIndexAndCreateIfNecessary());
        try {
            String id = ctype.toLCString();
            indexRequest = (IndexRequest)indexRequest.id(id).source(new Object[]{id, XContentHelper.toXContent(configInstance.withoutStatic(), (XContentType)XContentType.JSON, (boolean)false)}).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (matchETag != null) {
            try {
                int dot = matchETag.indexOf(46);
                if (dot == -1) {
                    throw new ConcurrentConfigUpdateException("Invalid E-Tag " + matchETag);
                }
                indexRequest.setIfPrimaryTerm(Long.parseLong(matchETag.substring(0, dot)));
                indexRequest.setIfSeqNo(Long.parseLong(matchETag.substring(dot + 1)));
            }
            catch (NumberFormatException e) {
                throw new ConcurrentConfigUpdateException("Invalid E-Tag " + matchETag);
            }
        } else if (configInstance.getPrimaryTerm() != -1L && configInstance.getSeqNo() != -1L) {
            indexRequest.setIfPrimaryTerm(configInstance.getPrimaryTerm());
            indexRequest.setIfSeqNo(configInstance.getSeqNo());
        }
        try {
            this.privilegedConfigClient.index(indexRequest).actionGet();
        }
        catch (VersionConflictEngineException e) {
            throw new ConcurrentConfigUpdateException("Unable to update configuration due to concurrent modification", e);
        }
        catch (Exception e) {
            throw new ConfigUpdateException("Updating the config failed", e);
        }
        try {
            ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0]));
            ConfigUpdateResponse configUpdateResponse = (ConfigUpdateResponse)((Object)this.privilegedConfigClient.execute(ConfigUpdateAction.INSTANCE, (ActionRequest)configUpdateRequest).actionGet());
            if (configUpdateResponse.hasFailures()) {
                throw new ConfigUpdateException("Configuration index was updated; however, some nodes reported failures while refreshing.", (Object)configUpdateResponse);
            }
        }
        catch (Exception e) {
            throw new ConfigUpdateException("Configuration index was updated; however, the refresh failed", e);
        }
    }

    public Map<CType<?>, ConfigUpdateResult> update(Map<CType<?>, ConfigWithMetadata> configTypeToConfigMap) throws ConfigUpdateException, ConfigValidationException, ConcurrentConfigUpdateException {
        LOGGER.info("Updating configuration {}", configTypeToConfigMap.keySet());
        ValidationErrors validationErrors = new ValidationErrors();
        BulkRequest bulkRequest = new BulkRequest();
        ArrayList parsedConfigs = new ArrayList();
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        if (configTypeToConfigMap.isEmpty()) {
            throw new ConfigValidationException(new ValidationError(null, "No configuration given"));
        }
        ArrayList<String> configTypesWithConcurrentModifications = new ArrayList<String>();
        String searchGuardIndex = this.getEffectiveSearchGuardIndexAndCreateIfNecessary();
        for (Map.Entry<CType<?>, ConfigWithMetadata> entry : configTypeToConfigMap.entrySet()) {
            BulkItemResponse[] ctype = entry.getKey();
            if (entry.getValue() == null) {
                validationErrors.add((ValidationError)new InvalidAttributeValue(ctype.toLCString(), null, (Object)"A config JSON document"));
                continue;
            }
            ImmutableMap configMap = entry.getValue().getContent();
            String matchETag = entry.getValue().getEtag();
            if (configMap == null) {
                validationErrors.add((ValidationError)new InvalidAttributeValue(ctype.toLCString(), null, (Object)"A config JSON document"));
                continue;
            }
            if (ctype.getArity() == CType.Arity.SINGLE) {
                configMap = !configMap.isEmpty() ? ImmutableMap.of((Object)"default", (Object)DocNode.wrap((Object)configMap).splitDottedAttributeNamesToTree().toMap()) : ImmutableMap.empty();
            }
            try {
                ValidationResult configInstance = SgDynamicConfiguration.fromMap(configMap, ctype, this.parserContext.withExternalResources().withoutLenientValidation());
                if (configInstance.getValidationErrors() != null && configInstance.getValidationErrors().hasErrors()) {
                    validationErrors.add(ctype.toLCString(), configInstance.getValidationErrors());
                    continue;
                }
                String id = ctype.toLCString();
                IndexRequest indexRequest = new IndexRequest(searchGuardIndex).id(id).source(new Object[]{id, XContentHelper.toXContent(((SgDynamicConfiguration)configInstance.peek()).withoutStatic(), (XContentType)XContentType.JSON, (boolean)false)});
                if (matchETag != null) {
                    try {
                        SgDynamicConfiguration currentConfigInstance;
                        int dot = matchETag.indexOf(46);
                        if (dot == -1) {
                            validationErrors.add(new InvalidAttributeValue(ctype.toLCString(), (Object)matchETag, null).message("Invalid E-Tag"));
                            continue;
                        }
                        long primaryTerm = Long.parseLong(matchETag.substring(0, dot));
                        long seqNo = Long.parseLong(matchETag.substring(dot + 1));
                        if (this.currentConfig != null && (currentConfigInstance = this.currentConfig.get(ctype)) != null && (currentConfigInstance.getPrimaryTerm() != primaryTerm || currentConfigInstance.getSeqNo() != seqNo)) {
                            configTypesWithConcurrentModifications.add(ctype.toLCString());
                        }
                        indexRequest.setIfPrimaryTerm(primaryTerm);
                        indexRequest.setIfSeqNo(seqNo);
                    }
                    catch (NumberFormatException e) {
                        validationErrors.add(new InvalidAttributeValue(ctype.toLCString(), (Object)matchETag, null).message("Invalid E-Tag"));
                        continue;
                    }
                }
                bulkRequest.add(indexRequest);
                if (!configInstance.hasResult()) continue;
                parsedConfigs.add((SgDynamicConfiguration)configInstance.peek());
            }
            catch (ConfigValidationException e) {
                validationErrors.add(ctype.toLCString(), e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        validationErrors.add(this.configModificationValidators.validateConfigs(parsedConfigs));
        parsedConfigs.forEach(SgDynamicConfiguration::close);
        validationErrors.throwExceptionForPresentErrors();
        if (!configTypesWithConcurrentModifications.isEmpty()) {
            if (configTypesWithConcurrentModifications.size() == 1) {
                throw new ConcurrentConfigUpdateException("The configuration " + (String)configTypesWithConcurrentModifications.get(0) + " has been concurrently modified.");
            }
            throw new ConcurrentConfigUpdateException("The configurations " + configTypesWithConcurrentModifications.stream().collect(Collectors.joining(", ")) + " have been concurrently modified.");
        }
        try {
            BulkResponse bulkResponse = (BulkResponse)this.privilegedConfigClient.bulk(bulkRequest).actionGet();
            LinkedHashMap result = new LinkedHashMap(configTypeToConfigMap.size());
            for (BulkItemResponse item : bulkResponse.getItems()) {
                CType<?> ctype = CType.fromString(item.getId());
                if (ctype == null) {
                    LOGGER.error("Could not find CType for " + item.getId());
                    continue;
                }
                if (item.isFailed()) {
                    result.put(ctype, new ConfigUpdateResult("Update failed", new StandardResponse.Error(item.getFailureMessage())));
                    continue;
                }
                result.put(ctype, new ConfigUpdateResult("Update successful", item.getResponse().getPrimaryTerm() + "." + item.getResponse().getSeqNo()));
            }
            if (bulkResponse.hasFailures()) {
                LOGGER.error("Index update finished with errors:\n" + Strings.toString((ChunkedToXContent)bulkResponse));
                List<String> documentIdsWithVersionConflictEngineException = this.getDocumentIdsWithVersionConflictEngineException(bulkResponse);
                if (!documentIdsWithVersionConflictEngineException.isEmpty()) {
                    if (documentIdsWithVersionConflictEngineException.size() == 1) {
                        throw new ConcurrentConfigUpdateException("The configuration " + documentIdsWithVersionConflictEngineException.get(0) + " has been concurrently modified.").updateResult(result);
                    }
                    throw new ConcurrentConfigUpdateException("The configurations " + documentIdsWithVersionConflictEngineException.stream().collect(Collectors.joining(", ")) + " have been concurrently modified.").updateResult(result);
                }
                throw new ConfigUpdateException("Updating the configuration failed", bulkResponse).updateResult(result);
            }
            LOGGER.info("Index update done:\n{}", (Object)Strings.toString((ChunkedToXContent)bulkResponse));
            LOGGER.info("Sending config update request");
            try {
                ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0]));
                ConfigUpdateResponse configUpdateResponse = (ConfigUpdateResponse)((Object)this.privilegedConfigClient.execute(ConfigUpdateAction.INSTANCE, (ActionRequest)configUpdateRequest).actionGet());
                if (configUpdateResponse.hasFailures()) {
                    throw new ConfigUpdateException("Configuration index was updated; however, some nodes reported failures while refreshing.", (Object)configUpdateResponse).updateResult(result);
                }
            }
            catch (Exception e) {
                throw new ConfigUpdateException("Configuration index was updated; however, the refresh failed", e).updateResult(result);
            }
            return result;
        }
        catch (ConcurrentConfigUpdateException | ConfigUpdateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigUpdateException("Updating the configuration failed", e);
        }
    }

    public ComponentState getComponentState() {
        this.componentState.updateStateFromParts();
        return this.componentState;
    }

    public Context getParserContext() {
        return this.parserContext;
    }

    private List<String> getDocumentIdsWithVersionConflictEngineException(BulkResponse bulkResponse) {
        ArrayList<String> result = new ArrayList<String>();
        for (BulkItemResponse item : bulkResponse.getItems()) {
            if (item.getFailure() == null || !(item.getFailure().getCause() instanceof VersionConflictEngineException)) continue;
            result.add(item.getId());
        }
        return result;
    }

    private static <T> void uploadFile(Client tc, File configDirectory, String fileName, String index, CType<T> cType, Context parserContext) throws ConfigUpdateException {
        File filepath = new File(configDirectory, fileName);
        LOGGER.info("Will update '" + cType + "' with " + filepath);
        try (FileReader reader = new FileReader(filepath);){
            DocNode docNode = DocNode.parse((Format)Format.YAML).from((Reader)reader);
            if (docNode.isNull()) {
                docNode = DocNode.EMPTY;
            }
            if (cType.getArity() == CType.Arity.SINGLE) {
                docNode = DocNode.of((String)"default", (Object)docNode.toMap());
            }
            String res = ((DocWriteResponse)tc.index(((IndexRequest)new IndexRequest(index).id(cType.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{cType.toLCString(), new BytesArray(docNode.toJsonString())})).actionGet()).getId();
            if (!cType.toLCString().equals(res)) {
                throw new ConfigUpdateException("   FAIL: Configuration for '" + cType.toLCString() + "' failed for unknown reasons. Pls. consult logfile of elasticsearch");
            }
        }
        catch (Exception e) {
            throw new ConfigUpdateException("Error while initializing configuration " + cType + " with defaults from " + filepath + ": " + e.getMessage(), e);
        }
    }

    public Pattern getConfiguredSearchguardIndices() {
        return this.configuredSearchguardIndices;
    }

    public static ImmutableSet<String> getConfiguredSearchguardIndices(Settings settings) {
        StaticSettings staticSettings = new StaticSettings(settings, null);
        String configuredSearchguardIndexOld = (String)staticSettings.get(NEW_INDEX_NAME);
        String configuredSearchguardIndexNew = (String)staticSettings.get(OLD_INDEX_NAME);
        return ImmutableSet.of((Object)configuredSearchguardIndexOld, (Object)configuredSearchguardIndexNew);
    }

    public static class Context
    implements Parser.Context,
    XContentParserContext {
        private final VariableResolvers variableResolvers;
        private final SearchGuardModulesRegistry searchGuardModulesRegistry;
        private final StaticSettings staticSettings;
        private final NamedXContentRegistry xContentRegistry;
        private final boolean externalResourceCreationEnabled;
        private final boolean lenientValidationEnabled;
        private final ImmutableMap<String, PipeExpression.PipeFunction> pipeFunctionsMap;

        public Context(VariableResolvers variableResolvers, SearchGuardModulesRegistry searchGuardModulesRegistry, StaticSettings staticSettings, NamedXContentRegistry xContentRegistry, ImmutableMap<String, PipeExpression.PipeFunction> pipeFunctionsMap) {
            this.variableResolvers = variableResolvers;
            this.searchGuardModulesRegistry = searchGuardModulesRegistry;
            this.staticSettings = staticSettings;
            this.xContentRegistry = xContentRegistry;
            this.externalResourceCreationEnabled = false;
            this.lenientValidationEnabled = true;
            this.pipeFunctionsMap = pipeFunctionsMap == null ? ImmutableMap.empty() : pipeFunctionsMap;
        }

        private Context(VariableResolvers variableResolvers, SearchGuardModulesRegistry searchGuardModulesRegistry, StaticSettings staticSettings, NamedXContentRegistry xContentRegistry, boolean externalResourceCreationEnabled, boolean lenientValidationEnabled, ImmutableMap<String, PipeExpression.PipeFunction> pipeFunctionsMap) {
            this.variableResolvers = variableResolvers;
            this.searchGuardModulesRegistry = searchGuardModulesRegistry;
            this.staticSettings = staticSettings;
            this.xContentRegistry = xContentRegistry;
            this.externalResourceCreationEnabled = externalResourceCreationEnabled;
            this.lenientValidationEnabled = lenientValidationEnabled;
            this.pipeFunctionsMap = pipeFunctionsMap == null ? ImmutableMap.empty() : pipeFunctionsMap;
        }

        public VariableResolvers variableResolvers() {
            return this.variableResolvers;
        }

        public SearchGuardModulesRegistry modulesRegistry() {
            return this.searchGuardModulesRegistry;
        }

        public StaticSettings getStaticSettings() {
            return this.staticSettings;
        }

        public NamedXContentRegistry xContentRegistry() {
            return this.xContentRegistry;
        }

        public boolean isExternalResourceCreationEnabled() {
            return this.externalResourceCreationEnabled;
        }

        public boolean isLenientValidationRequested() {
            return this.lenientValidationEnabled;
        }

        public Context withExternalResources() {
            return new Context(this.variableResolvers, this.searchGuardModulesRegistry, this.staticSettings, this.xContentRegistry, true, this.lenientValidationEnabled, this.pipeFunctionsMap);
        }

        public Context withoutLenientValidation() {
            return new Context(this.variableResolvers, this.searchGuardModulesRegistry, this.staticSettings, this.xContentRegistry, this.externalResourceCreationEnabled, false, this.pipeFunctionsMap);
        }

        public ImmutableMap<String, PipeExpression.PipeFunction> pipeFunctions() {
            return this.pipeFunctionsMap;
        }
    }

    public static enum PatchDefaultHandling {
        FAIL_ON_MISSING_DOCUMENT,
        TREAT_MISSING_DOCUMENT_AS_EMPTY_DOCUMENT;

    }

    public static class ConfigWithMetadata {
        private final Map<String, ?> content;
        private final String etag;

        public ConfigWithMetadata(Map<String, ?> content, String etag) {
            this.content = content;
            this.etag = etag;
        }

        public Map<String, ?> getContent() {
            return this.content;
        }

        public String getEtag() {
            return this.etag;
        }
    }

    public static class ConfigUpdateResult
    implements Document<ConfigUpdateResult> {
        private final String message;
        private final String etag;
        private final StandardResponse.Error error;

        public ConfigUpdateResult(String message, String etag) {
            this.message = message;
            this.etag = etag;
            this.error = null;
        }

        public ConfigUpdateResult(String message, StandardResponse.Error error) {
            this.message = message;
            this.etag = null;
            this.error = error;
        }

        public Object toBasicObject() {
            return OrderedImmutableMap.ofNonNull((Object)"message", (Object)this.message, (Object)"etag", (Object)this.etag, (Object)"error", (Object)this.error);
        }
    }
}

