/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.authz.config.Tenant;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

public class StaticSgConfig {
    private static final Logger log = LogManager.getLogger(StaticSgConfig.class);
    private final SgDynamicConfiguration<Role> staticRoles;
    private final SgDynamicConfiguration<ActionGroup> staticActionGroups;
    private final SgDynamicConfiguration<Tenant> staticTenants;

    public StaticSgConfig(Settings settings) {
        if (settings.getAsBoolean("searchguard.unsupported.load_static_resources", Boolean.valueOf(true)).booleanValue()) {
            this.staticRoles = this.readConfig("/static_config/static_roles.yml", CType.ROLES);
            this.staticActionGroups = this.readConfig("/static_config/static_action_groups.yml", CType.ACTIONGROUPS);
            this.staticTenants = this.readConfig("/static_config/static_tenants.yml", CType.TENANTS);
        } else {
            log.info("searchguard.unsupported.load_static_resources is set to false. Static resources will not be loaded.");
            this.staticRoles = SgDynamicConfiguration.empty(CType.ROLES);
            this.staticActionGroups = SgDynamicConfiguration.empty(CType.ACTIONGROUPS);
            this.staticTenants = SgDynamicConfiguration.empty(CType.TENANTS);
        }
    }

    public <T> SgDynamicConfiguration<T> addTo(SgDynamicConfiguration<T> original) {
        SgDynamicConfiguration<T> staticConfig = this.get(original);
        if (staticConfig.getCEntries().isEmpty()) {
            return original;
        }
        this.checkForOverriddenEntries(original, staticConfig);
        SgDynamicConfiguration<T> result = original.with((Map<String, T>)staticConfig.getCEntries());
        if (log.isDebugEnabled()) {
            log.debug(staticConfig.getCEntries().size() + " static " + original.getCType().toLCString() + " loaded");
        }
        return result;
    }

    public <ConfigType> SgDynamicConfiguration<ConfigType> get(SgDynamicConfiguration<ConfigType> original) {
        if (original.getCType().equals(CType.ACTIONGROUPS)) {
            return this.staticActionGroups;
        }
        if (original.getCType().equals(CType.ROLES)) {
            return this.staticRoles;
        }
        if (original.getCType().equals(CType.TENANTS)) {
            return this.staticTenants;
        }
        return SgDynamicConfiguration.empty(original.getCType());
    }

    private void checkForOverriddenEntries(SgDynamicConfiguration<?> original, SgDynamicConfiguration<?> staticConfig) {
        HashSet overridenKeys = new HashSet(staticConfig.getCEntries().keySet());
        overridenKeys.retainAll((Collection<?>)original.getCEntries().keySet());
        if (!overridenKeys.isEmpty()) {
            log.warn("The " + original.getCType().toLCString() + " config tries to override static configuration. This is not possible. Affected config keys: " + overridenKeys + "; type: " + original.getCType() + "; v: " + original.getDocVersion(), (Throwable)new Exception());
        }
    }

    private <ConfigType> SgDynamicConfiguration<ConfigType> readConfig(String resourcePath, CType<ConfigType> configType) {
        try {
            DocNode docNode = DocNode.parse((Format)Format.YAML).from(StaticSgConfig.class.getResourceAsStream(resourcePath));
            return (SgDynamicConfiguration)SgDynamicConfiguration.fromDocNode(docNode, docNode.toJsonString(), configType, 0L, 0L, 0L, null).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading static configuration from " + resourcePath, e);
        }
    }
}

