/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail;

import com.sanctionco.jmail.Email;
import com.sanctionco.jmail.InvalidEmailException;
import com.sanctionco.jmail.JMail;
import com.sanctionco.jmail.TopLevelDomain;
import com.sanctionco.jmail.ValidationRules;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class EmailValidator {
    private static final Predicate<Email> DISALLOW_IP_DOMAIN_PREDICATE = ValidationRules::disallowIpDomain;
    private static final Predicate<Email> REQUIRE_TOP_LEVEL_DOMAIN_PREDICATE = ValidationRules::requireTopLevelDomain;
    private static final Predicate<Email> DISALLOW_EXPLICIT_SOURCE_ROUTING = ValidationRules::disallowExplicitSourceRouting;
    private static final Predicate<Email> DISALLOW_QUOTED_IDENTIFIERS = ValidationRules::disallowQuotedIdentifiers;
    private static final Predicate<Email> DISALLOW_RESERVED_DOMAINS_PREDICATE = ValidationRules::disallowReservedDomains;
    private final Set<Predicate<Email>> validationPredicates;

    EmailValidator(Set<Predicate<Email>> validationPredicates) {
        this.validationPredicates = Collections.unmodifiableSet(validationPredicates);
    }

    EmailValidator() {
        this(new HashSet<Predicate<Email>>());
    }

    public EmailValidator withRule(Predicate<Email> rule) {
        HashSet<Predicate<Email>> rules = new HashSet<Predicate<Email>>(this.validationPredicates);
        rules.add(rule);
        return new EmailValidator(rules);
    }

    public EmailValidator disallowIpDomain() {
        return this.withRule(DISALLOW_IP_DOMAIN_PREDICATE);
    }

    public EmailValidator requireTopLevelDomain() {
        return this.withRule(REQUIRE_TOP_LEVEL_DOMAIN_PREDICATE);
    }

    public EmailValidator disallowExplicitSourceRouting() {
        return this.withRule(DISALLOW_EXPLICIT_SOURCE_ROUTING);
    }

    public EmailValidator disallowQuotedIdentifiers() {
        return this.withRule(DISALLOW_QUOTED_IDENTIFIERS);
    }

    public EmailValidator disallowReservedDomains() {
        return this.withRule(DISALLOW_RESERVED_DOMAINS_PREDICATE);
    }

    public EmailValidator requireOnlyTopLevelDomains(TopLevelDomain ... allowed) {
        return this.withRule(email -> ValidationRules.requireOnlyTopLevelDomains(email, Arrays.stream(allowed).collect(Collectors.toSet())));
    }

    public boolean isValid(String email) {
        return JMail.tryParse(email).filter(this::passesPredicates).isPresent();
    }

    public void enforceValid(String email) throws InvalidEmailException {
        if (!JMail.tryParse(email).filter(this::passesPredicates).isPresent()) {
            throw new InvalidEmailException();
        }
    }

    public Optional<Email> tryParse(String email) {
        Optional<Email> result = JMail.tryParse(email);
        if (result.isPresent() && this.passesPredicates(result.get())) {
            return result;
        }
        return Optional.empty();
    }

    private boolean passesPredicates(Email email) {
        return this.validationPredicates.stream().allMatch(rule -> rule.test(email));
    }
}

