/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.accounts;

import com.floragunn.searchguard.user.User;
import com.floragunn.signals.SignalsInitializationException;
import com.floragunn.signals.accounts.Account;
import com.floragunn.signals.accounts.NoSuchAccountException;
import com.floragunn.signals.settings.SignalsSettings;
import com.floragunn.signals.support.LuckySisyphos;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class AccountRegistry {
    private static final Logger log = LogManager.getLogger(AccountRegistry.class);
    private volatile Map<String, Account> accounts = null;
    private final SignalsSettings settings;

    public AccountRegistry(SignalsSettings settings) {
        this.settings = settings;
    }

    public void init(Client client) throws SignalsInitializationException {
        try {
            if (this.accounts == null) {
                this.updateAtomic(client);
            }
        }
        catch (Exception e) {
            log.error("Error while initializing AccountRegistry", (Throwable)e);
            throw new SignalsInitializationException("Error while initializing AccountRegistry", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAtomic(Client client) throws IOException {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        User user = (User)threadContext.getTransient("_sg_user");
        Object remoteAddress = threadContext.getTransient("_sg_remote_address");
        Object origin = threadContext.getTransient("_sg_origin");
        Map originalResponseHeaders = threadContext.getResponseHeaders();
        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
            threadContext.putHeader("_sg_conf_request", "true");
            threadContext.putTransient("_sg_user", (Object)user);
            threadContext.putTransient("_sg_remote_address", remoteAddress);
            threadContext.putTransient("_sg_origin", origin);
            originalResponseHeaders.entrySet().forEach(h -> ((List)h.getValue()).forEach(v -> threadContext.addResponseHeader((String)h.getKey(), v)));
            HashMap<String, Account> tmp = new HashMap<String, Account>();
            SearchResponse searchResponse = LuckySisyphos.tryHard(() -> (SearchResponse)client.prepareSearch(new String[]{this.settings.getStaticSettings().getIndexNames().getAccounts()}).setSource(new SearchSourceBuilder()).setSize(10000).get());
            try {
                for (SearchHit hit : searchResponse.getHits()) {
                    try {
                        String id = AccountRegistry.unscopeId(hit.getId());
                        String accountType = AccountRegistry.getAccountType(hit.getId());
                        tmp.put(hit.getId(), Account.parse(accountType, id, hit.getSourceAsString()));
                    }
                    catch (Exception e) {
                        log.error("Error while parsing " + hit, (Throwable)e);
                    }
                }
                this.accounts = Collections.unmodifiableMap(tmp);
                log.debug("Loaded {} accounts", (Object)this.accounts.size());
            }
            finally {
                searchResponse.decRef();
            }
        }
    }

    public <T extends Account> T lookupAccount(String id, Class<T> accountClass) throws NoSuchAccountException {
        Account.Factory<T> accountFactory;
        if (this.accounts == null) {
            throw new IllegalStateException("AccountRegistry is not intialized yet");
        }
        if (id == null) {
            id = "default";
        }
        if ((accountFactory = Account.factoryRegistry.get(accountClass)) == null) {
            throw new NoSuchAccountException("Illegal account class: " + accountClass);
        }
        String scopedId = accountFactory.getType() + "/" + id;
        Account result = this.accounts.get(scopedId);
        if (result == null) {
            throw new NoSuchAccountException("Account does not exist: " + scopedId, null);
        }
        if (!accountClass.isAssignableFrom(result.getClass())) {
            throw new NoSuchAccountException("Account " + id + " is not of type " + accountClass.getSimpleName() + ". Found: " + result.getClass().getSimpleName(), null);
        }
        return (T)((Account)accountClass.cast(result));
    }

    public Account lookupAccount(String id, String accountType) throws NoSuchAccountException {
        String scopedId;
        Account result;
        if (this.accounts == null) {
            throw new IllegalStateException("AccountRegistry is not intialized yet");
        }
        if (id == null) {
            id = "default";
        }
        if ((result = this.accounts.get(scopedId = accountType + "/" + id)) == null) {
            throw new NoSuchAccountException("Account does not exist: " + scopedId, null);
        }
        return result;
    }

    private static String unscopeId(String scopedId) {
        int slash = scopedId.indexOf(47);
        if (slash != -1) {
            return scopedId.substring(slash + 1);
        }
        return scopedId;
    }

    private static String getAccountType(String scopedId) {
        int slash = scopedId.indexOf(47);
        if (slash != -1) {
            return scopedId.substring(0, slash);
        }
        throw new IllegalArgumentException("Illegal scopedId: " + scopedId);
    }
}

