/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.ackandget;

import com.floragunn.signals.actions.watch.ackandget.Acknowledgement;
import com.floragunn.signals.actions.watch.ackandget.TransportAckAndGetWatchAction;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class AckAndGetWatchResponse
extends BaseNodesResponse<TransportAckAndGetWatchAction.NodeResponse> {
    private static final Logger log = LogManager.getLogger(AckAndGetWatchResponse.class);
    private Status status;
    private String statusMessage;
    private Acknowledgement[] acknowledgements;
    private String[] unackedActionIds;

    public AckAndGetWatchResponse(ClusterName clusterName, List<TransportAckAndGetWatchAction.NodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
        this.acknowledgements = (Acknowledgement[])nodes.stream().filter(response -> Objects.nonNull(response.getAcknowledgements())).flatMap(response -> Arrays.stream(response.getAcknowledgements())).toArray(Acknowledgement[]::new);
        this.unackedActionIds = (String[])nodes.stream().filter(response -> Objects.nonNull(response.getUnackedActionIds())).flatMap(ids -> Arrays.stream(ids.getUnackedActionIds())).toArray(String[]::new);
    }

    public AckAndGetWatchResponse(StreamInput in) throws IOException {
        super(in);
        this.initStatus();
    }

    public Acknowledgement[] getAcknowledgements() {
        return this.acknowledgements;
    }

    public Acknowledgement[] getSortedAcknowledgements(Comparator<? super Acknowledgement> comparator) {
        return (Acknowledgement[])Arrays.stream(this.acknowledgements).sorted(comparator).toArray(Acknowledgement[]::new);
    }

    public String[] getUnackedActionIds() {
        return this.unackedActionIds;
    }

    public List<TransportAckAndGetWatchAction.NodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readCollectionAsList(TransportAckAndGetWatchAction.NodeResponse::readNodeResponse);
    }

    public void writeNodesTo(StreamOutput out, List<TransportAckAndGetWatchAction.NodeResponse> nodes) throws IOException {
        out.writeCollection(nodes);
    }

    public String toString() {
        return "AckWatchResponse [failures=" + this.failures() + ", nodes=" + this.getNodesMap() + "]";
    }

    private void initStatus() {
        TransportAckAndGetWatchAction.NodeResponse nodeResponse;
        if (log.isDebugEnabled()) {
            log.debug("AckWatch node responses: " + this.getNodes());
        }
        if ((nodeResponse = this.getResponsibleNodeResponse()) == null) {
            this.status = Status.NO_SUCH_WATCH;
            this.statusMessage = "Could not find watch";
            return;
        }
        this.status = nodeResponse.getStatus();
        this.statusMessage = nodeResponse.getMessage();
        this.acknowledgements = nodeResponse.getAcknowledgements();
        this.unackedActionIds = nodeResponse.getUnackedActionIds();
    }

    private TransportAckAndGetWatchAction.NodeResponse getResponsibleNodeResponse() {
        for (TransportAckAndGetWatchAction.NodeResponse nodeResponse : this.getNodes()) {
            if (nodeResponse.getStatus() != Status.SUCCESS) continue;
            return nodeResponse;
        }
        for (TransportAckAndGetWatchAction.NodeResponse nodeResponse : this.getNodes()) {
            if (nodeResponse.getStatus() != Status.ILLEGAL_STATE && nodeResponse.getStatus() != Status.NO_SUCH_ACTION && nodeResponse.getStatus() != Status.NOT_ACKNOWLEDGEABLE && nodeResponse.getStatus() != Status.NO_SUCH_TENANT) continue;
            return nodeResponse;
        }
        for (TransportAckAndGetWatchAction.NodeResponse nodeResponse : this.getNodes()) {
            if (nodeResponse.getStatus() != Status.EXCEPTION && nodeResponse.getStatus() != Status.UNAUTHORIZED) continue;
            return nodeResponse;
        }
        return null;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.initStatus();
        }
        return this.status;
    }

    public String getStatusMessage() {
        if (this.status == null) {
            this.initStatus();
        }
        return this.statusMessage;
    }

    public static enum Status {
        SUCCESS,
        NO_SUCH_WATCH,
        EXCEPTION,
        ILLEGAL_STATE,
        NO_SUCH_TENANT,
        UNAUTHORIZED,
        NO_SUCH_ACTION,
        NOT_ACKNOWLEDGEABLE;

    }
}

