/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.rest;

import com.floragunn.searchguard.SearchGuardVersion;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.signals.Signals;
import com.floragunn.signals.truststore.service.TruststoreCrudService;
import com.floragunn.signals.truststore.service.persistence.TruststoreRepository;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.injection.guice.Inject;

public class FindAllTruststoresAction
extends Action<StandardRequests.EmptyRequest, StandardResponse> {
    private static final Logger log = LogManager.getLogger(FindAllTruststoresAction.class);
    public static final String NAME = "cluster:admin:searchguard:signals:truststores/findall";
    public static final FindAllTruststoresAction INSTANCE = new FindAllTruststoresAction();
    public static final RestApi REST_API = new RestApi().responseHeaders((Map)SearchGuardVersion.header()).handlesGet("/_signals/truststores").with((Action)INSTANCE).name("GET /_signals/truststores");

    private FindAllTruststoresAction() {
        super(NAME, StandardRequests.EmptyRequest::new, StandardResponse::new);
    }

    public static class FindAllTruststoresHandler
    extends Action.Handler<StandardRequests.EmptyRequest, StandardResponse> {
        private final TruststoreCrudService truststoreCrudService;

        @Inject
        public FindAllTruststoresHandler(Action.HandlerDependencies handlerDependencies, NodeClient client, Signals signals) {
            super((Action)INSTANCE, handlerDependencies);
            PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
            TruststoreRepository truststoreRepository = new TruststoreRepository(signals.getSignalsSettings(), privilegedConfigClient);
            this.truststoreCrudService = new TruststoreCrudService(truststoreRepository);
        }

        protected CompletableFuture<StandardResponse> doExecute(StandardRequests.EmptyRequest request) {
            return this.supplyAsync(() -> {
                try {
                    return this.truststoreCrudService.findAll();
                }
                catch (Exception e) {
                    log.warn("Cannot load trust store data", (Throwable)e);
                    return new StandardResponse(500).error("Cannot load trust store data. " + e.getMessage());
                }
            });
        }
    }
}

