/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.checks;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.watch.checks.AbstractSearchInput;
import com.floragunn.signals.watch.checks.Check;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class SearchInput
extends AbstractSearchInput {
    private final String body;
    private SearchType searchType = SearchType.DEFAULT;

    public SearchInput(String name, String target, String index, String body) {
        this(name, target, Collections.singletonList(index), body);
    }

    public SearchInput(String name, String target, List<String> indices, String body) {
        this(name, target, indices, body, null, null);
    }

    public SearchInput(String name, String target, List<String> indices, String body, SearchType searchType, IndicesOptions indicesOptions) {
        super(name, target, indices);
        this.body = body;
        this.searchType = searchType;
        this.indicesOptions = indicesOptions;
    }

    @Override
    protected Script createTemplateScript() {
        return new Script(ScriptType.INLINE, "mustache", this.body, Collections.emptyMap());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", "search");
        builder.field("name", this.name);
        builder.field("target", this.target);
        if (this.timeout != null) {
            builder.field("timeout", this.timeout.getStringRep());
        }
        if (this.searchType != null) {
            builder.field("search_type", this.searchType.name().toLowerCase());
        }
        builder.startObject("request");
        builder.field("indices", (Collection)this.indices);
        builder.field("body");
        builder.rawValue((InputStream)new ByteArrayInputStream(this.body.getBytes("utf-8")), XContentType.JSON);
        builder.endObject();
        if (this.indicesOptions != null) {
            builder.field("indices_options", (ToXContent)this.indicesOptions);
        }
        builder.endObject();
        return builder;
    }

    static Check create(WatchInitializationService watchInitService, DocNode jsonObject) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonObject, validationErrors);
        vJsonNode.used(new String[]{"type", "request"});
        String name = null;
        String target = null;
        name = vJsonNode.get("name").asString();
        target = vJsonNode.get("target").asString();
        ImmutableList indices = vJsonNode.get("request.indices").asListOfStrings();
        DocNode body = jsonObject.getAsNode("request").getAsNode("body");
        if (body == null || body.isNull()) {
            validationErrors.add((ValidationError)new MissingAttribute("request.body", (Object)jsonObject));
        }
        TimeValue timeout = (TimeValue)vJsonNode.get("timeout").byString(v -> TimeValue.parseTimeValue((String)v, (String)"timeout"));
        SearchType searchType = (SearchType)vJsonNode.get("search_type").asEnum(SearchType.class);
        IndicesOptions indicesOptions = null;
        if (vJsonNode.hasNonNull("indices_options")) {
            try {
                indicesOptions = SearchInput.parseIndicesOptions(jsonObject.getAsNode("indices_options"));
            }
            catch (ConfigValidationException e) {
                validationErrors.add("indices_options", e);
            }
        }
        vJsonNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        SearchInput result = new SearchInput(name, target, (List<String>)indices, body.toJsonString());
        result.timeout = timeout;
        result.searchType = searchType;
        result.indicesOptions = indicesOptions;
        result.compileScripts(watchInitService);
        return result;
    }

    static void addIndexMappingProperties(NestedValueMap mapping) {
        mapping.put(new NestedValueMap.Path("request", "type"), (Object)"object");
        mapping.put(new NestedValueMap.Path("request", "dynamic"), (Object)true);
        mapping.put(new NestedValueMap.Path("request", "properties", "body", "type"), (Object)"object");
        mapping.put(new NestedValueMap.Path("request", "properties", "body", "dynamic"), (Object)true);
        mapping.put(new NestedValueMap.Path("request", "properties", "body", "enabled"), (Object)false);
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public void setSearchType(SearchType searchType) {
        this.searchType = searchType;
    }

    public String getBody() {
        return this.body;
    }
}

