/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.signals.execution.WatchExecutionContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xcontent.ToXContentObject;

public abstract class WatchElement
implements ToXContentObject {
    public Iterable<? extends WatchElement> getChildren() {
        return Collections.emptyList();
    }

    public <T> T getChildByNameAndType(Class<T> type, String name) {
        if (name == null) {
            return null;
        }
        for (WatchElement watchElement : this.getChildren()) {
            if (watchElement == null || !type.isAssignableFrom(watchElement.getClass()) || !name.equals(watchElement.getName())) continue;
            return type.cast(watchElement);
        }
        return null;
    }

    public String getName() {
        return null;
    }

    protected String render(WatchExecutionContext ctx, TemplateScript.Factory script) {
        if (script != null) {
            return script.newInstance(ctx.getTemplateScriptParamsAsMap()).execute();
        }
        return null;
    }

    protected List<String> render(WatchExecutionContext ctx, List<TemplateScript.Factory> list) {
        if (list == null || list.size() == 0) {
            return Collections.emptyList();
        }
        return list.stream().map(script -> this.render(ctx, (TemplateScript.Factory)script)).collect(Collectors.toList());
    }
}

