/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.network.ThreadWatchdog;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.http.netty4.Netty4ChunkedHttpContinuation;
import org.elasticsearch.http.netty4.Netty4ChunkedHttpResponse;
import org.elasticsearch.http.netty4.Netty4FullHttpResponse;
import org.elasticsearch.http.netty4.Netty4HttpChannel;
import org.elasticsearch.http.netty4.Netty4HttpRequest;
import org.elasticsearch.http.netty4.Netty4HttpRequestBodyStream;
import org.elasticsearch.http.netty4.Netty4HttpResponse;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.transport.netty4.Netty4Utils;
import org.elasticsearch.transport.netty4.NettyAllocator;

public class Netty4HttpPipeliningHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LogManager.getLogger(Netty4HttpPipeliningHandler.class);
    private final int maxEventsHeld;
    private final ThreadWatchdog.ActivityTracker activityTracker;
    private final PriorityQueue<Tuple<? extends Netty4HttpResponse, ChannelPromise>> outboundHoldingQueue;
    @Nullable
    private ChunkedWrite currentChunkedWrite;
    @Nullable
    private Netty4HttpRequestBodyStream currentRequestStream;
    private int readSequence;
    private int writeSequence;
    private final Queue<WriteOperation> queuedWrites = new ArrayDeque<WriteOperation>();
    private final Netty4HttpServerTransport serverTransport;
    private static final String DO_NOT_SPLIT = "es.unsafe.do_not_split_http_responses";
    private static final boolean DO_NOT_SPLIT_HTTP_RESPONSES = Booleans.parseBoolean((String)System.getProperty("es.unsafe.do_not_split_http_responses"), (boolean)false);
    private static final int SPLIT_THRESHOLD = (int)((double)NettyAllocator.suggestedMaxAllocationSize() * 0.99);

    public Netty4HttpPipeliningHandler(int maxEventsHeld, Netty4HttpServerTransport serverTransport, ThreadWatchdog.ActivityTracker activityTracker) {
        this.maxEventsHeld = maxEventsHeld;
        this.activityTracker = activityTracker;
        this.outboundHoldingQueue = new PriorityQueue<Tuple>(1, Comparator.comparingInt(t -> ((Netty4HttpResponse)t.v1()).getSequence()));
        this.serverTransport = serverTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.activityTracker.startActivity();
        try {
            if (msg instanceof HttpRequest) {
                Netty4HttpRequest netty4HttpRequest;
                HttpRequest request = (HttpRequest)msg;
                if (request.decoderResult().isFailure()) {
                    Exception nonError;
                    Throwable cause = request.decoderResult().cause();
                    if (cause instanceof Error) {
                        ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                        nonError = new Exception(cause);
                    } else {
                        nonError = (Exception)cause;
                    }
                    netty4HttpRequest = new Netty4HttpRequest(this.readSequence++, (FullHttpRequest)request, nonError);
                } else {
                    assert (this.currentRequestStream == null) : "current stream must be null for new request";
                    if (request instanceof FullHttpRequest) {
                        FullHttpRequest fullHttpRequest = (FullHttpRequest)request;
                        netty4HttpRequest = new Netty4HttpRequest(this.readSequence++, fullHttpRequest);
                        this.currentRequestStream = null;
                    } else {
                        Netty4HttpRequestBodyStream contentStream;
                        this.currentRequestStream = contentStream = new Netty4HttpRequestBodyStream(ctx.channel(), this.serverTransport.getThreadPool().getThreadContext());
                        netty4HttpRequest = new Netty4HttpRequest(this.readSequence++, request, contentStream);
                    }
                }
                this.handlePipelinedRequest(ctx, netty4HttpRequest);
            } else {
                assert (msg instanceof HttpContent) : "expect HttpContent got " + String.valueOf(msg);
                assert (this.currentRequestStream != null) : "current stream must exists before handling http content";
                this.currentRequestStream.handleNettyContent((HttpContent)msg);
                if (msg instanceof LastHttpContent) {
                    this.currentRequestStream = null;
                }
            }
        }
        finally {
            this.activityTracker.stopActivity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePipelinedRequest(ChannelHandlerContext ctx, Netty4HttpRequest pipelinedRequest) {
        Netty4HttpChannel channel = (Netty4HttpChannel)ctx.channel().attr(Netty4HttpServerTransport.HTTP_CHANNEL_KEY).get();
        boolean success = false;
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.serverTransport.getThreadPool().getThreadContext()));
        assert (Transports.assertTransportThread());
        try {
            this.serverTransport.incomingRequest(pipelinedRequest, channel);
            success = true;
        }
        finally {
            if (!success) {
                pipelinedRequest.release();
            }
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        assert (msg instanceof Netty4HttpResponse) : "Invalid message type: " + String.valueOf(msg.getClass());
        Netty4HttpResponse restResponse = (Netty4HttpResponse)msg;
        if (restResponse.getSequence() != this.writeSequence) {
            this.enqueuePipelinedResponse(ctx, restResponse, promise);
        } else {
            this.doWrite(ctx, restResponse, promise);
            this.doWriteQueued(ctx);
        }
    }

    private void enqueuePipelinedResponse(ChannelHandlerContext ctx, Netty4HttpResponse restResponse, ChannelPromise promise) {
        assert (!(restResponse instanceof Netty4ChunkedHttpContinuation)) : "received out-of-order continuation at [" + restResponse.getSequence() + "], expecting [" + this.writeSequence + "]";
        assert (restResponse.getSequence() > this.writeSequence) : "response sequence [" + restResponse.getSequence() + "] we below write sequence [" + this.writeSequence + "]";
        if (this.outboundHoldingQueue.size() >= this.maxEventsHeld) {
            ctx.channel().close();
            promise.tryFailure((Throwable)new ClosedChannelException());
        } else {
            assert (this.outboundHoldingQueue.stream().noneMatch(t -> ((Netty4HttpResponse)t.v1()).getSequence() == restResponse.getSequence())) : "duplicate outbound entries for seqno " + restResponse.getSequence();
            this.outboundHoldingQueue.add((Tuple<? extends Netty4HttpResponse, ChannelPromise>)new Tuple((Object)restResponse, (Object)promise));
        }
    }

    private void doWriteQueued(ChannelHandlerContext ctx) {
        while (!this.outboundHoldingQueue.isEmpty() && ((Netty4HttpResponse)this.outboundHoldingQueue.peek().v1()).getSequence() == this.writeSequence) {
            Tuple<? extends Netty4HttpResponse, ChannelPromise> top = this.outboundHoldingQueue.poll();
            assert (top != null) : "we know the outbound holding queue to not be empty at this point";
            this.doWrite(ctx, (Netty4HttpResponse)top.v1(), (ChannelPromise)top.v2());
        }
    }

    private void doWrite(ChannelHandlerContext ctx, Netty4HttpResponse readyResponse, ChannelPromise promise) {
        assert (this.currentChunkedWrite == null) : "unexpected existing write [" + String.valueOf(this.currentChunkedWrite) + "]";
        assert (readyResponse != null) : "cannot write null response";
        assert (readyResponse.getSequence() == this.writeSequence);
        if (readyResponse instanceof Netty4FullHttpResponse) {
            Netty4FullHttpResponse fullResponse = (Netty4FullHttpResponse)readyResponse;
            this.doWriteFullResponse(ctx, fullResponse, promise);
        } else if (readyResponse instanceof Netty4ChunkedHttpResponse) {
            Netty4ChunkedHttpResponse chunkedResponse = (Netty4ChunkedHttpResponse)readyResponse;
            this.doWriteChunkedResponse(ctx, chunkedResponse, promise);
        } else if (readyResponse instanceof Netty4ChunkedHttpContinuation) {
            Netty4ChunkedHttpContinuation chunkedContinuation = (Netty4ChunkedHttpContinuation)readyResponse;
            this.doWriteChunkedContinuation(ctx, chunkedContinuation, promise);
        } else {
            assert (false) : readyResponse.getClass().getCanonicalName();
            throw new IllegalStateException("illegal message type: " + readyResponse.getClass().getCanonicalName());
        }
    }

    private void doWriteFullResponse(ChannelHandlerContext ctx, Netty4FullHttpResponse readyResponse, ChannelPromise promise) {
        if (DO_NOT_SPLIT_HTTP_RESPONSES || readyResponse.content().readableBytes() <= SPLIT_THRESHOLD) {
            this.enqueueWrite(ctx, (HttpObject)readyResponse, promise);
        } else {
            this.splitAndWrite(ctx, readyResponse, promise);
        }
        ++this.writeSequence;
    }

    private void doWriteChunkedResponse(ChannelHandlerContext ctx, Netty4ChunkedHttpResponse readyResponse, ChannelPromise promise) {
        PromiseCombiner combiner = new PromiseCombiner(ctx.executor());
        ChannelPromise first = ctx.newPromise();
        combiner.add((Future)first);
        ChunkedRestResponseBodyPart firstBodyPart = readyResponse.firstBodyPart();
        assert (this.currentChunkedWrite == null);
        this.currentChunkedWrite = new ChunkedWrite(combiner, promise, firstBodyPart);
        if (this.enqueueWrite(ctx, (HttpObject)readyResponse, first)) {
            while (ctx.channel().isWritable()) {
                if (!this.writeChunk(ctx, this.currentChunkedWrite)) continue;
                this.finishChunkedWrite();
                return;
            }
        }
    }

    private void doWriteChunkedContinuation(ChannelHandlerContext ctx, Netty4ChunkedHttpContinuation continuation, ChannelPromise promise) {
        PromiseCombiner combiner = continuation.combiner();
        assert (this.currentChunkedWrite == null);
        ChunkedRestResponseBodyPart bodyPart = continuation.bodyPart();
        assert (!bodyPart.isPartComplete()) : "response with continuations must have at least one (possibly-empty) chunk in each part";
        this.currentChunkedWrite = new ChunkedWrite(combiner, promise, bodyPart);
        while (ctx.channel().isWritable()) {
            if (!this.writeChunk(ctx, this.currentChunkedWrite)) continue;
            this.finishChunkedWrite();
            return;
        }
    }

    private void finishChunkedWrite() {
        if (this.currentChunkedWrite == null) {
            return;
        }
        final ChunkedWrite finishingWrite = this.currentChunkedWrite;
        this.currentChunkedWrite = null;
        ChunkedRestResponseBodyPart finishingWriteBodyPart = finishingWrite.responseBodyPart();
        assert (finishingWriteBodyPart.isPartComplete());
        boolean endOfResponse = finishingWriteBodyPart.isLastPart();
        if (endOfResponse) {
            ++this.writeSequence;
            finishingWrite.combiner().finish((Promise)finishingWrite.onDone());
        } else {
            final ThreadContext threadContext = this.serverTransport.getThreadPool().getThreadContext();
            assert (Transports.assertDefaultThreadContext((ThreadContext)threadContext));
            final Channel channel = finishingWrite.onDone().channel();
            ActionListener.run((ActionListener)new ContextPreservingActionListener(threadContext.newRestorableContext(false), ActionListener.assertOnce((ActionListener)new ActionListener<ChunkedRestResponseBodyPart>(){

                public void onResponse(ChunkedRestResponseBodyPart continuation) {
                    assert (Transports.assertDefaultThreadContext((ThreadContext)threadContext));
                    channel.eventLoop().execute(() -> channel.writeAndFlush((Object)new Netty4ChunkedHttpContinuation(Netty4HttpPipeliningHandler.this.writeSequence, continuation, finishingWrite.combiner()), finishingWrite.onDone()));
                    this.checkShutdown();
                }

                public void onFailure(Exception e) {
                    assert (Transports.assertDefaultThreadContext((ThreadContext)threadContext));
                    logger.error(Strings.format((String)"failed to get continuation of HTTP response body for [%s], closing connection", (Object[])new Object[]{channel}), (Throwable)e);
                    Netty4Utils.addListener(channel.close(), f -> {
                        finishingWrite.combiner().add((Future)f.channel().newFailedFuture((Throwable)e));
                        finishingWrite.combiner().finish((Promise)finishingWrite.onDone());
                    });
                    this.checkShutdown();
                }

                private void checkShutdown() {
                    if (channel.eventLoop().isShuttingDown()) {
                        channel.eventLoop().terminationFuture().addListener(ignored -> finishingWrite.onDone().tryFailure((Throwable)new ClosedChannelException()));
                    }
                }
            })), arg_0 -> ((ChunkedRestResponseBodyPart)finishingWriteBodyPart).getNextPart(arg_0));
        }
    }

    private void splitAndWrite(ChannelHandlerContext ctx, Netty4FullHttpResponse msg, ChannelPromise promise) {
        PromiseCombiner combiner = new PromiseCombiner(ctx.executor());
        DefaultHttpResponse response = new DefaultHttpResponse(msg.protocolVersion(), msg.status(), msg.headers());
        combiner.add(this.enqueueWrite(ctx, (HttpObject)response));
        ByteBuf content = msg.content();
        while (content.readableBytes() > SPLIT_THRESHOLD) {
            combiner.add(this.enqueueWrite(ctx, (HttpObject)new DefaultHttpContent(content.readRetainedSlice(SPLIT_THRESHOLD))));
        }
        combiner.add(this.enqueueWrite(ctx, (HttpObject)new DefaultLastHttpContent(content.readRetainedSlice(content.readableBytes()))));
        combiner.finish((Promise)promise);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws IOException {
        if (ctx.channel().isWritable()) {
            this.doFlush(ctx);
        }
        ctx.fireChannelWritabilityChanged();
    }

    public void flush(ChannelHandlerContext ctx) throws IOException {
        if (!this.doFlush(ctx)) {
            ctx.flush();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.doFlush(ctx);
        super.channelInactive(ctx);
    }

    private boolean doFlush(ChannelHandlerContext ctx) throws IOException {
        assert (ctx.executor().inEventLoop());
        Channel channel = ctx.channel();
        if (!channel.isActive()) {
            this.failQueuedWrites(ctx);
            return false;
        }
        while (channel.isWritable()) {
            WriteOperation currentWrite = this.queuedWrites.poll();
            if (currentWrite == null) {
                this.doWriteQueued(ctx);
                if (!channel.isWritable()) break;
                currentWrite = this.queuedWrites.poll();
            }
            if (currentWrite == null) {
                if (this.currentChunkedWrite == null) break;
                if (!this.writeChunk(ctx, this.currentChunkedWrite)) continue;
                this.finishChunkedWrite();
                continue;
            }
            ctx.write((Object)currentWrite.msg, currentWrite.promise);
        }
        ctx.flush();
        if (!channel.isActive()) {
            this.failQueuedWrites(ctx);
        }
        return true;
    }

    private boolean writeChunk(ChannelHandlerContext ctx, ChunkedWrite chunkedWrite) {
        ReleasableBytesReference bytes;
        ChunkedRestResponseBodyPart bodyPart = chunkedWrite.responseBodyPart();
        PromiseCombiner combiner = chunkedWrite.combiner();
        assert (!bodyPart.isPartComplete()) : "should not continue to try and serialize once done";
        try {
            bytes = bodyPart.encodeChunk(262144, this.serverTransport.recycler());
        }
        catch (Exception e) {
            return this.handleChunkingFailure(ctx, chunkedWrite, e);
        }
        ByteBuf content = Netty4Utils.toByteBuf((BytesReference)bytes);
        boolean isPartComplete = bodyPart.isPartComplete();
        boolean isBodyComplete = isPartComplete && bodyPart.isLastPart();
        ChannelFuture f = ctx.write(isBodyComplete ? new DefaultLastHttpContent(content) : new DefaultHttpContent(content));
        Netty4Utils.addListener(f, ignored -> bytes.close());
        combiner.add((Future)f);
        return isPartComplete;
    }

    private boolean handleChunkingFailure(ChannelHandlerContext ctx, ChunkedWrite chunkedWrite, Exception e) {
        logger.error(Strings.format((String)"caught exception while encoding response chunk, closing connection %s", (Object[])new Object[]{ctx.channel()}), (Throwable)e);
        assert (this.currentChunkedWrite == chunkedWrite);
        this.currentChunkedWrite = null;
        chunkedWrite.combiner().add((Future)ctx.channel().close());
        chunkedWrite.combiner().add((Future)ctx.newFailedFuture((Throwable)e));
        chunkedWrite.combiner().finish((Promise)chunkedWrite.onDone());
        return true;
    }

    private void failQueuedWrites(ChannelHandlerContext ctx) {
        Tuple<? extends Netty4HttpResponse, ChannelPromise> pipelinedWrite;
        WriteOperation queuedWrite;
        while ((queuedWrite = this.queuedWrites.poll()) != null) {
            queuedWrite.failAsClosedChannel();
        }
        if (this.currentChunkedWrite != null) {
            ChunkedWrite chunkedWrite = this.currentChunkedWrite;
            this.currentChunkedWrite = null;
            chunkedWrite.combiner().add((Future)ctx.newFailedFuture((Throwable)new ClosedChannelException()));
            chunkedWrite.combiner().finish((Promise)chunkedWrite.onDone());
        }
        while ((pipelinedWrite = this.outboundHoldingQueue.poll()) != null) {
            ((ChannelPromise)pipelinedWrite.v2()).tryFailure((Throwable)new ClosedChannelException());
        }
    }

    private Future<Void> enqueueWrite(ChannelHandlerContext ctx, HttpObject msg) {
        ChannelPromise p = ctx.newPromise();
        this.enqueueWrite(ctx, msg, p);
        return p;
    }

    private boolean enqueueWrite(ChannelHandlerContext ctx, HttpObject msg, ChannelPromise promise) {
        if (ctx.channel().isWritable() && this.queuedWrites.isEmpty()) {
            ctx.write((Object)msg, promise);
            return true;
        }
        this.queuedWrites.add(new WriteOperation(msg, promise));
        return false;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.serverTransport.getThreadPool().getThreadContext()));
        Netty4HttpChannel channel = (Netty4HttpChannel)ctx.channel().attr(Netty4HttpServerTransport.HTTP_CHANNEL_KEY).get();
        if (cause instanceof Error) {
            this.serverTransport.onException(channel, new Exception(cause));
        } else {
            this.serverTransport.onException(channel, (Exception)cause);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        SslCloseCompletionEvent closeEvent;
        if (evt instanceof SslCloseCompletionEvent && (closeEvent = (SslCloseCompletionEvent)evt).isSuccess() && ctx.channel().isActive()) {
            logger.trace("received TLS close_notify, closing connection {}", (Object)ctx.channel());
            ctx.channel().close();
        }
    }

    private record ChunkedWrite(PromiseCombiner combiner, ChannelPromise onDone, ChunkedRestResponseBodyPart responseBodyPart) {
    }

    private record WriteOperation(HttpObject msg, ChannelPromise promise) {
        void failAsClosedChannel() {
            this.promise.tryFailure((Throwable)new ClosedChannelException());
            ReferenceCountUtil.release((Object)this.msg);
        }
    }
}

