/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.ldap;

import com.floragunn.codova.config.templates.AttributeSource;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.AuthenticationBackend;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.UserInformationBackend;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auth.ldap.GroupSearch;
import com.floragunn.searchguard.enterprise.auth.ldap.LDAP;
import com.floragunn.searchguard.enterprise.auth.ldap.LDAPConnectionManager;
import com.floragunn.searchguard.enterprise.auth.ldap.SearchFilter;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.PrivilegedCode;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LDAPAuthenticationBackend
implements AuthenticationBackend,
UserInformationBackend,
AutoCloseable {
    public static final String TYPE = "ldap";
    protected static final Logger log = LogManager.getLogger(LDAPAuthenticationBackend.class);
    private final LDAPConnectionManager connectionManager;
    private final String userSearchBaseDn;
    private final SearchScope userSearchScope;
    private final SearchFilter userSearchFilter;
    private final String[] userSearchAttributes;
    private final GroupSearch groupSearch;
    private final boolean fakeLoginEnabled;
    private final String fakeLoginDn;
    private final byte[] fakeLoginPassword;
    private final ComponentState componentState = new ComponentState(0, "authentication_backend", "ldap", LDAPAuthenticationBackend.class).initialized().requiresEnterpriseLicense();
    public static Collection<TypedComponent.Info<?>> INFOS = ImmutableList.of((Object)new TypedComponent.Info<AuthenticationBackend>(){

        public Class<AuthenticationBackend> getType() {
            return AuthenticationBackend.class;
        }

        public String getName() {
            return LDAPAuthenticationBackend.TYPE;
        }

        public TypedComponent.Factory<AuthenticationBackend> getFactory() {
            return LDAPAuthenticationBackend::new;
        }
    }, (Object)new TypedComponent.Info<UserInformationBackend>(){

        public Class<UserInformationBackend> getType() {
            return UserInformationBackend.class;
        }

        public String getName() {
            return LDAPAuthenticationBackend.TYPE;
        }

        public TypedComponent.Factory<UserInformationBackend> getFactory() {
            return LDAPAuthenticationBackend::new;
        }
    });

    public LDAPAuthenticationBackend(Map<String, Object> config, ConfigurationRepository.Context context) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(config, validationErrors, (Parser.Context)context);
        this.connectionManager = (LDAPConnectionManager)vNode.get("idp").required().by(LDAPConnectionManager::new);
        this.userSearchBaseDn = vNode.get("user_search.base_dn").withDefault("").asString();
        this.userSearchScope = (SearchScope)vNode.get("user_search.scope").withDefault((Object)SearchScope.SUB).byString(LDAP::getSearchScope);
        this.userSearchFilter = (SearchFilter)vNode.get("user_search.filter").withDefault((Object)SearchFilter.DEFAULT).by(SearchFilter::parseForUserSearch);
        this.userSearchAttributes = (String[])vNode.get("user_search.retrieve_attributes").withListDefault(new String[]{"+", "*"}).ofStrings().toArray((Object[])new String[0]);
        this.groupSearch = (GroupSearch)vNode.get("group_search").by(GroupSearch::new);
        this.fakeLoginEnabled = vNode.get("fake_login.enabled").withDefault(false).asBoolean();
        this.fakeLoginDn = vNode.get("fake_login.password").asString();
        this.fakeLoginPassword = vNode.get("fake_login.password").withDefault("fakeLoginPwd123").asString().getBytes();
        validationErrors.throwExceptionForPresentErrors();
        this.componentState.addPart(this.connectionManager.getComponentState());
    }

    public CompletableFuture<AuthCredentials> authenticate(AuthCredentials credentials, Meter meter) throws AuthenticatorUnavailableException, CredentialsException {
        SearchResultEntry entry = (SearchResultEntry)PrivilegedCode.execute(() -> this.search(credentials, meter), AuthenticatorUnavailableException.class);
        if (entry == null) {
            if (this.fakeLoginEnabled) {
                Object fakeLoginDn = this.fakeLoginDn != null ? this.fakeLoginDn : "CN=faketomakebindfail,DC=" + UUID.randomUUID().toString();
                try (Meter subMeter2 = meter.detail("invalid_login_delay");){
                    this.checkPassword((String)fakeLoginDn, this.fakeLoginPassword);
                }
                catch (LDAPException subMeter2) {
                    // empty catch block
                }
            }
            throw new CredentialsException(new AuthcResult.DebugInfo(TYPE, false, "User could not be found by query", (Map)ImmutableMap.of((Object)"user_name", (Object)credentials.getName())));
        }
        String dn = entry.getDN();
        if (log.isTraceEnabled()) {
            log.trace("Try to authenticate dn {}", (Object)dn);
        }
        try (Meter subMeter = meter.detail("check_password");){
            this.checkPassword(entry.getDN(), credentials.getPassword());
        }
        catch (LDAPException e2) {
            throw new CredentialsException(new AuthcResult.DebugInfo(TYPE, false, "User could not be authenticated by password", (Map)OrderedImmutableMap.of((Object)"user_name", (Object)credentials.getName(), (Object)"dn", (Object)entry.getDN(), (Object)"ldap_error", (Object)e2.getMessage()).with(LDAP.getDetailsFrom(e2))), (Throwable)e2);
        }
        AuthCredentials updatedCredentials = credentials.userMappingAttribute("ldap_user_entry", this.entryToMap((Entry)entry));
        AuthCredentials.Builder resultBuilder = updatedCredentials.copy();
        if (this.groupSearch != null) {
            Set<Entry> groupEntries = this.searchGroups(entry, updatedCredentials, meter);
            resultBuilder.userMappingAttribute("ldap_group_entries", (Object)ImmutableList.map(groupEntries, e -> this.entryToMap((Entry)e)));
            resultBuilder.backendRoles(this.extractRoles(groupEntries));
        }
        return CompletableFuture.completedFuture(resultBuilder.authDomainInfo(credentials.getAuthDomainInfo().authBackendType(this.getType())).build());
    }

    public CompletableFuture<AuthCredentials> getUserInformation(AuthCredentials userInformation, Meter meter) throws AuthenticatorUnavailableException {
        SearchResultEntry entry = (SearchResultEntry)PrivilegedCode.execute(() -> this.search(userInformation, meter), AuthenticatorUnavailableException.class);
        if (entry == null) {
            return CompletableFuture.completedFuture(null);
        }
        AuthCredentials updatedCredentials = userInformation.userMappingAttribute("ldap_user_entry", this.entryToMap((Entry)entry));
        AuthCredentials.Builder resultBuilder = updatedCredentials.copy();
        if (this.groupSearch != null) {
            Set<Entry> groupEntries = this.searchGroups(entry, updatedCredentials, meter);
            resultBuilder.userMappingAttribute("ldap_group_entries", (Object)ImmutableList.map(groupEntries, e -> this.entryToMap((Entry)e)));
            resultBuilder.backendRoles(this.extractRoles(groupEntries));
        }
        return CompletableFuture.completedFuture(resultBuilder.build());
    }

    public String getType() {
        return TYPE;
    }

    @Override
    public void close() {
        if (this.connectionManager != null) {
            try {
                this.connectionManager.close();
            }
            catch (IOException e) {
                log.warn("Error while closing " + this.connectionManager, (Throwable)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private SearchResultEntry search(AuthCredentials userName, Meter meter) throws AuthenticatorUnavailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Set<Entry> searchGroups(SearchResultEntry entry, AuthCredentials credentials, Meter meter) throws AuthenticatorUnavailableException {
        try (Meter subMeter = meter.detail("group_search");){
            Set<Entry> set;
            block12: {
                LDAPConnection connection = this.connectionManager.getConnection();
                try {
                    set = this.groupSearch.search(connection, entry.getDN(), AttributeSource.from((Map)credentials.getAttributesForUserMapping()), subMeter);
                    if (connection == null) break block12;
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                connection.close();
            }
            return set;
        }
    }

    private void checkPassword(String dn, byte[] password) throws LDAPException {
        PrivilegedCode.execute(() -> this.connectionManager.getPool().bindAndRevertAuthentication((BindRequest)new SimpleBindRequest(dn, password)), LDAPException.class);
    }

    private ImmutableMap<String, Object> entryToMap(Entry entry) {
        ImmutableMap.Builder result = new ImmutableMap.Builder();
        result.with((Object)"dn", (Object)entry.getDN());
        for (Attribute attribute : entry.getAttributes()) {
            result.with((Object)attribute.getName(), Arrays.asList(attribute.getValues()));
        }
        return result.build();
    }

    private ImmutableSet<String> extractRoles(Set<Entry> groupEntries) {
        String roleNameAttribute = this.groupSearch.getRoleNameAttribute();
        if (roleNameAttribute == null || groupEntries.isEmpty()) {
            return ImmutableSet.empty();
        }
        ImmutableSet.Builder result = new ImmutableSet.Builder();
        for (Entry entry : groupEntries) {
            if ("dn".equalsIgnoreCase(roleNameAttribute)) {
                result.add((Object)entry.getDN());
                continue;
            }
            Object[] values = entry.getAttributeValues(roleNameAttribute);
            if (values == null || values.length <= 0) continue;
            result.addAll(values);
        }
        return result.build();
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

