/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.enterprise.auth.oidc.BadCredentialsException;
import java.util.ArrayList;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;

public interface KeyProvider {
    public JsonWebKey getKey(String var1) throws AuthenticatorUnavailableException, BadCredentialsException;

    public JsonWebKey getKeyAfterRefresh(String var1) throws AuthenticatorUnavailableException, BadCredentialsException;

    public static KeyProvider combined(KeyProvider ... providers) {
        final ArrayList<KeyProvider> providersList = new ArrayList<KeyProvider>();
        for (KeyProvider keyProvider : providers) {
            if (keyProvider == null) continue;
            providersList.add(keyProvider);
        }
        return new KeyProvider(){

            @Override
            public JsonWebKey getKeyAfterRefresh(String kid) throws AuthenticatorUnavailableException, BadCredentialsException {
                for (KeyProvider keyProvider : providersList) {
                    JsonWebKey result = keyProvider.getKeyAfterRefresh(kid);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }

            @Override
            public JsonWebKey getKey(String kid) throws AuthenticatorUnavailableException, BadCredentialsException {
                for (KeyProvider keyProvider : providersList) {
                    JsonWebKey result = keyProvider.getKey(kid);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
        };
    }
}

