/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.jwt.keybyoidc;

import com.floragunn.codova.config.net.ProxyConfig;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.OidcProviderConfig;
import com.floragunn.dlic.util.SettingsBasedSSLConfigurator;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;

public class OpenIdProviderClient {
    private static final Logger log = LogManager.getLogger(OpenIdProviderClient.class);
    private static final long CACHE_STATUS_LOG_INTERVAL_MS = 3600000L;
    private URI openIdConnectEndpoint;
    private SettingsBasedSSLConfigurator.SSLConfig sslConfig;
    private ProxyConfig proxyConfig;
    private int requestTimeoutMs = 10000;
    private CacheConfig cacheConfig;
    private HttpCacheStorage oidcHttpCacheStorage;
    private int oidcCacheHits = 0;
    private int oidcCacheMisses = 0;
    private int oidcCacheHitsValidated = 0;
    private int oidcCacheModuleResponses = 0;
    private long oidcRequests = 0L;
    private long lastCacheStatusLog = 0L;

    public OpenIdProviderClient(URI openIdConnectEndpoint, SettingsBasedSSLConfigurator.SSLConfig sslConfig, ProxyConfig proxyConfig, boolean useCacheForOidConnectEndpoint) {
        this.openIdConnectEndpoint = openIdConnectEndpoint;
        this.sslConfig = sslConfig;
        this.proxyConfig = proxyConfig;
        if (useCacheForOidConnectEndpoint) {
            this.cacheConfig = CacheConfig.custom().setMaxCacheEntries(10).setMaxObjectSize(0x100000L).build();
            this.oidcHttpCacheStorage = new BasicHttpCacheStorage(this.cacheConfig);
        }
    }

    public OidcProviderConfig getOidcConfiguration() throws AuthenticatorUnavailableException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(() -> {
                try (CloseableHttpClient httpClient = this.createHttpClient(this.oidcHttpCacheStorage);){
                    OidcProviderConfig oidcProviderConfig;
                    block18: {
                        HttpGet httpGet = new HttpGet(this.openIdConnectEndpoint);
                        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.getRequestTimeoutMs()).setConnectTimeout(this.getRequestTimeoutMs()).setSocketTimeout(this.getRequestTimeoutMs()).build();
                        httpGet.setConfig(requestConfig);
                        HttpCacheContext httpContext = null;
                        if (this.oidcHttpCacheStorage != null) {
                            httpContext = new HttpCacheContext();
                        }
                        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)httpContext);
                        try {
                            StatusLine statusLine;
                            if (httpContext != null) {
                                this.logCacheResponseStatus(httpContext);
                            }
                            if ((statusLine = response.getStatusLine()).getStatusCode() < 200 || statusLine.getStatusCode() >= 300) {
                                throw new AuthenticatorUnavailableException("IdP error", "Error while getting " + this.openIdConnectEndpoint + ": " + statusLine);
                            }
                            HttpEntity httpEntity = response.getEntity();
                            if (httpEntity == null) {
                                throw new AuthenticatorUnavailableException("IdP error", "Error while getting " + this.openIdConnectEndpoint + ": Empty response entity");
                            }
                            oidcProviderConfig = new OidcProviderConfig(DocReader.json().readObject(httpEntity.getContent()));
                            if (response == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        response.close();
                    }
                    return oidcProviderConfig;
                }
                catch (IOException e) {
                    throw new AuthenticatorUnavailableException("Error while getting " + this.openIdConnectEndpoint + ": " + e, (Throwable)e);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof AuthenticatorUnavailableException) {
                throw (AuthenticatorUnavailableException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public JsonWebKeys getJsonWebKeys() throws AuthenticatorUnavailableException {
        URI uri = this.getJwksUri();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(() -> {
                try (CloseableHttpClient httpClient = this.createHttpClient(null);){
                    JsonWebKeys jsonWebKeys;
                    block16: {
                        HttpGet httpGet = new HttpGet(uri);
                        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.getRequestTimeoutMs()).setConnectTimeout(this.getRequestTimeoutMs()).setSocketTimeout(this.getRequestTimeoutMs()).build();
                        httpGet.setConfig(requestConfig);
                        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                        try {
                            JsonWebKeys keySet;
                            StatusLine statusLine = response.getStatusLine();
                            if (statusLine.getStatusCode() < 200 || statusLine.getStatusCode() >= 300) {
                                throw new AuthenticatorUnavailableException("IdP error", "Error while getting " + uri + ": " + statusLine);
                            }
                            HttpEntity httpEntity = response.getEntity();
                            if (httpEntity == null) {
                                throw new AuthenticatorUnavailableException("IdP error", "Error while getting " + uri + ": Empty response entity");
                            }
                            jsonWebKeys = keySet = JwkUtils.readJwkSet((InputStream)httpEntity.getContent());
                            if (response == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        response.close();
                    }
                    return jsonWebKeys;
                }
                catch (IOException e) {
                    throw new AuthenticatorUnavailableException("Error while getting " + uri + ": " + e, (Throwable)e);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof AuthenticatorUnavailableException) {
                throw (AuthenticatorUnavailableException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public TokenResponse callTokenEndpoint(String clientId, String clientSecret, String scope, String authCode, String redirectUri) throws AuthenticatorUnavailableException {
        List<NameValuePair> request = Arrays.asList(new BasicNameValuePair("client_id", clientId), new BasicNameValuePair("client_secret", clientSecret), new BasicNameValuePair("grant_type", "authorization_code"), new BasicNameValuePair("code", authCode), new BasicNameValuePair("redirect_uri", redirectUri));
        OidcProviderConfig oidcProviderConfg = this.getOidcConfiguration();
        String tokenEndpoint = oidcProviderConfg.getTokenEndpoint();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(() -> {
                try (CloseableHttpClient httpClient = this.createHttpClient(null);){
                    TokenResponse tokenResponse;
                    block15: {
                        HttpPost httpPost = new HttpPost(tokenEndpoint);
                        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(request, "utf-8"));
                        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.getRequestTimeoutMs()).setConnectTimeout(this.getRequestTimeoutMs()).setSocketTimeout(this.getRequestTimeoutMs()).build();
                        httpPost.setConfig(requestConfig);
                        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                        try {
                            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                            if (response.getStatusLine().getStatusCode() >= 300 || response.getStatusLine().getStatusCode() < 200) {
                                throw new AuthenticatorUnavailableException("IdP error", "Error response from token endpoint:\n" + response.getStatusLine() + "\n" + responseBody);
                            }
                            Map responseJsonBody = DocReader.json().readObject(responseBody);
                            tokenResponse = new TokenResponse(responseJsonBody);
                            if (response == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        response.close();
                    }
                    return tokenResponse;
                }
                catch (IOException e) {
                    throw new AuthenticatorUnavailableException("Error while calling " + tokenEndpoint, (Throwable)e);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof AuthenticatorUnavailableException) {
                throw (AuthenticatorUnavailableException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public HttpResponse callTokenEndpoint(byte[] body, ContentType contentType) throws AuthenticatorUnavailableException {
        OidcProviderConfig oidcProviderConfg = this.getOidcConfiguration();
        String tokenEndpoint = oidcProviderConfg.getTokenEndpoint();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(() -> {
                try (CloseableHttpClient httpClient = this.createHttpClient(null);){
                    BasicHttpResponse basicHttpResponse;
                    block14: {
                        HttpPost httpPost = new HttpPost(tokenEndpoint);
                        httpPost.setEntity((HttpEntity)new ByteArrayEntity(body, contentType));
                        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.getRequestTimeoutMs()).setConnectTimeout(this.getRequestTimeoutMs()).setSocketTimeout(this.getRequestTimeoutMs()).build();
                        httpPost.setConfig(requestConfig);
                        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                        try {
                            BasicHttpResponse copiedResponse = new BasicHttpResponse(response.getStatusLine());
                            copiedResponse.setEntity((HttpEntity)new ByteArrayEntity(EntityUtils.toByteArray((HttpEntity)response.getEntity()), ContentType.getOrDefault((HttpEntity)response.getEntity())));
                            basicHttpResponse = copiedResponse;
                            if (response == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        response.close();
                    }
                    return basicHttpResponse;
                }
                catch (IOException e) {
                    throw new AuthenticatorUnavailableException("Error while calling " + tokenEndpoint, (Throwable)e);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof AuthenticatorUnavailableException) {
                throw (AuthenticatorUnavailableException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    URI getJwksUri() throws AuthenticatorUnavailableException {
        return this.getOidcConfiguration().getJwksUri();
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public void setRequestTimeoutMs(int httpTimeoutMs) {
        this.requestTimeoutMs = httpTimeoutMs;
    }

    private void logCacheResponseStatus(HttpCacheContext httpContext) {
        ++this.oidcRequests;
        switch (httpContext.getCacheResponseStatus()) {
            case CACHE_HIT: {
                ++this.oidcCacheHits;
                break;
            }
            case CACHE_MODULE_RESPONSE: {
                ++this.oidcCacheModuleResponses;
                break;
            }
            case CACHE_MISS: {
                ++this.oidcCacheMisses;
                break;
            }
            case VALIDATED: {
                ++this.oidcCacheHitsValidated;
            }
        }
        long now = System.currentTimeMillis();
        if (this.oidcRequests >= 2L && now - this.lastCacheStatusLog > 3600000L) {
            log.info("Cache status for KeySetRetriever:\noidcCacheHits: " + this.oidcCacheHits + "\noidcCacheHitsValidated: " + this.oidcCacheHitsValidated + "\noidcCacheModuleResponses: " + this.oidcCacheModuleResponses + "\noidcCacheMisses: " + this.oidcCacheMisses);
            this.lastCacheStatusLog = now;
        }
    }

    private CloseableHttpClient createHttpClient(HttpCacheStorage httpCacheStorage) {
        Object builder = httpCacheStorage != null ? CachingHttpClients.custom().setCacheConfig(this.cacheConfig).setHttpCacheStorage(httpCacheStorage) : HttpClients.custom();
        if (this.proxyConfig != null) {
            this.proxyConfig.apply(builder);
        }
        builder.useSystemProperties();
        if (this.sslConfig != null) {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslConfig.toSSLConnectionSocketFactory());
        }
        return builder.build();
    }

    public int getOidcCacheHits() {
        return this.oidcCacheHits;
    }

    public int getOidcCacheMisses() {
        return this.oidcCacheMisses;
    }

    public int getOidcCacheHitsValidated() {
        return this.oidcCacheHitsValidated;
    }

    public int getOidcCacheModuleResponses() {
        return this.oidcCacheModuleResponses;
    }

    public static class TokenResponse {
        private final String accessToken;
        private final String tokenType;
        private final String refreshToken;
        private final long expiresIn;
        private final String idToken;

        TokenResponse(String accessToken, String tokenType, String refreshToken, long expiresIn, String idToken) {
            this.accessToken = accessToken;
            this.tokenType = tokenType;
            this.refreshToken = refreshToken;
            this.expiresIn = expiresIn;
            this.idToken = idToken;
        }

        TokenResponse(Map<String, Object> document) {
            this.accessToken = document.get("access_token") != null ? String.valueOf(document.get("access_token")) : null;
            this.tokenType = document.get("token_type") != null ? String.valueOf(document.get("token_type")) : null;
            this.refreshToken = document.get("refresh_token") != null ? String.valueOf(document.get("refresh_token")) : null;
            this.idToken = document.get("id_token") != null ? String.valueOf(document.get("id_token")) : null;
            this.expiresIn = document.get("expires_in") instanceof Number ? Long.valueOf(((Number)document.get("expires_in")).longValue()) : null;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public long getExpiresIn() {
            return this.expiresIn;
        }

        public String getIdToken() {
            return this.idToken;
        }

        public Map<String, Object> asMap() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("access_token", this.accessToken);
            result.put("token_type", this.tokenType);
            result.put("refresh_token", this.refreshToken);
            result.put("expires_in", this.expiresIn);
            result.put("id_token", this.idToken);
            return result;
        }
    }
}

