/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap2;

import com.floragunn.dlic.auth.ldap.LdapUser;
import com.floragunn.dlic.auth.ldap.util.Utils;
import com.floragunn.dlic.auth.ldap2.LDAPConnectionManager;
import com.floragunn.dlic.util.SettingsBasedSSLConfigurator;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.legacy.LegacyAuthenticationBackend;
import com.floragunn.searchguard.legacy.LegacyComponentFactory;
import com.floragunn.searchguard.user.Attributes;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResultEntry;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.settings.Settings;

public class LDAPAuthenticationBackend2
implements LegacyAuthenticationBackend,
AutoCloseable {
    protected static final Logger log = LogManager.getLogger(LDAPAuthenticationBackend2.class);
    private final Settings settings;
    private final LDAPConnectionManager lcm;
    private final int customAttrMaxValueLen;
    private final List<String> whitelistedAttributes;
    private Map<String, String> attributeMapping;
    public static TypedComponent.Info<LegacyAuthenticationBackend> INFO = new TypedComponent.Info<LegacyAuthenticationBackend>(){

        public Class<LegacyAuthenticationBackend> getType() {
            return LegacyAuthenticationBackend.class;
        }

        public String getName() {
            return "ldap2";
        }

        public TypedComponent.Factory<LegacyAuthenticationBackend> getFactory() {
            return LegacyComponentFactory.adapt(LDAPAuthenticationBackend2::new);
        }
    };

    public LDAPAuthenticationBackend2(Settings settings, Path configPath) {
        try {
            this.settings = settings;
            this.lcm = new LDAPConnectionManager(settings, configPath);
            this.customAttrMaxValueLen = settings.getAsInt("custom_attr_maxval_len", Integer.valueOf(36));
            this.whitelistedAttributes = settings.getAsList("custom_attr_whitelist", null);
            this.attributeMapping = Attributes.getFlatAttributeMapping((Settings)settings.getAsSettings("map_ldap_attrs_to_user_attrs"));
        }
        catch (SettingsBasedSSLConfigurator.SSLConfigException | LDAPException e) {
            throw new RuntimeException(e);
        }
    }

    public User authenticate(final AuthCredentials credentials) throws ElasticsearchSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<User>(){

                @Override
                public User run() throws Exception {
                    return LDAPAuthenticationBackend2.this.authenticate0(credentials);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof ElasticsearchSecurityException) {
                throw (ElasticsearchSecurityException)e.getException();
            }
            if (e.getException() instanceof RuntimeException) {
                throw (RuntimeException)e.getException();
            }
            throw new RuntimeException(e.getException());
        }
    }

    private User authenticate0(AuthCredentials credentials) throws ElasticsearchSecurityException {
        String user = credentials.getUsername();
        byte[] password = credentials.getPassword();
        try {
            SearchResultEntry entry = null;
            try (LDAPConnection con = this.lcm.getConnection();){
                entry = this.lcm.exists(con, user);
            }
            if (entry == null && this.settings.getAsBoolean("fakelogin_enabled", Boolean.valueOf(false)).booleanValue()) {
                String fakeLognDn = this.settings.get("fakelogin_dn", "CN=faketomakebindfail,DC=" + UUID.randomUUID().toString());
                entry = new SearchResultEntry(fakeLognDn, new Attribute[0], new Control[0]);
                password = this.settings.get("fakelogin_password", "fakeLoginPwd123").getBytes(StandardCharsets.UTF_8);
            } else if (entry == null) {
                throw new ElasticsearchSecurityException("No user " + user + " found", new Object[0]);
            }
            String dn = entry.getDN();
            if (log.isTraceEnabled()) {
                log.trace("Try to authenticate dn {}", (Object)dn);
            }
            this.lcm.checkDnPassword(dn, password);
            String usernameAttribute = this.settings.get("username_attribute", null);
            String username = dn;
            if (usernameAttribute != null && entry.getAttribute(usernameAttribute) != null) {
                username = Utils.getSingleStringValue(entry.getAttribute(usernameAttribute));
            }
            if (log.isDebugEnabled()) {
                log.debug("Authenticated username {}", (Object)username);
            }
            LdapUser ldapUser = new LdapUser(username, credentials.getAuthDomainInfo().authBackendType(this.getType()), user, new LdapUser.DirEntry(entry), credentials, this.customAttrMaxValueLen, this.whitelistedAttributes);
            this.processAttributeMapping(ldapUser, entry);
            LdapUser ldapUser2 = ldapUser;
            return ldapUser2;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to authenticate user due to ", (Throwable)e);
            }
            throw new ElasticsearchSecurityException(e.toString(), e, new Object[0]);
        }
        finally {
            Arrays.fill(password, (byte)0);
            password = null;
        }
    }

    public String getType() {
        return "ldap";
    }

    private void processAttributeMapping(User user, SearchResultEntry ldapEntry) {
        for (Map.Entry<String, String> entry : this.attributeMapping.entrySet()) {
            String sourceAttributeName = entry.getValue();
            String targetAttributeName = entry.getKey();
            if (sourceAttributeName.equals("dn")) {
                user.addStructuredAttribute(targetAttributeName, (Object)ldapEntry.getDN());
                continue;
            }
            Attribute ldapAttribute = ldapEntry.getAttribute(sourceAttributeName);
            if (ldapAttribute == null) continue;
            user.addStructuredAttribute(targetAttributeName, Arrays.asList(ldapAttribute.getValues()));
        }
    }

    @Override
    public void close() {
        if (this.lcm != null) {
            try {
                this.lcm.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean exists(final User user) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return LDAPAuthenticationBackend2.this.impersonate0(user);
            }
        });
    }

    private boolean impersonate0(User user) {
        boolean bl;
        block11: {
            String userName = user.getName();
            if (user instanceof LdapUser) {
                userName = ((LdapUser)user).getUserEntry().getDN();
            }
            LDAPConnection con = this.lcm.getConnection();
            try {
                boolean exists;
                SearchResultEntry userEntry = this.lcm.exists(con, userName);
                boolean bl2 = exists = userEntry != null;
                if (exists) {
                    user.addAttributes(LdapUser.extractLdapAttributes(userName, new LdapUser.DirEntry(userEntry), this.customAttrMaxValueLen, this.whitelistedAttributes));
                    this.processAttributeMapping(user, userEntry);
                }
                bl = exists;
                if (con == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("User {} does not exist due to " + e, (Object)userName);
                    if (log.isDebugEnabled()) {
                        log.debug("User does not exist due to ", (Throwable)e);
                    }
                    return false;
                }
            }
            con.close();
        }
        return bl;
    }
}

