/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.config.templates;

import com.floragunn.codova.config.templates.AttributeSource;
import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.config.templates.PipeExpression;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingFunction;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.function.Function;

public class Template<T> {
    private final T constantValue;
    private final ValidatingFunction<String, T> parser;
    private final ImmutableList<Token> tokens;
    private final int estimatedLength;
    private final Function<String, String> stringEscapeFunction;
    private final String source;

    public static <T> Template<T> constant(T constant, String source) {
        if (constant == null) {
            throw new IllegalArgumentException("null constants are not possible");
        }
        return new Template<T>(constant, source);
    }

    public static Template<String> string(String string) throws ConfigValidationException {
        return new Template<String>(string, ValidatingFunction.identity());
    }

    public Template(String string, ValidatingFunction<String, T> parser) throws ConfigValidationException {
        Object constantValue;
        ImmutableList.Builder tokens;
        block8: {
            tokens = null;
            constantValue = null;
            if (Template.containsPlaceholders(string)) {
                tokens = new ImmutableList.Builder();
                int i = 0;
                while (true) {
                    int openBracket;
                    if ((openBracket = string.indexOf("${", i)) == -1) {
                        if (i < string.length()) {
                            tokens.with((Object)new Token.Constant(string.substring(i)));
                        }
                        break block8;
                    }
                    if (i != openBracket) {
                        tokens.with((Object)new Token.Constant(string.substring(i, openBracket)));
                    }
                    PipeExpression.Parser pipeExpressionParser = new PipeExpression.Parser(string, openBracket + 2).expectTerminationCharacter();
                    tokens.with((Object)new Token.Placeholder(pipeExpressionParser.parse()));
                    i = pipeExpressionParser.getParsePosition();
                }
            }
            try {
                constantValue = parser.apply(string);
            }
            catch (ConfigValidationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause(e));
            }
        }
        this.constantValue = constantValue;
        this.tokens = tokens != null ? tokens.build() : null;
        this.parser = parser;
        this.estimatedLength = tokens != null ? Template.estimatedLength(this.tokens) : string.length();
        this.stringEscapeFunction = Function.identity();
        this.source = string;
    }

    private Template(T constantValue, String source) {
        this.constantValue = constantValue;
        this.source = source;
        this.parser = null;
        this.tokens = null;
        this.estimatedLength = -1;
        this.stringEscapeFunction = Function.identity();
    }

    private Template(T constantValue, String source, ValidatingFunction<String, T> parser, ImmutableList<Token> tokens, int estimatedLength, Function<String, String> stringEscapeFunction) {
        this.constantValue = constantValue;
        this.source = source;
        this.parser = parser;
        this.tokens = tokens;
        this.estimatedLength = estimatedLength;
        this.stringEscapeFunction = stringEscapeFunction;
    }

    public Template<T> stringEscapeFunction(Function<String, String> stringEscapeFunction) {
        return new Template<T>(this.constantValue, this.source, this.parser, this.tokens, this.estimatedLength, stringEscapeFunction);
    }

    public <T2> Template<T2> parser(ValidatingFunction<String, T2> parser) throws ConfigValidationException {
        T newConstantValue = null;
        if (this.constantValue != null) {
            try {
                newConstantValue = (T)parser.apply(this.source);
            }
            catch (ConfigValidationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause(e));
            }
        }
        return new Template<Object>(newConstantValue, this.source, (ValidatingFunction<String, Object>)parser, this.tokens, this.estimatedLength, this.stringEscapeFunction);
    }

    public Template<String> toStringTemplate() {
        return new Template<String>(this.constantValue != null ? this.source : null, this.source, ValidatingFunction.identity(), this.tokens, this.estimatedLength, this.stringEscapeFunction);
    }

    public boolean isConstant() {
        return this.constantValue != null;
    }

    public T getConstantValue() {
        return this.constantValue;
    }

    public String renderToString(AttributeSource valueResolver) throws ExpressionEvaluationException {
        if (this.constantValue != null) {
            return this.source;
        }
        StringBuilder result = new StringBuilder(this.estimatedLength);
        for (Token token : this.tokens) {
            result.append(token.render(valueResolver, this.stringEscapeFunction));
        }
        return result.toString();
    }

    public T render(AttributeSource valueResolver) throws ExpressionEvaluationException {
        if (this.constantValue != null) {
            return this.constantValue;
        }
        String string = this.renderToString(valueResolver);
        try {
            return this.parser.apply(string);
        }
        catch (ConfigValidationException e) {
            throw new ExpressionEvaluationException("Rendered value is not a valid object", e);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException("Rendered value is not a valid object", e);
        }
    }

    public String toString() {
        return this.source;
    }

    public String getSource() {
        return this.source;
    }

    public static boolean containsPlaceholders(String string) {
        return string.contains("${");
    }

    private static int estimatedLength(ImmutableList<Token> tokens) {
        int result = 0;
        for (Token token : tokens) {
            result += token.estimatedLength();
        }
        return result;
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Template)) {
            return false;
        }
        Template template = (Template)obj;
        return template.getSource().equals(this.source);
    }

    private static abstract class Token {
        private Token() {
        }

        abstract int estimatedLength();

        abstract String render(AttributeSource var1, Function<String, String> var2) throws ExpressionEvaluationException;

        static class Placeholder
        extends Token {
            private final PipeExpression pipeExpression;

            Placeholder(PipeExpression pipeExpression) {
                this.pipeExpression = pipeExpression;
            }

            @Override
            int estimatedLength() {
                return 20;
            }

            @Override
            String render(AttributeSource attributeSource, Function<String, String> stringEscapeFunction) throws ExpressionEvaluationException {
                Object value = this.pipeExpression.evaluate(attributeSource);
                if (value == null) {
                    throw new ExpressionEvaluationException("No value for " + this.pipeExpression);
                }
                if (value instanceof Collection) {
                    value = ((Collection)value).size() != 1 ? Placeholder.toQuotedCommaSeparatedString((Collection)value) : ((Collection)value).iterator().next().toString();
                } else if (!(value instanceof String)) {
                    value = value.toString();
                }
                return stringEscapeFunction.apply((String)value);
            }

            public String toString() {
                return this.pipeExpression.toString();
            }

            private static String toQuotedCommaSeparatedString(Collection<?> values) {
                return Joiner.on((char)',').join(Iterables.transform(values, s -> '\"' + String.valueOf(s).replaceAll("\"", "\\\"") + '\"'));
            }
        }

        static class Constant
        extends Token {
            private final String string;

            Constant(String string) {
                this.string = string;
            }

            @Override
            int estimatedLength() {
                return this.string.length();
            }

            @Override
            String render(AttributeSource attributeSource, Function<String, String> stringEscapeFunction) {
                return this.string;
            }

            public String toString() {
                return this.string;
            }
        }
    }
}

