/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Format;

public interface RedactableDocument {
    public Object toRedactedBasicObject();

    default public String toRedactedString(Format format) {
        return DocWriter.format(format).writeAsString(this.toRedactedBasicObject());
    }

    default public String toRedactedJsonString() {
        return DocWriter.json().writeAsString(this.toRedactedBasicObject());
    }

    default public String toRedactedYamlString() {
        return DocWriter.yaml().writeAsString(this.toRedactedBasicObject());
    }

    default public DocNode toRedactedDocNode() {
        Object basicObject = this.toRedactedBasicObject();
        if (basicObject != null) {
            return DocNode.wrap(basicObject);
        }
        return null;
    }
}

