/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4TcpChannel
implements TcpChannel {
    private final Channel channel;
    private final boolean isServer;
    private final String profile;
    private final ListenableFuture<Void> connectContext;
    private final ListenableFuture<Void> closeContext = new ListenableFuture();
    private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();
    private final boolean rstOnClose;
    private volatile Exception closeException = null;

    Netty4TcpChannel(Channel channel, boolean isServer, String profile, boolean rstOnClose, ChannelFuture connectFuture) {
        this.channel = channel;
        this.isServer = isServer;
        this.profile = profile;
        this.connectContext = new ListenableFuture();
        this.rstOnClose = rstOnClose;
        Netty4Utils.addListener((Future<Void>)connectFuture, this.connectContext);
        Netty4Utils.addListener((Future<Void>)this.channel.closeFuture(), new ActionListener<Void>(){

            public void onResponse(Void ignored) {
                if (Netty4TcpChannel.this.closeException != null) {
                    Netty4TcpChannel.this.closeContext.onFailure(Netty4TcpChannel.this.closeException);
                } else {
                    Netty4TcpChannel.this.closeContext.onResponse(null);
                }
            }

            public void onFailure(Exception e) {
                assert (false) : new AssertionError((Object)"netty channel closeFuture should never report a failure");
            }
        });
    }

    public void close() {
        if (this.rstOnClose) {
            this.rstAndClose();
        } else {
            this.channel.close();
        }
    }

    private void rstAndClose() {
        Releasable[] releasableArray = new Releasable[2];
        releasableArray[0] = () -> {
            block4: {
                if (this.channel.isOpen()) {
                    try {
                        this.channel.config().setOption(ChannelOption.SO_LINGER, (Object)0);
                    }
                    catch (Exception e) {
                        if (IOUtils.MAC_OS_X) {
                            return;
                        }
                        if (!this.channel.isOpen()) break block4;
                        throw e;
                    }
                }
            }
        };
        releasableArray[1] = () -> ((Channel)this.channel).close();
        Releasables.close((Releasable[])releasableArray);
    }

    public boolean isServerChannel() {
        return this.isServer;
    }

    public String getProfile() {
        return this.profile;
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(listener);
    }

    public void addConnectListener(ActionListener<Void> listener) {
        this.connectContext.addListener(listener);
    }

    public void setCloseException(Exception e) {
        this.closeException = e;
    }

    public TcpChannel.ChannelStats getChannelStats() {
        return this.stats;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        Netty4Utils.safeWriteAndFlush(this.channel, reference, listener);
    }

    public Channel getNettyChannel() {
        return this.channel;
    }

    public String toString() {
        return "Netty4TcpChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.channel.remoteAddress() + ", profile=" + this.profile + "}";
    }
}

