/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.reflection;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.elasticsearch.SpecialPermission;

public class ReflectiveAttributeAccessors {
    public static <O> Function<O, Object> objectAttr(String name) {
        return new ReflectiveAttributeGetter(name, Object.class);
    }

    public static <O, R> Function<O, R> objectAttr(String name, Class<R> type) {
        return new ReflectiveAttributeGetter(name, type);
    }

    public static <O, R> Function<O, R> protectedObjectAttr(String name, Class<R> type) {
        return new ProtectedReflectiveAttributeGetter(name, type);
    }

    public static <O, V> BiFunction<O, V, Void> setObjectAttr(String name, Class<V> type) {
        return new ReflectiveAttributeSetter(name, type);
    }

    static class ReflectiveAttributeGetter<O, R>
    implements Function<O, R> {
        private final String attribute;
        private final String methodName;
        private final Class<R> type;

        ReflectiveAttributeGetter(String attribute, Class<R> type) {
            this.attribute = attribute;
            this.methodName = "get" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
            this.type = type;
        }

        @Override
        public R apply(O object) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            return (R)AccessController.doPrivileged(() -> {
                if (object == null) {
                    return null;
                }
                try {
                    Method method = object.getClass().getMethod(this.methodName, new Class[0]);
                    Object value = method.invoke(object, new Object[0]);
                    return this.type.cast(value);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while accessing " + this.attribute + " in " + object, e);
                }
            });
        }
    }

    static class ProtectedReflectiveAttributeGetter<O, R>
    implements Function<O, R> {
        private final String attribute;
        private final String methodName;
        private final Class<R> type;

        ProtectedReflectiveAttributeGetter(String attribute, Class<R> type) {
            this.attribute = attribute;
            this.methodName = "get" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
            this.type = type;
        }

        @Override
        public R apply(O object) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            return (R)AccessController.doPrivileged(() -> {
                if (object == null) {
                    return null;
                }
                try {
                    Method method = object.getClass().getDeclaredMethod(this.methodName, new Class[0]);
                    method.setAccessible(true);
                    Object value = method.invoke(object, new Object[0]);
                    return this.type.cast(value);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while accessing " + this.attribute + " in " + object, e);
                }
            });
        }
    }

    static class ReflectiveAttributeSetter<O, R>
    implements BiFunction<O, R, Void> {
        private final String attribute;
        private final String methodName;
        private final Class<R> type;

        ReflectiveAttributeSetter(String attribute, Class<R> type) {
            this.attribute = attribute;
            this.methodName = "set" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
            this.type = type;
        }

        @Override
        public Void apply(O object, R value) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            return AccessController.doPrivileged(() -> {
                if (object == null) {
                    throw new NullPointerException("Cannot set " + this.attribute + " because object is null");
                }
                try {
                    Method method = object.getClass().getMethod(this.methodName, this.type);
                    method.invoke(object, value);
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while set " + this.attribute + " in " + object + " to " + value, e);
                }
            });
        }
    }
}

