/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsBaseContext;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfig;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsProcessedConfig;
import com.floragunn.searchguard.enterprise.dlsfls.DlsRestriction;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedDocumentAuthorization;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.floragunn.searchsupport.meta.Meta;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.search.internal.SearchContext;

public class DlsFlsSearchOperationListener
implements SearchOperationListener,
ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(DlsFlsSearchOperationListener.class);
    private final DlsFlsBaseContext dlsFlsBaseContext;
    private final AtomicReference<DlsFlsProcessedConfig> config;
    private final ComponentState componentState = new ComponentState(1, null, "search_operation_listener", DlsFlsSearchOperationListener.class).initialized();
    private final TimeAggregation onPreQueryPhaseAggregation = new TimeAggregation.Nanoseconds();

    DlsFlsSearchOperationListener(DlsFlsBaseContext dlsFlsBase, AtomicReference<DlsFlsProcessedConfig> config) {
        this.dlsFlsBaseContext = dlsFlsBase;
        this.config = config;
        this.componentState.addMetrics("filter_pre_query_phase", (Measurement)this.onPreQueryPhaseAggregation);
    }

    public void onPreQueryPhase(SearchContext searchContext) {
        DlsFlsProcessedConfig config = this.config.get();
        if (this.dlsFlsBaseContext.isInteralRequest()) {
            return;
        }
        if (config.getDlsFlsConfig().getDlsMode() == DlsFlsConfig.Mode.FILTER_LEVEL) {
            log.trace("DlsFlsSearchOperationListener.onPreQueryPhase()\nFilter Level mode active");
            return;
        }
        if (this.dlsFlsBaseContext.isDlsDoneOnFilterLevel()) {
            log.trace("DlsFlsSearchOperationListener.onPreQueryPhase()\nisDlsDoneOnFilterLevel");
            return;
        }
        if (searchContext.suggest() != null) {
            log.trace("DlsFlsSearchOperationListener.onPreQueryPhase()\nisuggest: " + searchContext.suggest());
            return;
        }
        PrivilegesEvaluationContext privilegesEvaluationContext = this.dlsFlsBaseContext.getPrivilegesEvaluationContext();
        if (privilegesEvaluationContext == null) {
            log.trace("DlsFlsSearchOperationListener.onPreQueryPhase()\nno privilegesEvaluationContext");
            return;
        }
        if (privilegesEvaluationContext.isUserAdmin()) {
            log.trace("DlsFlsSearchOperationListener.onPreQueryPhase()\nUser is admin. Giving full access");
            return;
        }
        try (Meter meter = Meter.detail((MetricsLevel)config.getMetricsLevel(), (Measurement)this.onPreQueryPhaseAggregation);){
            RoleBasedDocumentAuthorization documentAuthorization = config.getDocumentAuthorization();
            if (documentAuthorization == null) {
                throw new IllegalStateException("Authorization configuration is not yet initialized");
            }
            Meta indexMetaData = this.dlsFlsBaseContext.getIndexMetaData();
            Meta.Index index = (Meta.Index)indexMetaData.getIndexOrLike(searchContext.indexShard().indexSettings().getIndex().getName());
            if (privilegesEvaluationContext.getSpecialPrivilegesEvaluationContext() != null && privilegesEvaluationContext.getSpecialPrivilegesEvaluationContext().getRolesConfig() != null) {
                SgDynamicConfiguration roles = privilegesEvaluationContext.getSpecialPrivilegesEvaluationContext().getRolesConfig();
                documentAuthorization = new RoleBasedDocumentAuthorization((SgDynamicConfiguration<Role>)roles, null, MetricsLevel.NONE);
            }
            DlsRestriction dlsRestriction = (DlsRestriction)documentAuthorization.getRestriction(privilegesEvaluationContext, index, meter);
            log.trace("DlsRestriction for {}: {}", (Object)index, (Object)dlsRestriction);
            if (!dlsRestriction.isUnrestricted()) {
                if (config.getDlsFlsConfig().getDlsMode() == DlsFlsConfig.Mode.ADAPTIVE && dlsRestriction.containsTermLookupQuery()) {
                    log.trace("DlsRestriction: contains TLQ.");
                    return;
                }
                BooleanQuery.Builder queryBuilder = dlsRestriction.toBooleanQueryBuilder(searchContext.getSearchExecutionContext(), q -> new ConstantScoreQuery(q));
                queryBuilder.add(searchContext.parsedQuery().query(), BooleanClause.Occur.MUST);
                searchContext.parsedQuery(new ParsedQuery((Query)queryBuilder.build()));
                searchContext.preProcess();
            }
        }
        catch (Exception e) {
            this.componentState.addLastException("filter_pre_query_phase", (Throwable)e);
            throw new RuntimeException("Error evaluating dls for a search query: " + e, e);
        }
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

