/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.filter;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.DocumentWhitelist;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.enterprise.dlsfls.DlsRestriction;
import com.floragunn.searchguard.queries.QueryBuilderTraverser;
import com.floragunn.searchsupport.meta.Meta;
import com.floragunn.searchsupport.queries.Query;
import com.floragunn.searchsupport.util.LocalClusterAliasExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchShardsRequest;
import org.elasticsearch.action.search.TransportSearchScrollAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class DlsFilterLevelActionHandler {
    private static final Logger log = LogManager.getLogger(DlsFilterLevelActionHandler.class);
    private final String action;
    private final ActionRequest request;
    private final ActionListener<?> listener;
    private final DlsRestriction.IndexMap restrictionMap;
    private final ResolvedIndices resolved;
    private final boolean requiresIndexScoping;
    private final Client nodeClient;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final ThreadContext threadContext;
    private BoolQueryBuilder filterLevelQueryBuilder;
    private DocumentWhitelist documentWhitelist;

    public static SyncAuthorizationFilter.Result handle(Action action, ActionRequest request, ActionListener<?> listener, DlsRestriction.IndexMap restrictionMap, ResolvedIndices resolved, Client nodeClient, ClusterService clusterService, IndicesService indicesService, IndexNameExpressionResolver resolver, ThreadContext threadContext) {
        if (threadContext.getHeader("_sg_filter_level_dls_done") != null) {
            return SyncAuthorizationFilter.Result.OK;
        }
        String actionName = action.name();
        if (actionName.startsWith("searchguard:cluster:") || actionName.startsWith("cluster:") || actionName.startsWith("indices:admin/template/") || actionName.startsWith("indices:admin/index_template/")) {
            return SyncAuthorizationFilter.Result.OK;
        }
        if (actionName.startsWith(TransportSearchScrollAction.TYPE.name())) {
            return SyncAuthorizationFilter.Result.OK;
        }
        if (actionName.equals("indices:data/read/search/template") || actionName.equals("indices:data/read/msearch/template")) {
            return SyncAuthorizationFilter.Result.OK;
        }
        if (request instanceof MultiSearchRequest) {
            return SyncAuthorizationFilter.Result.OK;
        }
        return new DlsFilterLevelActionHandler(action.name(), request, listener, restrictionMap, resolved, nodeClient, clusterService, indicesService, resolver, threadContext).handle();
    }

    DlsFilterLevelActionHandler(String action, ActionRequest request, ActionListener<?> listener, DlsRestriction.IndexMap restrictionMap, ResolvedIndices resolved, Client nodeClient, ClusterService clusterService, IndicesService indicesService, IndexNameExpressionResolver resolver, ThreadContext threadContext) {
        this.action = action;
        this.listener = listener;
        this.request = request;
        this.restrictionMap = restrictionMap;
        this.resolved = resolved;
        this.nodeClient = nodeClient;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.threadContext = threadContext;
        this.requiresIndexScoping = resolved.isLocalAll() || resolved.getLocalAndRemoteIndices().size() != 1;
    }

    private SyncAuthorizationFilter.Result handle() {
        try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext();){
            block23: {
                this.threadContext.putHeader("_sg_filter_level_dls_done", this.request.toString());
                try {
                    if (this.createQueryExtension()) break block23;
                    SyncAuthorizationFilter.Result result = SyncAuthorizationFilter.Result.OK;
                    return result;
                }
                catch (Exception e) {
                    log.error("Unable to handle filter level DLS", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Created filterLevelQuery for " + this.request + ":\n" + this.filterLevelQueryBuilder);
            }
            if (this.filterLevelQueryBuilder == null) {
                SyncAuthorizationFilter.Result result = SyncAuthorizationFilter.Result.OK;
                return result;
            }
            if (this.request instanceof SearchRequest) {
                SyncAuthorizationFilter.Result result = this.handle((SearchRequest)this.request, ctx);
                return result;
            }
            if (this.request instanceof GetRequest) {
                SyncAuthorizationFilter.Result result = this.handle((GetRequest)this.request, ctx);
                return result;
            }
            if (this.request instanceof MultiGetRequest) {
                SyncAuthorizationFilter.Result result = this.handle((MultiGetRequest)this.request, ctx);
                return result;
            }
            if (this.request instanceof ClusterSearchShardsRequest) {
                SyncAuthorizationFilter.Result result = this.handle((ClusterSearchShardsRequest)this.request, ctx);
                return result;
            }
            if (this.request instanceof SearchShardsRequest) {
                SyncAuthorizationFilter.Result result = this.handle((SearchShardsRequest)this.request, ctx);
                return result;
            }
            log.error("Unsupported request type for filter level DLS: " + this.request);
            throw new RuntimeException("Unsupported request type for filter level DLS: " + this.action + "; " + this.request.getClass().getName());
        }
    }

    private SyncAuthorizationFilter.Result handle(SearchRequest searchRequest, final ThreadContext.StoredContext ctx) {
        String localClusterAlias;
        if (this.documentWhitelist != null) {
            this.documentWhitelist.applyTo(this.threadContext);
        }
        if ((localClusterAlias = LocalClusterAliasExtractor.getLocalClusterAliasFromSearchRequest((SearchRequest)searchRequest)) != null) {
            try {
                this.createQueryExtension(localClusterAlias);
            }
            catch (Exception e) {
                log.error("Unable to handle filter level DLS", (Throwable)e);
                throw new ElasticsearchSecurityException("Unable to handle filter level DLS", e, new Object[0]);
            }
        }
        if (searchRequest.source().query() != null) {
            this.filterLevelQueryBuilder.must(searchRequest.source().query());
        }
        searchRequest.source().query((QueryBuilder)this.filterLevelQueryBuilder);
        if (log.isTraceEnabled()) {
            log.trace("Executing search request {}", (Object)searchRequest);
        }
        this.nodeClient.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                try {
                    ctx.restore();
                    ActionListener<?> searchListener = DlsFilterLevelActionHandler.this.listener;
                    searchListener.onResponse((Object)response);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void onFailure(Exception e) {
                log.error("DLS filter level failure", (Throwable)e);
                DlsFilterLevelActionHandler.this.listener.onFailure(e);
            }
        });
        return SyncAuthorizationFilter.Result.INTERCEPTED;
    }

    private SyncAuthorizationFilter.Result handle(final GetRequest getRequest, final ThreadContext.StoredContext ctx) {
        if (this.documentWhitelist != null) {
            this.documentWhitelist.applyTo(this.threadContext);
        }
        final SearchRequest searchRequest = new SearchRequest(getRequest.indices());
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{getRequest.id()})).must((QueryBuilder)this.filterLevelQueryBuilder);
        searchRequest.source(SearchSourceBuilder.searchSource().query((QueryBuilder)query));
        this.nodeClient.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                try {
                    ctx.restore();
                    long hits = response.getHits().getTotalHits().value;
                    ActionListener<?> getListener = DlsFilterLevelActionHandler.this.listener;
                    if (hits == 1L) {
                        getListener.onResponse((Object)new GetResponse(DlsFilterLevelActionHandler.this.searchHitToGetResult(response.getHits().getAt(0))));
                    } else if (hits == 0L) {
                        getListener.onResponse((Object)new GetResponse(new GetResult(searchRequest.indices()[0], getRequest.id(), -2L, 0L, -1L, false, null, null, null)));
                    } else {
                        log.error("Unexpected hit count " + hits + " in " + response);
                        DlsFilterLevelActionHandler.this.listener.onFailure((Exception)new ElasticsearchSecurityException("Internal error when performing DLS", new Object[0]));
                    }
                }
                catch (Exception e) {
                    DlsFilterLevelActionHandler.this.listener.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                DlsFilterLevelActionHandler.this.listener.onFailure(e);
            }
        });
        return SyncAuthorizationFilter.Result.INTERCEPTED;
    }

    private SyncAuthorizationFilter.Result handle(MultiGetRequest multiGetRequest, final ThreadContext.StoredContext ctx) {
        BoolQueryBuilder query;
        if (this.documentWhitelist != null) {
            this.documentWhitelist.applyTo(this.threadContext);
        }
        Map idsGroupedByIndex = multiGetRequest.getItems().stream().collect(Collectors.groupingBy(item -> item.index(), Collectors.mapping(item -> item.id(), Collectors.toSet())));
        Set<String> indices = idsGroupedByIndex.keySet();
        SearchRequest searchRequest = new SearchRequest(indices.toArray(new String[indices.size()]));
        if (indices.size() == 1) {
            Set<String> ids = idsGroupedByIndex.get(indices.iterator().next());
            query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.idsQuery().addIds(ids.toArray(new String[ids.size()]))).must((QueryBuilder)this.filterLevelQueryBuilder);
        } else {
            BoolQueryBuilder mgetQuery = QueryBuilders.boolQuery().minimumShouldMatch(1);
            for (Map.Entry entry : idsGroupedByIndex.entrySet()) {
                BoolQueryBuilder indexQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"_index", (String)entry.getKey())).must((QueryBuilder)QueryBuilders.idsQuery().addIds(entry.getValue().toArray(new String[entry.getValue().size()])));
                mgetQuery.should((QueryBuilder)indexQuery);
            }
            query = QueryBuilders.boolQuery().must((QueryBuilder)mgetQuery).must((QueryBuilder)this.filterLevelQueryBuilder);
        }
        searchRequest.source(SearchSourceBuilder.searchSource().query((QueryBuilder)query));
        this.nodeClient.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                try {
                    ctx.restore();
                    ArrayList<MultiGetItemResponse> itemResponses = new ArrayList<MultiGetItemResponse>(response.getHits().getHits().length);
                    for (SearchHit hit : response.getHits().getHits()) {
                        itemResponses.add(new MultiGetItemResponse(new GetResponse(DlsFilterLevelActionHandler.this.searchHitToGetResult(hit)), null));
                    }
                    ActionListener<?> multiGetListener = DlsFilterLevelActionHandler.this.listener;
                    multiGetListener.onResponse((Object)new MultiGetResponse(itemResponses.toArray(new MultiGetItemResponse[itemResponses.size()])));
                }
                catch (Exception e) {
                    DlsFilterLevelActionHandler.this.listener.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                DlsFilterLevelActionHandler.this.listener.onFailure(e);
            }
        });
        return SyncAuthorizationFilter.Result.INTERCEPTED;
    }

    private SyncAuthorizationFilter.Result handle(ClusterSearchShardsRequest request, ThreadContext.StoredContext ctx) {
        this.listener.onFailure((Exception)new ElasticsearchSecurityException("Filter-level DLS via cross cluster search is not available for scrolling and minimize_roundtrips=true", new Object[0]));
        return SyncAuthorizationFilter.Result.INTERCEPTED;
    }

    private SyncAuthorizationFilter.Result handle(SearchShardsRequest request, ThreadContext.StoredContext ctx) {
        this.listener.onFailure((Exception)new ElasticsearchSecurityException("Filter-level DLS via cross cluster search is not available for scrolling and minimize_roundtrips=true", new Object[0]));
        return SyncAuthorizationFilter.Result.INTERCEPTED;
    }

    private GetResult searchHitToGetResult(SearchHit hit) {
        Map<String, DocumentField> metadataFields;
        HashMap<String, DocumentField> documentFields;
        HashMap<String, DocumentField> fields;
        if (log.isDebugEnabled()) {
            log.debug("Converting to GetResult:\n" + hit);
        }
        if ((fields = hit.getFields()).isEmpty()) {
            documentFields = Collections.emptyMap();
            metadataFields = Collections.emptyMap();
        } else {
            IndexService indexService;
            IndexMetadata indexMetadata = (IndexMetadata)this.clusterService.state().getMetadata().indices().get(hit.getIndex());
            IndexService indexService2 = indexService = indexMetadata != null ? this.indicesService.indexService(indexMetadata.getIndex()) : null;
            if (indexService != null) {
                documentFields = new HashMap<String, DocumentField>(fields.size());
                metadataFields = new HashMap();
                MapperService mapperService = indexService.mapperService();
                for (Map.Entry entry : fields.entrySet()) {
                    if (mapperService.isMetadataField((String)entry.getKey())) {
                        metadataFields.put((String)entry.getKey(), (DocumentField)entry.getValue());
                        continue;
                    }
                    documentFields.put((String)entry.getKey(), (DocumentField)entry.getValue());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Partitioned fields: " + metadataFields + "; " + documentFields);
                }
            } else {
                if (log.isWarnEnabled()) {
                    log.warn("Could not find IndexService for " + hit.getIndex() + "; assuming all fields as document fields.This should not happen, however this should also not pose a big problem as ES mixes the fields again anyway.\nIndexMetadata: " + indexMetadata);
                }
                documentFields = fields;
                metadataFields = Collections.emptyMap();
            }
        }
        return new GetResult(hit.getIndex(), hit.getId(), hit.getSeqNo(), hit.getPrimaryTerm(), hit.getVersion(), true, hit.getSourceRef(), documentFields, metadataFields);
    }

    private boolean createQueryExtension() throws IOException {
        return this.createQueryExtension(null);
    }

    private boolean createQueryExtension(String localClusterAlias) throws IOException {
        Object prefixedIndex;
        BoolQueryBuilder dlsQueryBuilder = QueryBuilders.boolQuery().minimumShouldMatch(1);
        DocumentWhitelist.Builder documentWhitelist = new DocumentWhitelist.Builder();
        int queryCount = 0;
        for (Meta.IndexLikeObject index : Meta.IndexLikeObject.resolveDeep((ImmutableSet)this.resolved.getLocal().getUnion())) {
            prefixedIndex = localClusterAlias != null ? localClusterAlias + ":" + index.name() : index.name();
            DlsRestriction dlsRestriction = (DlsRestriction)this.restrictionMap.getIndexMap().get((Object)index);
            if (dlsRestriction == null || dlsRestriction.isUnrestricted()) {
                if (!this.requiresIndexScoping) continue;
                dlsQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"_index", (String)prefixedIndex));
                continue;
            }
            for (Query dlsQuery : dlsRestriction.getQueries()) {
                ++queryCount;
                QueryBuilder parsedDlsQuery = dlsQuery.getQueryBuilder();
                if (!this.requiresIndexScoping) {
                    dlsQueryBuilder.should(parsedDlsQuery);
                } else {
                    dlsQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"_index", (String)prefixedIndex)).must(parsedDlsQuery));
                }
                Set queryBuilders = QueryBuilderTraverser.findAll((QueryBuilder)parsedDlsQuery, q -> q instanceof TermsQueryBuilder && ((TermsQueryBuilder)q).termsLookup() != null);
                for (QueryBuilder queryBuilder : queryBuilders) {
                    TermsQueryBuilder termsQueryBuilder = (TermsQueryBuilder)queryBuilder;
                    documentWhitelist.add(termsQueryBuilder.termsLookup().index(), termsQueryBuilder.termsLookup().id());
                }
            }
        }
        if (this.requiresIndexScoping) {
            for (String remoteIndex : this.resolved.getRemoteIndices()) {
                prefixedIndex = localClusterAlias != null ? localClusterAlias + ":" + remoteIndex : remoteIndex;
                dlsQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"_index", (String)prefixedIndex));
            }
        }
        if (queryCount == 0) {
            return false;
        }
        this.filterLevelQueryBuilder = dlsQueryBuilder;
        this.documentWhitelist = documentWhitelist.build();
        return true;
    }
}

