/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigMap
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger(ConfigMap.class);
    private final ImmutableMap<CType<?>, SgDynamicConfiguration<?>> map;
    private final String sourceIndex;

    private ConfigMap(ImmutableMap<CType<?>, SgDynamicConfiguration<?>> map, String sourceIndex) {
        this.map = map;
        this.sourceIndex = sourceIndex;
    }

    public <T> SgDynamicConfiguration<T> get(CType<T> ctype) {
        SgDynamicConfiguration config = (SgDynamicConfiguration)this.map.get(ctype);
        if (config == null) {
            return null;
        }
        if (!config.getCType().equals(ctype)) {
            throw new RuntimeException("Stored configuration does not match type: " + ctype + "; " + config);
        }
        return config;
    }

    public Collection<SgDynamicConfiguration<?>> getAll() {
        return this.map.values();
    }

    public boolean containsAll(Set<CType<?>> types) {
        return this.map.keySet().containsAll(types);
    }

    public ConfigMap with(ConfigMap newConfigs) {
        return new ConfigMap(this.map.with(newConfigs.map), (String)(Objects.equals(this.sourceIndex, newConfigs.sourceIndex) ? this.sourceIndex : this.sourceIndex + "," + newConfigs.sourceIndex));
    }

    public ConfigMap only(Set<CType<?>> types) {
        return new ConfigMap(this.map.matching(k -> types.contains(k)), this.sourceIndex);
    }

    public String getVersionsAsString() {
        return ImmutableMap.map(this.map, k -> k, v -> v.getDocVersion()).toString();
    }

    public ImmutableSet<CType<?>> getTypes() {
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void close() {
        for (SgDynamicConfiguration config : this.map.values()) {
            try {
                config.close();
            }
            catch (Exception e) {
                log.error("Error closing {}", (Object)config, (Object)e);
            }
        }
    }

    public String toString() {
        return this.map.values().toString();
    }

    public String getSourceIndex() {
        return this.sourceIndex;
    }

    public static class Builder {
        private ImmutableMap.Builder<CType<?>, SgDynamicConfiguration<?>> map = new ImmutableMap.Builder();
        private String sourceIndex;

        public Builder(String sourceIndex) {
            this.sourceIndex = sourceIndex;
        }

        public <T> Builder with(SgDynamicConfiguration<T> config) {
            this.map.put(config.getCType(), config);
            return this;
        }

        public ConfigMap build() {
            return new ConfigMap(this.map.build(), this.sourceIndex);
        }
    }
}

