/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.rest;

import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.util.SSLRequestHelper;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentBuilder;

public class SearchGuardWhoAmIAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final AdminDNs adminDns;
    private final Settings settings;
    private final Path configPath;
    private final PrincipalExtractor principalExtractor;
    private final List<String> nodesDn;

    public SearchGuardWhoAmIAction(Settings settings, AdminDNs adminDns, Path configPath, PrincipalExtractor principalExtractor) {
        this.adminDns = adminDns;
        this.settings = settings;
        this.configPath = configPath;
        this.principalExtractor = principalExtractor;
        this.nodesDn = settings.getAsList("searchguard.nodes_dn", Collections.emptyList());
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/whoami"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return channel -> {
            RestResponse response = null;
            try (XContentBuilder builder = channel.newBuilder();){
                SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo((Settings)this.settings, (Path)this.configPath, (RestRequest)request, (PrincipalExtractor)this.principalExtractor);
                if (sslInfo == null) {
                    response = new RestResponse(RestStatus.FORBIDDEN, "");
                } else {
                    String dn = sslInfo.getPrincipal();
                    boolean isAdmin = this.adminDns.isAdminDN(dn);
                    boolean isNodeCertificateRequest = WildcardMatcher.matchAny(this.nodesDn, new String[]{dn}, true);
                    builder.startObject();
                    builder.field("dn", dn);
                    builder.field("is_admin", isAdmin);
                    builder.field("is_node_certificate_request", isNodeCertificateRequest);
                    builder.endObject();
                    response = new RestResponse(RestStatus.OK, builder);
                }
            }
            channel.sendResponse(response);
        };
    }

    public String getName() {
        return "Search Guard Who am i";
    }
}

