/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy.auth;

import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.legacy.LegacyHTTPAuthenticator;
import com.floragunn.searchguard.legacy.LegacyComponentFactory;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.cstate.ComponentState;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;

public class HTTPClientCertAuthenticator
implements LegacyHTTPAuthenticator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final Settings settings;
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "clientcert", HTTPClientCertAuthenticator.class).initialized();
    public static TypedComponent.Info<LegacyHTTPAuthenticator> INFO = new TypedComponent.Info<LegacyHTTPAuthenticator>(){

        public Class<LegacyHTTPAuthenticator> getType() {
            return LegacyHTTPAuthenticator.class;
        }

        public String getName() {
            return "clientcert";
        }

        public TypedComponent.Factory<LegacyHTTPAuthenticator> getFactory() {
            return LegacyComponentFactory.adapt(HTTPClientCertAuthenticator::new);
        }
    };

    public HTTPClientCertAuthenticator(Settings settings, Path configPath) {
        this.settings = settings;
    }

    public AuthCredentials extractCredentials(RestRequest request, ThreadContext threadContext) {
        String principal = (String)threadContext.getTransient("_sg_ssl_principal");
        if (!Strings.isNullOrEmpty((String)principal)) {
            String usernameAttribute = this.settings.get("username_attribute");
            String rolesAttribute = this.settings.get("roles_attribute");
            try {
                List<String> roles;
                List<String> usernames;
                LdapName rfc2253dn = new LdapName(principal);
                String username = principal.trim();
                String[] backendRoles = null;
                if (usernameAttribute != null && usernameAttribute.length() > 0 && !(usernames = this.getDnAttribute(rfc2253dn, usernameAttribute)).isEmpty()) {
                    username = usernames.get(0);
                }
                if (rolesAttribute != null && rolesAttribute.length() > 0 && !(roles = this.getDnAttribute(rfc2253dn, rolesAttribute)).isEmpty()) {
                    backendRoles = roles.toArray(new String[0]);
                }
                return AuthCredentials.forUser((String)username).backendRoles(backendRoles).authenticatorType(this.getType()).complete().build();
            }
            catch (InvalidNameException e) {
                this.log.error("Client cert had no properly formed DN (was: {})", (Object)principal);
                return null;
            }
        }
        this.log.trace("No CLIENT CERT, send 401");
        return null;
    }

    public String getType() {
        return "clientcert";
    }

    private List<String> getDnAttribute(LdapName rfc2253dn, String attribute) {
        ArrayList<String> attrValues = new ArrayList<String>(rfc2253dn.size());
        ArrayList<Rdn> reverseRdn = new ArrayList<Rdn>(rfc2253dn.getRdns());
        Collections.reverse(reverseRdn);
        for (Rdn rdn : reverseRdn) {
            if (!rdn.getType().equalsIgnoreCase(attribute)) continue;
            attrValues.add(rdn.getValue().toString());
        }
        return Collections.unmodifiableList(attrValues);
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

