/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.PublicKeyJwsSignatureVerifier;

public class EcDsaJwsSignatureVerifier
extends PublicKeyJwsSignatureVerifier {
    static final Map<String, Integer> SIGNATURE_LENGTH_MAP = new HashMap<String, Integer>();

    public EcDsaJwsSignatureVerifier(PublicKey key, SignatureAlgorithm supportedAlgo) {
        this(key, null, supportedAlgo);
    }

    public EcDsaJwsSignatureVerifier(PublicKey key, AlgorithmParameterSpec spec, SignatureAlgorithm supportedAlgo) {
        super(key, spec, supportedAlgo);
    }

    public EcDsaJwsSignatureVerifier(X509Certificate cert, SignatureAlgorithm supportedAlgo) {
        this(cert, null, supportedAlgo);
    }

    public EcDsaJwsSignatureVerifier(X509Certificate cert, AlgorithmParameterSpec spec, SignatureAlgorithm supportedAlgo) {
        super(cert, spec, supportedAlgo);
    }

    @Override
    public boolean verify(JwsHeaders headers, String unsignedText, byte[] signature) {
        String algoName = super.getAlgorithm().getJwaName();
        if (SIGNATURE_LENGTH_MAP.get(algoName) != signature.length) {
            LOG.warning("Algorithm " + algoName + " signature length is " + SIGNATURE_LENGTH_MAP.get(algoName) + ", actual length is " + signature.length);
            throw new JwsException(JwsException.Error.INVALID_SIGNATURE);
        }
        byte[] der = EcDsaJwsSignatureVerifier.signatureToDer(signature);
        return super.verify(headers, unsignedText, der);
    }

    @Override
    protected boolean isValidAlgorithmFamily(String algo) {
        return AlgorithmUtils.isEcDsaSign(algo);
    }

    private static byte[] signatureToDer(byte[] joseSig) {
        int offset;
        byte[] derEncodedSignatureBytes;
        int len;
        int k;
        int rawLen;
        int i;
        for (i = rawLen = joseSig.length / 2; i > 0 && joseSig[rawLen - i] == 0; --i) {
        }
        int j = i;
        if (joseSig[rawLen - i] < 0) {
            ++j;
        }
        for (k = rawLen; k > 0 && joseSig[2 * rawLen - k] == 0; --k) {
        }
        int l = k;
        if (joseSig[2 * rawLen - k] < 0) {
            ++l;
        }
        if ((len = 2 + j + 2 + l) > 255) {
            throw new JoseException("Invalid format of ECDSA signature");
        }
        if (len < 128) {
            derEncodedSignatureBytes = new byte[4 + j + 2 + l];
            offset = 1;
        } else {
            derEncodedSignatureBytes = new byte[5 + j + 2 + l];
            derEncodedSignatureBytes[1] = -127;
            offset = 2;
        }
        derEncodedSignatureBytes[0] = 48;
        derEncodedSignatureBytes[offset++] = (byte)len;
        derEncodedSignatureBytes[offset++] = 2;
        derEncodedSignatureBytes[offset++] = (byte)j;
        System.arraycopy(joseSig, rawLen - i, derEncodedSignatureBytes, offset + j - i, i);
        offset += j;
        derEncodedSignatureBytes[offset++] = 2;
        derEncodedSignatureBytes[offset++] = (byte)l;
        System.arraycopy(joseSig, 2 * rawLen - k, derEncodedSignatureBytes, offset + l - k, k);
        return derEncodedSignatureBytes;
    }

    static {
        SIGNATURE_LENGTH_MAP.put(SignatureAlgorithm.ES256.getJwaName(), 64);
        SIGNATURE_LENGTH_MAP.put(SignatureAlgorithm.ES384.getJwaName(), 96);
        SIGNATURE_LENGTH_MAP.put(SignatureAlgorithm.ES512.getJwaName(), 132);
    }
}

