/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.transport;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SslExceptionHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.SharedGroupFactory;

public class SearchGuardSSLNettyTransport
extends Netty4Transport {
    private static final Logger logger = LogManager.getLogger(SearchGuardSSLNettyTransport.class);
    private final SearchGuardKeyStore sgks;
    private final SslExceptionHandler errorHandler;

    public SearchGuardSSLNettyTransport(Settings settings, TransportVersion transportVersion, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, SharedGroupFactory sharedGroupFactory, SearchGuardKeyStore sgks, SslExceptionHandler errorHandler) {
        super(settings, transportVersion, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, sharedGroupFactory);
        this.sgks = sgks;
        this.errorHandler = errorHandler;
    }

    public void onException(TcpChannel channel, Exception e) {
        Throwable cause = e;
        if (e instanceof DecoderException && e != null) {
            cause = e.getCause();
        }
        this.errorHandler.logError(cause, false);
        logger.error("Exception during establishing a SSL connection: " + cause, cause);
        super.onException(channel, e);
    }

    protected ChannelHandler getServerChannelInitializer(String name) {
        return new SSLServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node, ConnectionProfile connectionProfile) {
        return new SSLClientChannelInitializer(node);
    }

    protected class SSLServerChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        public SSLServerChannelInitializer(String name) {
            super((Netty4Transport)SearchGuardSSLNettyTransport.this, name);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SslHandler sslHandler = new SslHandler(SearchGuardSSLNettyTransport.this.sgks.createServerTransportSSLEngine());
            ch.pipeline().addFirst("ssl_server", (ChannelHandler)sslHandler);
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            SearchGuardSSLNettyTransport.this.errorHandler.logError(cause, false);
            logger.error("Exception during establishing a SSL connection: " + cause, cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected class SSLClientChannelInitializer
    extends Netty4Transport.ClientChannelInitializer {
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;

        public SSLClientChannelInitializer(DiscoveryNode node) {
            super((Netty4Transport)SearchGuardSSLNettyTransport.this);
            this.hostnameVerificationEnabled = SearchGuardSSLNettyTransport.this.settings.getAsBoolean("searchguard.ssl.transport.enforce_hostname_verification", Boolean.valueOf(true));
            this.hostnameVerificationResovleHostName = SearchGuardSSLNettyTransport.this.settings.getAsBoolean("searchguard.ssl.transport.resolve_hostname", Boolean.valueOf(true));
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            ch.pipeline().addFirst("client_ssl_handler", (ChannelHandler)new ClientSSLHandler(SearchGuardSSLNettyTransport.this.sgks, this.hostnameVerificationEnabled, this.hostnameVerificationResovleHostName, SearchGuardSSLNettyTransport.this.errorHandler));
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            SearchGuardSSLNettyTransport.this.errorHandler.logError(cause, false);
            logger.error("Exception during establishing a SSL connection: " + cause, cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected static class ClientSSLHandler
    extends ChannelOutboundHandlerAdapter {
        private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
        private final SearchGuardKeyStore sgks;
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;
        private final SslExceptionHandler errorHandler;

        private ClientSSLHandler(SearchGuardKeyStore sgks, boolean hostnameVerificationEnabled, boolean hostnameVerificationResovleHostName, SslExceptionHandler errorHandler) {
            this.sgks = sgks;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.hostnameVerificationResovleHostName = hostnameVerificationResovleHostName;
            this.errorHandler = errorHandler;
        }

        @Deprecated
        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            this.errorHandler.logError(cause, false);
            logger.error("Exception during establishing a SSL connection: " + cause, cause);
            super.exceptionCaught(ctx, cause);
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            SSLEngine engine = null;
            try {
                if (this.hostnameVerificationEnabled) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                    String hostname = null;
                    hostname = this.hostnameVerificationResovleHostName ? inetSocketAddress.getHostName() : inetSocketAddress.getHostString();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Hostname of peer is {} ({}/{}) with hostnameVerificationResovleHostName: {}", (Object)hostname, (Object)inetSocketAddress.getHostName(), (Object)inetSocketAddress.getHostString(), (Object)this.hostnameVerificationResovleHostName);
                    }
                    engine = this.sgks.createClientTransportSSLEngine(hostname, inetSocketAddress.getPort());
                } else {
                    engine = this.sgks.createClientTransportSSLEngine(null, -1);
                }
            }
            catch (SSLException e) {
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
            SslHandler sslHandler = new SslHandler(engine);
            ctx.pipeline().replace((ChannelHandler)this, "ssl_client", (ChannelHandler)sslHandler);
            super.connect(ctx, remoteAddress, localAddress, promise);
        }
    }
}

