/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class DeleteWatchResponse
extends ActionResponse
implements ToXContentObject {
    private String id;
    private long version;
    private DocWriteResponse.Result result;
    private RestStatus restStatus;
    private String message;

    public DeleteWatchResponse() {
    }

    public DeleteWatchResponse(String id, long version, DocWriteResponse.Result result, RestStatus restStatus, String message) {
        this.id = id;
        this.version = version;
        this.result = result;
        this.restStatus = restStatus;
        this.message = message;
    }

    public DeleteWatchResponse(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.version = in.readVLong();
        this.result = (DocWriteResponse.Result)in.readEnum(DocWriteResponse.Result.class);
        this.restStatus = (RestStatus)in.readEnum(RestStatus.class);
        this.message = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeVLong(this.version);
        out.writeEnum((Enum)this.result);
        out.writeEnum((Enum)this.restStatus);
        out.writeOptionalString(this.message);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("_id", this.id);
        builder.field("_version", this.version);
        builder.field("result", this.result.getLowercase());
        if (this.message != null) {
            builder.field("message", this.message);
        }
        builder.endObject();
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public DocWriteResponse.Result getResult() {
        return this.result;
    }

    public void setResult(DocWriteResponse.Result result) {
        this.result = result;
    }

    public RestStatus getRestStatus() {
        return this.restStatus;
    }

    public void setRestStatus(RestStatus restStatus) {
        this.restStatus = restStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

