/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.put;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.diag.DiagnosticContext;
import com.floragunn.signals.NoSuchTenantException;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsTenant;
import com.floragunn.signals.SignalsUnavailableException;
import com.floragunn.signals.actions.watch.put.PutWatchRequest;
import com.floragunn.signals.actions.watch.put.PutWatchResponse;
import com.floragunn.signals.watch.common.ValidationLevel;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutWatchAction
extends HandledTransportAction<PutWatchRequest, PutWatchResponse> {
    private static final Logger log = LogManager.getLogger(TransportPutWatchAction.class);
    private final Signals signals;
    private final ThreadPool threadPool;

    @Inject
    public TransportPutWatchAction(Signals signals, TransportService transportService, ScriptService scriptService, ThreadPool threadPool, ActionFilters actionFilters) {
        super("cluster:admin:searchguard:tenant:signals:watch/put", transportService, actionFilters, PutWatchRequest::new, (Executor)threadPool.executor("generic"));
        this.signals = signals;
        this.threadPool = threadPool;
    }

    protected final void doExecute(Task task, PutWatchRequest request, ActionListener<PutWatchResponse> listener) {
        try {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            if (user == null) {
                throw new Exception("Request did not contain user");
            }
            SignalsTenant signalsTenant = this.signals.getTenant(user);
            this.threadPool.generic().submit(this.threadPool.getThreadContext().preserveContext(() -> {
                try {
                    DiagnosticContext.fixupLoggingContext((ThreadContext)threadContext);
                    DocWriteResponse response = signalsTenant.addWatch(request.getWatchId(), request.getBody().utf8ToString(), user, ValidationLevel.STRICT);
                    listener.onResponse((Object)new PutWatchResponse(request.getWatchId(), response.getVersion(), response.getResult(), response.status(), null, null));
                }
                catch (ConfigValidationException e) {
                    log.info("Invalid watch supplied to PUT " + request.getWatchId() + ":\n" + e.toString(), (Throwable)e);
                    listener.onResponse((Object)new PutWatchResponse(request.getWatchId(), -1L, DocWriteResponse.Result.NOOP, RestStatus.BAD_REQUEST, "Watch is invalid: " + e.getMessage(), e.getValidationErrors().toJsonString()));
                }
                catch (Exception e) {
                    log.error("Error while saving watch: ", (Throwable)e);
                    listener.onFailure(e);
                }
            }));
        }
        catch (NoSuchTenantException e) {
            listener.onResponse((Object)new PutWatchResponse(request.getWatchId(), -1L, DocWriteResponse.Result.NOT_FOUND, RestStatus.NOT_FOUND, e.getMessage(), null));
        }
        catch (SignalsUnavailableException e) {
            listener.onFailure((Exception)((Object)e.toElasticsearchException()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

