/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.service;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.signals.truststore.rest.CertificateRepresentation;
import com.floragunn.signals.truststore.rest.TruststoreRepresentation;
import com.floragunn.signals.truststore.service.persistence.CertificateData;
import com.floragunn.signals.truststore.service.persistence.TruststoreData;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

class ConversionService {
    ConversionService() {
    }

    TruststoreData representationToTruststoreData(TruststoreRepresentation representation) {
        List certificates = representation.getCertificates().stream().map(this::toCertificateData).collect(Collectors.toList());
        return new TruststoreData(representation.getId(), representation.getName(), Instant.now(), representation.getPem(), (ImmutableList<CertificateData>)ImmutableList.of(certificates));
    }

    TruststoreRepresentation truststoreDataToRepresentation(TruststoreData truststoreData) {
        List certificates = truststoreData.getCertificates().stream().map(this::toCertificateRepresentation).collect(Collectors.toList());
        return new TruststoreRepresentation(truststoreData.getId(), truststoreData.getName(), truststoreData.getPem(), (ImmutableList<CertificateRepresentation>)ImmutableList.of(certificates));
    }

    private CertificateRepresentation toCertificateRepresentation(CertificateData certificateData) {
        return new CertificateRepresentation(certificateData.getSerialNumber(), certificateData.getNotBefore(), certificateData.getNotAfter(), certificateData.getIssuer(), certificateData.getSubject(), certificateData.getPem());
    }

    private CertificateData toCertificateData(CertificateRepresentation representation) {
        return new CertificateData(representation.getSerialNumber(), representation.getNotBefore(), representation.getNotAfter(), representation.getIssuer(), representation.getSubject(), representation.getPem());
    }
}

