/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.NoSuchComponentException;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TypedComponentRegistry {
    private static final Logger log = LogManager.getLogger(TypedComponentRegistry.class);
    private Map<Class<Object>, Map<String, TypedComponent.Info<Object>>> content = new HashMap<Class<Object>, Map<String, TypedComponent.Info<Object>>>();

    public <ComponentType> ComponentType create(Class<ComponentType> componentType, String name, DocNode config, ConfigurationRepository.Context context) throws NoSuchComponentException, ConfigValidationException {
        Map<String, TypedComponent.Info<Object>> nameToFactoryMap = this.content.get(componentType);
        if (nameToFactoryMap == null) {
            throw new NoSuchComponentException(componentType + "/" + name);
        }
        TypedComponent.Info<Object> info = nameToFactoryMap.get(name);
        if (info != null) {
            return componentType.cast(info.getFactory().create(config, context));
        }
        if (name.contains(".")) {
            try {
                return componentType.cast(Class.forName(name).getConstructor(DocNode.class, ConfigurationRepository.Context.class).newInstance(config, context));
            }
            catch (ClassNotFoundException e) {
                log.debug("Component class was not found: " + name, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof ConfigValidationException) {
                    throw (ConfigValidationException)e.getCause();
                }
                throw new ConfigValidationException(new ValidationError(null, "Could not create component " + name + " due to " + e.getCause().getMessage()).cause(e.getCause()));
            }
            catch (NoSuchMethodException e) {
                throw new ConfigValidationException(new ValidationError(null, "The component type " + name + " does not define a suitable constructor").cause((Throwable)e));
            }
            catch (ClassCastException e) {
                throw new ConfigValidationException(new ValidationError(null, "The component type " + name + " does not implement " + componentType).cause((Throwable)e));
            }
            catch (Exception e) {
                throw new ConfigValidationException(new ValidationError(null, "Could not create component " + name + " due to " + e.getMessage()).cause((Throwable)e));
            }
        }
        throw new NoSuchComponentException(name, nameToFactoryMap.keySet());
    }

    public <ComponentType> String getAvailableSubTypesAsShortString(Class<ComponentType> componentType) {
        Map<String, TypedComponent.Info<Object>> nameToFactoryMap = this.content.get(componentType);
        if (nameToFactoryMap == null) {
            return "n/a";
        }
        return nameToFactoryMap.keySet().stream().collect(Collectors.joining("|"));
    }

    void register(TypedComponent.Info<?> componentInfo) {
        Map<String, TypedComponent.Info<Object>> nameToFactoryMap = this.content.get(componentInfo.getType());
        if (nameToFactoryMap == null) {
            nameToFactoryMap = new LinkedHashMap<String, TypedComponent.Info<Object>>();
            this.content.put(componentInfo.getType(), nameToFactoryMap);
        }
        nameToFactoryMap.put(componentInfo.getName(), componentInfo);
    }

    void register(List<TypedComponent.Info<?>> componentInfos) {
        for (TypedComponent.Info<?> info : componentInfos) {
            this.register(info);
        }
    }

    <C> void registerInstance(Class<C> type, String subType, C instance) {
        this.register(type, subType, (config, context) -> instance);
    }

    <C> void register(final Class<C> type, final String subType, final TypedComponent.Factory<C> factory) {
        this.register(new TypedComponent.Info<C>(){

            @Override
            public Class<C> getType() {
                return type;
            }

            @Override
            public String getName() {
                return subType;
            }

            @Override
            public TypedComponent.Factory<C> getFactory() {
                return factory;
            }
        });
    }
}

