/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import java.util.Objects;

class DeleteTempIndexStep
implements MigrationStep {
    private final StepRepository repository;

    public DeleteTempIndexStep(StepRepository repository) {
        this.repository = Objects.requireNonNull(repository, "Step repository is required");
    }

    @Override
    public StepResult execute(DataMigrationContext context) throws StepException {
        String tempIndexName = context.getTempIndexName();
        this.repository.deleteIndices(tempIndexName);
        return new StepResult(StepExecutionStatus.OK, "Temp index deleted", "Index '" + tempIndexName + "' deleted");
    }

    @Override
    public String name() {
        return "delete temp index";
    }
}

