/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken.api;

import com.floragunn.searchguard.authtoken.api.SearchAuthTokensAction;
import com.floragunn.searchguard.authtoken.api.SearchAuthTokensRequest;
import com.floragunn.searchguard.authtoken.api.SearchAuthTokensResponse;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class SearchAuthTokenRestAction
extends BaseRestHandler {
    private final Predicate<NodeFeature> clusterSupportsFeature;

    public SearchAuthTokenRestAction(Predicate<NodeFeature> clusterSupportsFeature) {
        this.clusterSupportsFeature = clusterSupportsFeature;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/authtoken/_search"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/_searchguard/authtoken/_search"));
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String scroll = request.param("scroll");
        int from = request.paramAsInt("from", -1);
        int size = request.paramAsInt("size", -1);
        SearchAuthTokensRequest searchWatchRequest = new SearchAuthTokensRequest();
        if (scroll != null) {
            searchWatchRequest.setScroll(new Scroll(TimeValue.parseTimeValue((String)scroll, null, (String)"scroll")));
        }
        searchWatchRequest.setFrom(from);
        searchWatchRequest.setSize(size);
        if (request.hasContent()) {
            SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().parseXContent(request.contentParser(), true, this.clusterSupportsFeature);
            searchWatchRequest.setSearchSourceBuilder(searchSourceBuilder);
        }
        return channel -> client.execute((ActionType)SearchAuthTokensAction.INSTANCE, (ActionRequest)searchWatchRequest, (ActionListener)new RestToXContentListener(channel, SearchAuthTokensResponse::status));
    }

    public String getName() {
        return "Search AuthToken Action";
    }
}

