/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.kerberos;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auth.kerberos.KeytabJaasConf;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.PrivilegedCode;
import com.floragunn.searchsupport.cstate.ComponentState;
import java.io.File;
import java.nio.file.Path;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosAuthenticationFrontend
implements HttpAuthenticationFrontend {
    private static final String TYPE = "kerberos";
    private static final Oid SPNEGO_OID = KerberosAuthenticationFrontend.createOid("1.3.6.1.5.5.2");
    private static final Oid KRB5MECH_OID = KerberosAuthenticationFrontend.createOid("1.2.840.113554.1.2.2");
    private static final Oid[] KRB_OIDS = new Oid[]{SPNEGO_OID, KRB5MECH_OID};
    private static final Logger log = LogManager.getLogger(KerberosAuthenticationFrontend.class);
    private final boolean stripRealmFromPrincipalName;
    private final boolean challenge;
    private final boolean debug;
    private final ImmutableSet<KerberosPrincipal> acceptorPrincipal;
    private final Path acceptorKeyTabFile;
    private final Configuration keytabConfiguration;
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "kerberos", KerberosAuthenticationFrontend.class).requiresEnterpriseLicense();
    public static TypedComponent.Info<HttpAuthenticationFrontend> INFO = new TypedComponent.Info<HttpAuthenticationFrontend>(){

        public Class<HttpAuthenticationFrontend> getType() {
            return HttpAuthenticationFrontend.class;
        }

        public String getName() {
            return KerberosAuthenticationFrontend.TYPE;
        }

        public TypedComponent.Factory<HttpAuthenticationFrontend> getFactory() {
            return (config, context) -> new KerberosAuthenticationFrontend(config, context);
        }
    };

    public KerberosAuthenticationFrontend(DocNode docNode, ConfigurationRepository.Context context) throws ConfigValidationException {
        Path krb5configFile;
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, (Parser.Context)context);
        this.challenge = vNode.get("challenge").withDefault(true).asBoolean();
        this.debug = vNode.get("debug").withDefault(false).asBoolean();
        boolean useSystemProperties = vNode.get("use_system_properties").withDefault(false).asBoolean();
        if (!useSystemProperties) {
            krb5configFile = this.resolve(vNode.get("krb5_config_file").withDefault("/etc/krb5.conf").asString(), "krb5_config_file", validationErrors, context);
        } else {
            krb5configFile = null;
            vNode.used(new String[]{"krb5_config_file"});
        }
        this.stripRealmFromPrincipalName = vNode.get("strip_realm_from_principal").withDefault(true).asBoolean();
        this.acceptorPrincipal = ImmutableSet.of((Collection)vNode.get("acceptor_principal").asList().withEmptyListAsDefault().ofObjectsParsedByString(s -> (KerberosPrincipal)PrivilegedCode.execute(() -> new KerberosPrincipal((String)s))));
        String acceptorKeyTabFile = vNode.get("acceptor_keytab").required().asString();
        this.acceptorKeyTabFile = this.resolve(acceptorKeyTabFile, "acceptor_keytab", validationErrors, context);
        vNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        if (!useSystemProperties) {
            PrivilegedCode.execute(() -> {
                try {
                    if (this.debug) {
                        System.setProperty("sun.security.krb5.debug", "true");
                        System.setProperty("java.security.debug", "gssloginconfig,logincontext,configparser,configfile");
                        System.setProperty("sun.security.spnego.debug", "true");
                        System.out.println("Kerberos debug is enabled");
                        System.err.println("Kerberos debug is enabled");
                        log.info("Kerberos debug is enabled on stdout");
                    }
                }
                catch (Throwable e) {
                    log.error("Unable to enable krb_debug due to ", e);
                    System.err.println("Unable to enable krb_debug due to " + e);
                    System.out.println("Unable to enable krb_debug due to " + e);
                }
                System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                System.setProperty("java.security.krb5.conf", krb5configFile.toString());
            });
        }
        this.keytabConfiguration = new KeytabJaasConf("*", this.acceptorKeyTabFile, false, this.debug);
        try {
            Subject loginSubject = (Subject)PrivilegedCode.execute(() -> this.getLoginSubject(), LoginException.class);
            if (log.isDebugEnabled()) {
                log.debug("loginSubject: " + loginSubject);
            }
        }
        catch (LoginException e) {
            log.error("Got login exception", (Throwable)e);
            throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
        }
        this.componentState.initialized();
    }

    public AuthCredentials extractCredentials(RequestMetaData<?> request) throws CredentialsException {
        String negotiateHeader = request.getAuthorizationByScheme("negotiate");
        if (negotiateHeader == null) {
            log.debug("No negotiate authorization header found");
            return null;
        }
        byte[] decodedNegotiateHeader = Base64.getDecoder().decode(negotiateHeader);
        return (AuthCredentials)PrivilegedCode.execute(() -> {
            GSSContext gssContext;
            Subject loginSubject;
            try {
                loginSubject = (Subject)PrivilegedCode.execute(() -> this.getLoginSubject(), LoginException.class);
            }
            catch (LoginException e) {
                throw new CredentialsException("Unable to authenticate with SPNEGO", new AuthcResult.DebugInfo(this.getType(), false, e.getMessage(), (Map)ImmutableMap.of((Object)"acceptor_principal", (Object)this.acceptorPrincipal.toString(), (Object)"keytab", (Object)this.keytabConfiguration.toString())), (Throwable)e);
            }
            GSSManager manager = GSSManager.getInstance();
            try {
                gssContext = manager.createContext(Subject.doAs(loginSubject, () -> manager.createCredential(null, Integer.MAX_VALUE, KRB_OIDS, 2)));
            }
            catch (GSSException e) {
                log.warn("Exception while creating GSSContext", (Throwable)e);
                throw new CredentialsException("Unable to authenticate with SPNEGO", new AuthcResult.DebugInfo(this.getType(), false, "Exception while creating GSSContext", (Map)ImmutableMap.of((Object)"login_subject", (Object)loginSubject.toString())), (Throwable)e);
            }
            catch (PrivilegedActionException e) {
                log.warn("Exception while creating GSSContext", e.getCause());
                throw new CredentialsException("Unable to authenticate with SPNEGO", new AuthcResult.DebugInfo(this.getType(), false, "Exception while creating GSSContext", (Map)ImmutableMap.of((Object)"login_subject", (Object)loginSubject.toString())), e.getCause());
            }
            try {
                byte[] outToken;
                try {
                    outToken = Subject.doAs(loginSubject, () -> gssContext.acceptSecContext(decodedNegotiateHeader, 0, decodedNegotiateHeader.length));
                }
                catch (PrivilegedActionException e) {
                    log.info("Exception while GSSContext.acceptSecContext()", e.getCause());
                    throw new CredentialsException("Unable to authenticate with SPNEGO", new AuthcResult.DebugInfo(this.getType(), false, "Did not accept negotiate header", (Map)ImmutableMap.of((Object)"login_subject", (Object)loginSubject.toString())), e.getCause());
                }
                if (outToken == null) {
                    log.debug("Ticket validation not successful, outToken is null");
                    throw new CredentialsException("Unable to authenticate with SPNEGO", new AuthcResult.DebugInfo(this.getType(), false, "Ticket validation not successful, outToken is null", (Map)ImmutableMap.of((Object)"login_subject", (Object)loginSubject.toString())));
                }
                String username = Subject.doAs(loginSubject, () -> KerberosAuthenticationFrontend.getUsername(gssContext));
                if (username == null) {
                    AuthCredentials authCredentials = AuthCredentials.forUser((String)"_incomplete_").authenticatorType(this.getType()).nativeCredentials((Object)outToken).build();
                    return authCredentials;
                }
                if (this.stripRealmFromPrincipalName) {
                    username = KerberosAuthenticationFrontend.stripRealm(username);
                }
                AuthCredentials authCredentials = AuthCredentials.forUser((String)username).authenticatorType(this.getType()).nativeCredentials((Object)outToken).complete().build();
                return authCredentials;
            }
            finally {
                try {
                    gssContext.dispose();
                }
                catch (GSSException e) {
                    log.warn("Exception while disposing gssContext", (Throwable)e);
                }
            }
        }, CredentialsException.class);
    }

    public String getChallenge(AuthCredentials credentials) {
        if (this.challenge) {
            if (credentials != null && credentials.getNativeCredentials() != null) {
                return "Negotiate " + Base64.getEncoder().encodeToString((byte[])credentials.getNativeCredentials());
            }
            return "Negotiate";
        }
        return null;
    }

    public String getType() {
        return TYPE;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    private Path resolve(String value, String property, ValidationErrors validationErrors, ConfigurationRepository.Context context) {
        if (value == null) {
            return null;
        }
        File file = new File(value);
        Path path = file.isAbsolute() ? file.toPath() : context.getStaticSettings().getPatformConfigDirectory().resolve(file.toPath());
        return path;
    }

    private Subject getLoginSubject() throws LoginException {
        Subject subject = new Subject(false, (Set<? extends Principal>)this.acceptorPrincipal, (Set<?>)ImmutableSet.empty(), (Set<?>)ImmutableSet.empty());
        LoginContext loginContext = new LoginContext("KeytabConf", subject, null, this.keytabConfiguration);
        loginContext.login();
        return loginContext.getSubject();
    }

    private static String stripRealm(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.indexOf(64);
        if (pos > 0) {
            return name.substring(0, pos);
        }
        return name;
    }

    private static Oid createOid(String string) {
        try {
            return new Oid(string);
        }
        catch (GSSException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getUsername(GSSContext gssContext) {
        try {
            if (!gssContext.isEstablished()) {
                return null;
            }
            GSSName gssName = gssContext.getSrcName();
            if (gssName != null) {
                return gssName.toString();
            }
            return null;
        }
        catch (GSSException e) {
            log.warn("Error while retrieving name from " + gssContext, (Throwable)e);
            return null;
        }
    }
}

