/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.access_log.read;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.searchguard.enterprise.auditlog.access_log.read.ReadLogContext;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.SourceFieldsContext;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.Uid;

public final class FieldReadCallback {
    private static final Logger log = LogManager.getLogger(FieldReadCallback.class);
    private final ReadLogContext context;
    private final Index index;
    private Function<Map<String, Object>, Map<String, Object>> filterFunction;
    private SourceFieldsContext sfc;
    private Doc doc;

    public FieldReadCallback(ReadLogContext context) {
        this.context = context;
        this.index = context.getIndex();
        try {
            this.sfc = (SourceFieldsContext)HeaderHelper.deserializeSafeFromHeader((ThreadContext)context.getThreadContext(), (String)"_sg_source_field_context");
            if (this.sfc != null && this.sfc.hasIncludesOrExcludes()) {
                if (log.isTraceEnabled()) {
                    log.trace("_sg_source_field_context: " + this.sfc);
                }
                this.filterFunction = XContentMapValues.filter((String[])this.sfc.getIncludes(), (String[])this.sfc.getExcludes());
            }
        }
        catch (Exception e) {
            log.warn("Cannot deserialize _sg_source_field_context because of {}", (Object)e.toString());
        }
    }

    private boolean recordField(String fieldName, Function<String, Boolean> masked) {
        if (masked.apply(fieldName).booleanValue()) {
            return false;
        }
        return this.context.getAuditLogConfig().readHistoryEnabledForField(this.index.getName(), fieldName);
    }

    public void binaryFieldRead(FieldInfo fieldInfo, byte[] fieldValue, Function<String, Boolean> masked) {
        try {
            if (!(this.recordField(fieldInfo.name, f -> false) || fieldInfo.name.equals("_source") || fieldInfo.name.equals("_id"))) {
                return;
            }
            if (fieldInfo.name.equals("_source")) {
                Map<String, Object> source = DocReader.json().readObject(fieldValue);
                if (this.filterFunction != null) {
                    source = this.filterFunction.apply(source);
                }
                DocNode flattenedSource = DocNode.wrap((Object)source).flatten();
                for (String k : flattenedSource.keySet()) {
                    if (!this.recordField(k, f -> (Boolean)masked.apply((String)f) != false && flattenedSource.get(k) instanceof String)) continue;
                    this.fieldRead0(k, flattenedSource.get(k));
                }
            } else if (fieldInfo.name.equals("_id")) {
                this.fieldRead0(fieldInfo.name, Uid.decodeId((byte[])fieldValue));
            } else {
                this.fieldRead0(fieldInfo.name, new String(fieldValue, StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            log.error("Unexpected error reading binary field '{}' in index '{}'", (Object)fieldInfo.name, (Object)this.index.getName());
        }
    }

    public void stringFieldRead(FieldInfo fieldInfo, String fieldValue, Function<String, Boolean> masked) {
        try {
            if (!this.recordField(fieldInfo.name, masked)) {
                return;
            }
            this.fieldRead0(fieldInfo.name, fieldValue);
        }
        catch (Exception e) {
            log.error("Unexpected error reading string field '{}' in index '{}'", (Object)fieldInfo.name, (Object)this.index.getName());
        }
    }

    public void numericFieldRead(FieldInfo fieldInfo, Number fieldValue) {
        try {
            if (!this.recordField(fieldInfo.name, f -> false)) {
                return;
            }
            this.fieldRead0(fieldInfo.name, fieldValue);
        }
        catch (Exception e) {
            log.error("Unexpected error reading numeric field '{}' in index '{}'", (Object)fieldInfo.name, (Object)this.index.getName());
        }
    }

    private void fieldRead0(String fieldName, Object fieldValue) {
        if (this.doc != null) {
            if (fieldName.equals("_id")) {
                this.doc.setId(fieldValue.toString());
            } else {
                this.doc.addField(new Field(fieldName, fieldValue));
            }
        } else {
            String indexName = this.index.getName();
            if (fieldName.equals("_id")) {
                this.doc = new Doc(indexName, fieldValue.toString());
            } else {
                this.doc = new Doc(indexName, null);
                this.doc.addField(new Field(fieldName, fieldValue));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        if (this.doc == null) {
            return;
        }
        try {
            HashMap<String, String> f = new HashMap<String, String>();
            for (Field fi : this.doc.fields) {
                f.put(fi.fieldName, String.valueOf(fi.fieldValue));
            }
            this.context.getAuditLog().logDocumentRead(this.doc.indexName, this.doc.id, null, f);
        }
        catch (Exception e) {
            log.error("Unexpected error finished compliance read entry {} in index '{}': {}", (Object)this.doc.id, (Object)this.index.getName(), (Object)e.toString(), (Object)e);
        }
        finally {
            this.doc = null;
            this.sfc = null;
        }
    }

    private class Doc {
        final String indexName;
        String id;
        final List<Field> fields = new ArrayList<Field>();

        public Doc(String indexName, String id) {
            this.indexName = indexName;
            this.id = id;
        }

        public void addField(Field f) {
            this.fields.add(f);
        }

        public void setId(String id) {
            this.id = id;
        }

        public String toString() {
            return "Doc [indexName=" + this.indexName + ", id=" + this.id + ", fields=" + this.fields + "]";
        }
    }

    private class Field {
        final String fieldName;
        final Object fieldValue;

        public Field(String fieldName, Object fieldValue) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        public String toString() {
            return "Field [fieldName=" + this.fieldName + ", fieldValue=" + this.fieldValue + "]";
        }
    }
}

