/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.jwt.keybyoidc;

import java.net.URI;
import java.util.Collections;
import java.util.Map;

public class OidcProviderConfig {
    private final Map<String, Object> parsedJson;
    private final URI jwksUri;
    private final String tokenEndpoint;

    public OidcProviderConfig(Map<String, Object> map) {
        this.parsedJson = Collections.unmodifiableMap(map);
        this.jwksUri = map.containsKey("jwks_uri") ? URI.create(String.valueOf(map.get("jwks_uri"))) : null;
        this.tokenEndpoint = map.containsKey("token_endpoint") ? String.valueOf(map.get("token_endpoint")) : null;
    }

    public URI getJwksUri() {
        return this.jwksUri;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public URI getAuthorizationEndpoint() {
        Object rawUri = this.parsedJson.get("authorization_endpoint");
        if (rawUri == null) {
            return null;
        }
        return URI.create(String.valueOf(rawUri));
    }

    public URI getEndSessionEndpoint() {
        Object rawUri = this.parsedJson.get("end_session_endpoint");
        if (rawUri == null) {
            return null;
        }
        return URI.create(String.valueOf(rawUri));
    }

    public Map<String, Object> getParsedJson() {
        return this.parsedJson;
    }
}

