/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap.util;

import com.unboundid.ldap.sdk.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

public final class Utils {
    private static final Logger log = LogManager.getLogger(Utils.class);

    private Utils() {
    }

    public static List<Map.Entry<String, Settings>> getOrderedBaseSettings(Map<String, Settings> settingsMap) {
        return Utils.getOrderedBaseSettings(settingsMap.entrySet());
    }

    public static List<Map.Entry<String, Settings>> getOrderedBaseSettings(Set<Map.Entry<String, Settings>> set) {
        ArrayList<Map.Entry<String, Settings>> result = new ArrayList<Map.Entry<String, Settings>>(set);
        Utils.sortBaseSettings(result);
        return Collections.unmodifiableList(result);
    }

    private static void sortBaseSettings(List<Map.Entry<String, Settings>> list) {
        list.sort(new Comparator<Map.Entry<String, Settings>>(){

            @Override
            public int compare(Map.Entry<String, Settings> o1, Map.Entry<String, Settings> o2) {
                int attributeOrder = Integer.compare(o1.getValue().getAsInt("order", Integer.valueOf(Integer.MAX_VALUE)), o2.getValue().getAsInt("order", Integer.valueOf(Integer.MAX_VALUE)));
                if (attributeOrder != 0) {
                    return attributeOrder;
                }
                return o1.getKey().compareTo(o2.getKey());
            }
        });
    }

    public static String getSingleStringValue(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.size() > 1 && log.isDebugEnabled()) {
            log.debug("Multiple values found for attribute {} ({})", (Object)attribute.getBaseName(), (Object)attribute);
        }
        return attribute.getValue();
    }
}

