/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail;

import com.sanctionco.jmail.Email;
import com.sanctionco.jmail.EmailValidator;
import com.sanctionco.jmail.InvalidEmailException;
import com.sanctionco.jmail.net.InternetProtocolAddress;
import java.net.IDN;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class JMail {
    private static final Set<Character> DISALLOWED_UNQUOTED_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('\t'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(','), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('@'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('\"')));
    private static final Set<Character> ALLOWED_DOMAIN_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf(' ')));
    private static final Set<Character> ALLOWED_QUOTED_WITH_ESCAPE = new HashSet<Character>(Arrays.asList(Character.valueOf('\r'), Character.valueOf('\u2400'), Character.valueOf('\n')));

    private JMail() {
    }

    public static EmailValidator validator() {
        return new EmailValidator();
    }

    public static EmailValidator strictValidator() {
        return new EmailValidator().disallowIpDomain().requireTopLevelDomain().disallowExplicitSourceRouting();
    }

    public static boolean isValid(String email) {
        return JMail.tryParse(email).isPresent();
    }

    public static void enforceValid(String email) throws InvalidEmailException {
        if (!JMail.tryParse(email).isPresent()) {
            throw new InvalidEmailException();
        }
    }

    public static Optional<Email> tryParse(String email) {
        Optional<Email> parsed = JMail.internalTryParse(email);
        if (!parsed.isPresent()) {
            return parsed;
        }
        if (parsed.get().isIpAddress()) {
            return parsed;
        }
        return parsed.filter(e -> JMail.isValidIdn(e.domainWithoutComments()));
    }

    private static Optional<Email> internalTryParse(String email) {
        int size;
        if (email == null) {
            return Optional.empty();
        }
        if (email.length() < 3) {
            return Optional.empty();
        }
        List sourceRoutes = Collections.emptyList();
        String fullSourceRoute = "";
        if (email.charAt(0) == '@') {
            Optional<SourceRouteDetail> sourceRoute = JMail.validateSourceRouting(email);
            if (!sourceRoute.isPresent()) {
                return Optional.empty();
            }
            SourceRouteDetail detail = sourceRoute.get();
            sourceRoutes = detail.routes;
            fullSourceRoute = detail.fullRoute.toString();
            email = email.substring(fullSourceRoute.length());
        }
        if ((size = email.length()) > 320) {
            return Optional.empty();
        }
        if (email.charAt(0) == '.') {
            return Optional.empty();
        }
        if (email.charAt(size - 1) == '.' || email.charAt(size - 1) == '-') {
            return Optional.empty();
        }
        boolean atFound = false;
        boolean inQuotes = false;
        boolean previousDot = false;
        boolean previousBackslash = false;
        boolean firstDomainChar = true;
        boolean isIpAddress = false;
        boolean requireAtOrDot = false;
        boolean requireAtDotOrComment = false;
        boolean whitespace = false;
        boolean previousComment = false;
        boolean requireAngledBracket = false;
        StringBuilder localPart = new StringBuilder(size);
        StringBuilder localPartWithoutComments = new StringBuilder(size);
        StringBuilder domain = new StringBuilder(size);
        StringBuilder domainWithoutComments = new StringBuilder(size);
        StringBuilder currentDomainPart = new StringBuilder();
        ArrayList<String> domainParts = new ArrayList<String>();
        ArrayList<String> comments = new ArrayList<String>();
        int localPartCommentLength = 0;
        int domainCommentLength = 0;
        int charactersOnLine = 1;
        for (int i = 0; i < size; ++i) {
            char c = email.charAt(i);
            if (c == '<' && !inQuotes && !previousBackslash) {
                if (email.charAt(size - 1) != '>') {
                    return Optional.empty();
                }
                return JMail.tryParse(email.substring(i + 1, size - 1)).map(e -> new Email((Email)e, localPart.toString()));
            }
            if (c == '@' && !inQuotes && !previousBackslash) {
                if (atFound) {
                    return Optional.empty();
                }
                if (requireAngledBracket) {
                    return Optional.empty();
                }
                atFound = true;
                requireAtDotOrComment = false;
                requireAtOrDot = false;
                whitespace = false;
                previousDot = true;
                continue;
            }
            if (c == '\n') {
                if (charactersOnLine <= 0) {
                    return Optional.empty();
                }
                charactersOnLine = 0;
            } else if (c != '\r') {
                ++charactersOnLine;
            }
            if (requireAtOrDot) {
                if (!JMail.isWhitespace(c) && c != '.') {
                    return Optional.empty();
                }
                requireAtOrDot = false;
            }
            if (requireAtDotOrComment) {
                if (!JMail.isWhitespace(c) && c != '.' && c != '(') {
                    return Optional.empty();
                }
                requireAtDotOrComment = false;
            }
            if (whitespace && !previousDot && !previousComment && c != '.' && c != '@' && c != '(' && !JMail.isWhitespace(c)) {
                if (!atFound) {
                    requireAngledBracket = true;
                } else {
                    return Optional.empty();
                }
            }
            if (c == '(' && !inQuotes) {
                Optional<String> comment = JMail.validateComment(email.substring(i));
                if (!comment.isPresent()) {
                    return Optional.empty();
                }
                String commentStr = comment.get();
                int commentStrLen = commentStr.length();
                if (!atFound && i != 0 && !previousDot) {
                    requireAtOrDot = true;
                } else if (atFound && !firstDomainChar && !previousDot && i + commentStrLen != size) {
                    requireAtOrDot = true;
                }
                i += commentStrLen - 1;
                if (!atFound) {
                    localPart.append(commentStr);
                    localPartCommentLength += commentStrLen;
                } else {
                    domain.append(commentStr);
                    domainCommentLength += commentStrLen;
                }
                previousComment = true;
                comments.add(commentStr.substring(1, commentStrLen - 1));
                continue;
            }
            if (c == '.' && previousDot && !inQuotes) {
                return Optional.empty();
            }
            if (!atFound) {
                if (c == '\"' && i > 0 && !previousDot && !inQuotes) {
                    return Optional.empty();
                }
                boolean mustBeQuoted = DISALLOWED_UNQUOTED_CHARACTERS.contains(Character.valueOf(c));
                if (c != '\"' && !inQuotes && !previousBackslash && mustBeQuoted) {
                    return Optional.empty();
                }
                if (!inQuotes && previousBackslash && !mustBeQuoted && c != ' ' && c != '\\') {
                    return Optional.empty();
                }
                if (inQuotes && ALLOWED_QUOTED_WITH_ESCAPE.contains(Character.valueOf(c)) && !previousBackslash) {
                    return Optional.empty();
                }
                localPart.append(c);
                localPartWithoutComments.append(c);
            } else {
                if (firstDomainChar && c == '[') {
                    String ipDomain = email.substring(i);
                    if (!ipDomain.startsWith("[") || !ipDomain.endsWith("]") || ipDomain.length() < 3) {
                        return Optional.empty();
                    }
                    String ip = ipDomain.substring(1, ipDomain.length() - 1);
                    Optional<String> validatedIp = InternetProtocolAddress.validate(ip);
                    if (!validatedIp.isPresent()) {
                        return Optional.empty();
                    }
                    currentDomainPart.append(validatedIp.get());
                    domain.append(validatedIp.get());
                    domainWithoutComments.append(validatedIp.get());
                    isIpAddress = true;
                    break;
                }
                if (c == '.') {
                    if (currentDomainPart.length() == 0 || currentDomainPart.length() > 63) {
                        return Optional.empty();
                    }
                    if (currentDomainPart.charAt(0) == '-' || currentDomainPart.charAt(currentDomainPart.length() - 1) == '-') {
                        return Optional.empty();
                    }
                    domainParts.add(currentDomainPart.toString());
                    currentDomainPart = new StringBuilder();
                } else if (!JMail.isWhitespace(c)) {
                    currentDomainPart.append(c);
                }
                domain.append(c);
                domainWithoutComments.append(c);
                firstDomainChar = false;
            }
            if (c == '\"' && !previousBackslash) {
                if (inQuotes) {
                    requireAtDotOrComment = true;
                }
                inQuotes = !inQuotes;
            }
            boolean bl = whitespace = JMail.isWhitespace(c) && !inQuotes && !previousBackslash;
            if (!whitespace) {
                previousDot = c == '.';
            }
            previousBackslash = c == '\\' && !previousBackslash;
        }
        if (!atFound) {
            return Optional.empty();
        }
        if (requireAtDotOrComment) {
            return Optional.empty();
        }
        int localPartLen = localPart.length() - localPartCommentLength;
        if (localPartLen == 0 || localPartLen > 64) {
            return Optional.empty();
        }
        int domainLen = domain.length() - domainCommentLength;
        if (domainLen == 0 || domainLen > 255) {
            return Optional.empty();
        }
        if (localPart.charAt(localPart.length() - 1) == '.') {
            return Optional.empty();
        }
        if (currentDomainPart.charAt(0) == '-') {
            return Optional.empty();
        }
        if (currentDomainPart.toString().chars().allMatch(Character::isDigit)) {
            return Optional.empty();
        }
        if (currentDomainPart.length() > 63) {
            return Optional.empty();
        }
        domainParts.add(currentDomainPart.toString());
        return Optional.of(new Email(localPart.toString(), localPartWithoutComments.toString(), domain.toString(), domainWithoutComments.toString(), fullSourceRoute, null, domainParts, comments, sourceRoutes, isIpAddress));
    }

    private static Optional<String> validateComment(String s) {
        if (s.length() < 2) {
            return Optional.empty();
        }
        StringBuilder builder = new StringBuilder(s.length());
        boolean previousBackslash = false;
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (c == '(' && !previousBackslash && i != 0) {
                Optional<String> inner = JMail.validateComment(s.substring(i));
                if (!inner.isPresent()) {
                    return Optional.empty();
                }
                i += inner.get().length() - 1;
                builder.append(inner.get());
                continue;
            }
            builder.append(c);
            if (c == ')' && !previousBackslash) break;
            previousBackslash = c == '\\';
        }
        return Optional.of(builder.toString());
    }

    private static Optional<SourceRouteDetail> validateSourceRouting(String s) {
        boolean requireNewDomain = true;
        SourceRouteDetail detail = new SourceRouteDetail();
        StringBuilder sourceRoute = new StringBuilder();
        StringBuilder currentDomainPart = new StringBuilder();
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (requireNewDomain && c != '@') {
                return Optional.empty();
            }
            if (c == '@' && !requireNewDomain) {
                return Optional.empty();
            }
            if (c == '.' || c == ',' || c == ':') {
                if (currentDomainPart.length() == 0 || currentDomainPart.length() > 63) {
                    return Optional.empty();
                }
                if (currentDomainPart.charAt(0) == '-' || currentDomainPart.charAt(currentDomainPart.length() - 1) == '-') {
                    return Optional.empty();
                }
                if ((c == ',' || c == ':') && currentDomainPart.toString().chars().allMatch(Character::isDigit)) {
                    return Optional.empty();
                }
                currentDomainPart = new StringBuilder();
            } else if (c != '@') {
                currentDomainPart.append(c);
            }
            requireNewDomain = c == ',';
            detail.fullRoute.append(c);
            if (c == ',' || c == ':') {
                String route = sourceRoute.toString();
                if (!JMail.isValidIdn(route)) {
                    return Optional.empty();
                }
                detail.routes.add(route);
                sourceRoute = new StringBuilder();
            } else if (c != '@') {
                sourceRoute.append(c);
            }
            if (c == ':') break;
        }
        if (currentDomainPart.length() > 0) {
            return Optional.empty();
        }
        if (requireNewDomain) {
            return Optional.empty();
        }
        return Optional.of(detail);
    }

    private static boolean isValidIdn(String test) {
        String domain = IDN.toASCII(test);
        int size = domain.length();
        for (int i = 0; i < size; ++i) {
            char c = domain.charAt(i);
            if (ALLOWED_DOMAIN_CHARACTERS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\r';
    }

    private static final class SourceRouteDetail {
        private final StringBuilder fullRoute = new StringBuilder();
        private final List<String> routes = new ArrayList<String>();

        private SourceRouteDetail() {
        }
    }
}

