/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.api;

import com.floragunn.signals.actions.watch.state.search.SearchWatchStateAction;
import com.floragunn.signals.actions.watch.state.search.SearchWatchStateRequest;
import com.floragunn.signals.actions.watch.state.search.SearchWatchStateResponse;
import com.floragunn.signals.api.SignalsTenantAwareRestHandler;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class SearchWatchStateApiAction
extends SignalsTenantAwareRestHandler {
    private Predicate<NodeFeature> clusterSupportsFeature;

    public SearchWatchStateApiAction(Settings settings, Predicate<NodeFeature> clusterSupportsFeature) {
        super(settings);
        this.clusterSupportsFeature = clusterSupportsFeature;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_signals/watch/{tenant}/_search/_state"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/_signals/watch/{tenant}/_search/_state"));
    }

    @Override
    protected final BaseRestHandler.RestChannelConsumer getRestChannelConsumer(RestRequest request, NodeClient client) throws IOException {
        String scroll = request.param("scroll");
        int from = request.paramAsInt("from", -1);
        int size = request.paramAsInt("size", -1);
        request.param("tenant");
        SearchWatchStateRequest searchWatchRequest = new SearchWatchStateRequest();
        if (scroll != null) {
            searchWatchRequest.setScroll(new Scroll(TimeValue.parseTimeValue((String)scroll, null, (String)"scroll")));
        }
        searchWatchRequest.setFrom(from);
        searchWatchRequest.setSize(size);
        if (request.hasContent()) {
            SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().parseXContent(request.contentParser(), true, this.clusterSupportsFeature);
            searchWatchRequest.setSearchSourceBuilder(searchSourceBuilder);
        }
        return channel -> client.execute((ActionType)SearchWatchStateAction.INSTANCE, (ActionRequest)searchWatchRequest, (ActionListener)new RestToXContentListener(channel, SearchWatchStateResponse::status));
    }

    public String getName() {
        return "Search Watch State Action";
    }
}

