/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.action;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchsupport.action.RestApi;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class Action<RequestType extends Request, ResponseType extends Response>
extends ActionType<ResponseType> {
    private static final Logger log = LogManager.getLogger(Action.class);
    private final MessageParser<RequestType> requestParser;
    private final MessageParser<ResponseType> responseParser;

    public Action(String name, MessageParser<RequestType> requestParser, MessageParser<ResponseType> responseParser) {
        super(name);
        this.requestParser = requestParser;
        this.responseParser = responseParser;
    }

    RequestType parseRequest(UnparsedMessage message) throws ConfigValidationException {
        return (RequestType)((Object)((Request)((Object)this.requestParser.apply(message))));
    }

    ResponseType parseResponse(UnparsedMessage message) throws ConfigValidationException {
        return (ResponseType)((Object)((Response)((Object)this.responseParser.apply(message))));
    }

    static UnparsedDocument<?> toUnparsedDoc(StreamInput in) throws IOException {
        byte messageType = in.readByte();
        if (messageType == 0) {
            return null;
        }
        if (messageType == 1) {
            byte[] smile = in.readByteArray();
            return UnparsedDocument.from((byte[])smile, (Format)Format.SMILE);
        }
        if (messageType == 2) {
            String json = in.readString();
            return UnparsedDocument.from((String)json, (Format)Format.JSON);
        }
        if (messageType == 3) {
            String yaml = in.readString();
            return UnparsedDocument.from((String)yaml, (Format)Format.YAML);
        }
        throw new IllegalArgumentException("Unknown messageType " + messageType);
    }

    private static <M> M parse(StreamInput in, MessageParser<M> parser) throws IOException {
        try {
            byte majorVersion = in.readByte();
            byte minorVersion = in.readByte();
            Map metaData = in.readGenericMap();
            if (metaData == null) {
                metaData = Collections.emptyMap();
            }
            UnparsedDocument<?> unparsedDoc = Action.toUnparsedDoc(in);
            UnparsedMessage message = new UnparsedMessage(unparsedDoc, DocNode.wrap(metaData), majorVersion, minorVersion);
            return parser.apply(message);
        }
        catch (ConfigValidationException e) {
            throw new IOException(e);
        }
    }

    @FunctionalInterface
    public static interface MessageParser<M> {
        public M apply(UnparsedMessage var1) throws ConfigValidationException;
    }

    public static class UnparsedMessage {
        private final UnparsedDocument<?> unparsedDoc;
        private final DocNode metaDataDocNode;
        private final byte majorVersion;
        private final byte minorVersion;

        UnparsedMessage(UnparsedDocument<?> unparsedDoc, DocNode metaDataDocNode) {
            this.unparsedDoc = unparsedDoc;
            this.metaDataDocNode = metaDataDocNode;
            this.majorVersion = 0;
            this.minorVersion = 0;
        }

        UnparsedMessage(UnparsedDocument<?> unparsedDoc, DocNode metaDataDocNode, byte majorVersion, byte minorVersion) {
            this.unparsedDoc = unparsedDoc;
            this.metaDataDocNode = metaDataDocNode;
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
        }

        public UnparsedDocument<?> unparsedDoc() {
            return this.unparsedDoc;
        }

        public UnparsedDocument<?> requiredUnparsedDoc() throws ConfigValidationException {
            if (this.unparsedDoc != null) {
                return this.unparsedDoc;
            }
            throw new ConfigValidationException(new ValidationError(null, "Request body missing"));
        }

        public DocNode requiredDocNode() throws ConfigValidationException {
            return this.requiredUnparsedDoc().parseAsDocNode();
        }

        public DocNode getMetaDataDocNode() {
            return this.metaDataDocNode;
        }

        public byte getMajorVersion() {
            return this.majorVersion;
        }

        public byte getMinorVersion() {
            return this.minorVersion;
        }
    }

    public static abstract class Request
    extends ActionRequest
    implements Document<Object> {
        private String ifMatch;
        private String ifNoneMatch;

        public Request() {
        }

        public Request(UnparsedMessage metaData) {
            DocNode metaDataDocNode = metaData.getMetaDataDocNode();
            this.ifMatch = metaDataDocNode.getAsString("if-match");
            this.ifNoneMatch = metaDataDocNode.getAsString("if-none-match");
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte((byte)0);
            out.writeByte((byte)0);
            Map<String, Object> metaData = this.getMetaData();
            if (metaData != null && !metaData.isEmpty()) {
                out.writeGenericMap(metaData);
            } else {
                out.writeGenericMap((Map)null);
            }
            Object basicObject = this.toBasicObject();
            if (basicObject != null) {
                out.writeByte((byte)1);
                out.writeByteArray(DocWriter.smile().writeAsBytes(basicObject));
            } else {
                out.writeByte((byte)0);
            }
        }

        public String getIfMatch() {
            return this.ifMatch;
        }

        public Request ifMatch(String matchConcurrencyControlEntityTag) {
            this.ifMatch = matchConcurrencyControlEntityTag;
            return this;
        }

        public String getIfNoneMatch() {
            return this.ifNoneMatch;
        }

        public boolean mustNotExist() {
            return "*".equals(this.ifNoneMatch);
        }

        public Request ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        protected Map<String, Object> getMetaData() {
            return ImmutableMap.ofNonNull((Object)"if-match", (Object)this.ifMatch, (Object)"if-none-match", (Object)this.ifNoneMatch);
        }

        public ActionRequestValidationException validate() {
            return null;
        }
    }

    public static abstract class Response
    extends ActionResponse
    implements Document<Object>,
    ToXContentObject {
        private int restStatus = 200;
        private String concurrencyControlEntityTag;

        public Response() {
        }

        public Response(UnparsedMessage metaData) {
            DocNode metaDataDocNode = metaData.getMetaDataDocNode();
            this.restStatus = ((Number)metaDataDocNode.get("status")).intValue();
            this.concurrencyControlEntityTag = metaDataDocNode.getAsString("etag");
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte((byte)0);
            out.writeByte((byte)0);
            out.writeGenericMap((Map)ImmutableMap.ofNonNull((Object)"status", (Object)this.restStatus, (Object)"etag", (Object)this.concurrencyControlEntityTag));
            out.writeByte((byte)1);
            out.writeByteArray(this.toSmile());
        }

        public final RestStatus status() {
            RestStatus result = RestStatus.fromCode((int)this.restStatus);
            if (result == null) {
                result = this.restStatus >= 200 && this.restStatus < 300 ? RestStatus.OK : (this.restStatus >= 400 && this.restStatus < 500 ? RestStatus.BAD_REQUEST : RestStatus.INTERNAL_SERVER_ERROR);
            }
            return result;
        }

        public int getStatus() {
            return this.restStatus;
        }

        public Response status(int status) {
            this.restStatus = status;
            return this;
        }

        public String getConcurrencyControlEntityTag() {
            return this.concurrencyControlEntityTag;
        }

        public Response concurrencyControlEntityTag(String concurrencyControlEntityTag) {
            this.concurrencyControlEntityTag = concurrencyControlEntityTag;
            return this;
        }

        public Response eTag(String concurrencyControlEntityTag) {
            this.concurrencyControlEntityTag = concurrencyControlEntityTag;
            return this;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.value(this.toBasicObject());
            return builder;
        }

        public RestResponse toRestResponse() {
            return RestApi.toRestResponse(this);
        }
    }

    private static interface MessageType {
        public static final byte EMPTY = 0;
        public static final byte SMILE = 1;
        public static final byte JSON_STRING = 2;
        public static final byte YAML_STRING = 3;
    }

    public static class HandlerDependencies {
        final ThreadPool threadPool;
        final TransportService transportService;
        final ActionFilters actionFilters;

        @Inject
        public HandlerDependencies(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters) {
            this.threadPool = threadPool;
            this.transportService = transportService;
            this.actionFilters = actionFilters;
        }
    }

    public static abstract class Handler<RequestType extends Request, ResponseType extends Response>
    extends HandledTransportAction<RequestType, ResponseType> {
        private final Executor executor;

        protected Handler(Action<RequestType, ResponseType> action, HandlerDependencies handlerDependencies) {
            super(action.name(), handlerDependencies.transportService, handlerDependencies.actionFilters, in -> (Request)((Object)((Object)Action.parse(in, action.requestParser))), (Executor)handlerDependencies.threadPool.generic());
            this.executor = handlerDependencies.threadPool.generic();
        }

        protected final void doExecute(Task task, RequestType request, ActionListener<ResponseType> listener) {
            try {
                this.doExecute(request).whenComplete((response, e) -> {
                    if (response != null) {
                        listener.onResponse((Object)response);
                    } else if (e instanceof Exception) {
                        log.error("Error while executing {}", (Object)request, e);
                        listener.onFailure((Exception)e);
                    } else if (e != null) {
                        log.error("Error while executing {}", (Object)request, e);
                        listener.onFailure(new Exception((Throwable)e));
                    } else {
                        Exception e2 = new Exception("doExecute() of " + this + " did not provide a result");
                        log.error("Error while executing {}", (Object)request, (Object)e2);
                        listener.onFailure(e2);
                    }
                });
            }
            catch (Exception e2) {
                log.error("Error while executing {}", request, (Object)e2);
                listener.onFailure(e2);
            }
            catch (Throwable t) {
                log.error("Error while executing {}", request, (Object)t);
                listener.onFailure(new Exception(t));
            }
        }

        protected abstract CompletableFuture<ResponseType> doExecute(RequestType var1);

        protected static RuntimeException restStatusException(int status, String message) {
            throw new ElasticsearchStatusException(message, RestStatus.fromCode((int)status) != null ? RestStatus.fromCode((int)status) : RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }

        protected static RuntimeException notFound(String message) {
            throw new ElasticsearchStatusException(message, RestStatus.NOT_FOUND, new Object[0]);
        }

        protected Executor getExecutor() {
            return this.executor;
        }

        protected <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
            return CompletableFuture.supplyAsync(supplier, this.executor);
        }
    }
}

