/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.indices;

import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequestBuilder;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;

public class IndexCleanupAgent
implements ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(IndexCleanupAgent.class);
    private static final Supplier<QueryBuilder> DEFAULT_CLEANUP_QUERY = () -> QueryBuilders.rangeQuery((String)"expires").lt((Object)System.currentTimeMillis());
    private final Client client;
    private final ThreadPool threadPool;
    private final String index;
    private final Supplier<QueryBuilder> cleanupQuery;
    private final ClusterService clusterService;
    private final ComponentState componentState;
    private final TimeAggregation deleteActionMetrics = new TimeAggregation.Milliseconds();
    private Scheduler.Cancellable cleanupJob;
    private TimeValue cleanupInterval = TimeValue.timeValueHours((long)1L);
    private volatile boolean cleanupInProgress;
    private volatile long cleanupInProgressSince;
    private final ClusterStateListener clusterStateListener = new ClusterStateListener(){

        public void clusterChanged(ClusterChangedEvent event) {
            IndexCleanupAgent.this.checkState(event.state());
        }
    };

    public IndexCleanupAgent(String indexName, Supplier<QueryBuilder> cleanupQuery, TimeValue cleanupInterval, Client client, ClusterService clusterService, ThreadPool threadPool) {
        this.client = client;
        this.threadPool = threadPool;
        this.index = indexName;
        this.cleanupQuery = cleanupQuery;
        this.clusterService = clusterService;
        this.cleanupInterval = cleanupInterval;
        this.componentState = new ComponentState("index_cleanup_agent_" + indexName).mandatory(false);
        this.componentState.setState(ComponentState.State.SUSPENDED);
        this.componentState.addMetrics("delete_actions", this.deleteActionMetrics);
        if (clusterService.lifecycleState() == Lifecycle.State.STARTED) {
            this.checkState(clusterService.state());
        }
        clusterService.addListener(this.clusterStateListener);
    }

    public IndexCleanupAgent(String indexName, TimeValue cleanupInterval, Client client, ClusterService clusterService, ThreadPool threadPool) {
        this(indexName, DEFAULT_CLEANUP_QUERY, cleanupInterval, client, clusterService, threadPool);
    }

    public IndexCleanupAgent(String indexName, String expiresColumnName, TimeValue cleanupInterval, Client client, ClusterService clusterService, ThreadPool threadPool) {
        this(indexName, () -> QueryBuilders.rangeQuery((String)expiresColumnName).lt((Object)System.currentTimeMillis()), cleanupInterval, client, clusterService, threadPool);
    }

    private void cleanupExpiredEntries() {
        if (this.cleanupInProgress) {
            log.warn("Cleanup for " + this.index + " is still in progress since " + (System.currentTimeMillis() - this.cleanupInProgressSince) + " ms. Skipping next cleanup");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Starting cleanup for " + this.index + ". Interval: " + this.cleanupInterval);
        }
        this.cleanupInProgress = true;
        this.cleanupInProgressSince = System.currentTimeMillis();
        try {
            final Meter meter = Meter.basic(MetricsLevel.BASIC, this.deleteActionMetrics);
            ((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((ElasticsearchClient)this.client).filter(this.cleanupQuery.get())).source(new String[]{this.index})).execute((ActionListener)new ActionListener<BulkByScrollResponse>(){

                public void onResponse(BulkByScrollResponse response) {
                    IndexCleanupAgent.this.cleanupInProgress = false;
                    long deleted = response.getDeleted();
                    meter.count("deleted_documents", deleted);
                    meter.close();
                    log.debug("Deleted " + deleted + " expired entries from " + IndexCleanupAgent.this.index);
                    if (log.isTraceEnabled()) {
                        log.trace(Strings.toString((ToXContent)response));
                    }
                }

                public void onFailure(Exception e) {
                    IndexCleanupAgent.this.cleanupInProgress = false;
                    meter.close();
                    if (e instanceof IndexNotFoundException) {
                        log.debug("No expired entries have been deleted because the index does not exist", (Throwable)e);
                    } else {
                        log.error("Error while deleting expired entries from " + IndexCleanupAgent.this.index, (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.cleanupInProgress = false;
            log.error("Error while starting cleanup", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState(ClusterState clusterState) {
        boolean isMaster = clusterState.nodes().isLocalNodeElectedMaster();
        if (isMaster && this.cleanupJob == null) {
            IndexCleanupAgent indexCleanupAgent = this;
            synchronized (indexCleanupAgent) {
                if (this.cleanupJob == null) {
                    this.cleanupJob = this.threadPool.scheduleWithFixedDelay(() -> this.cleanupExpiredEntries(), this.cleanupInterval, (Executor)this.threadPool.generic());
                }
                this.componentState.setState(ComponentState.State.INITIALIZED);
            }
        }
        if (!isMaster && this.cleanupJob != null) {
            IndexCleanupAgent indexCleanupAgent = this;
            synchronized (indexCleanupAgent) {
                if (this.cleanupJob != null) {
                    this.cleanupJob.cancel();
                    this.cleanupJob = null;
                    this.cleanupInProgress = false;
                }
                this.componentState.setState(ComponentState.State.SUSPENDED);
            }
        }
    }

    public TimeValue getCleanupInterval() {
        return this.cleanupInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.clusterService.removeListener(this.clusterStateListener);
        IndexCleanupAgent indexCleanupAgent = this;
        synchronized (indexCleanupAgent) {
            if (this.cleanupJob != null) {
                this.cleanupJob.cancel();
                this.cleanupJob = null;
                this.cleanupInProgress = false;
            }
        }
    }

    @Override
    public ComponentState getComponentState() {
        return this.componentState;
    }
}

