/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.UnmodifiableIterator;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedDocumentAuthorization;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.floragunn.searchsupport.meta.Meta;
import com.selectivem.collections.CompactMapGroupBuilder;
import com.selectivem.collections.DeduplicatingCompactSubSetBuilder;
import com.selectivem.collections.ImmutableCompactSubSet;
import com.selectivem.collections.IndexedImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RoleBasedAuthorizationBase<SingleRule, JoinedRule>
implements ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(RoleBasedDocumentAuthorization.class);
    protected final SgDynamicConfiguration<Role> roles;
    protected final StaticRules.Index<SingleRule> staticIndexRules;
    protected final StaticRules.Alias<SingleRule> staticAliasRules;
    protected final StaticRules.DataStream<SingleRule> staticDataStreamRules;
    private volatile StatefulRules<SingleRule> statefulRules;
    private final Function<Role.Index, SingleRule> roleToRuleFunction;
    protected final ComponentState componentState = new ComponentState(this.componentName());
    protected final MetricsLevel metricsLevel;
    private final TimeAggregation statefulIndexRebuild = new TimeAggregation.Milliseconds();

    public RoleBasedAuthorizationBase(SgDynamicConfiguration<Role> roles, Meta indexMetadata, MetricsLevel metricsLevel, Function<Role.Index, SingleRule> roleToRuleFunction) {
        this.roles = roles;
        this.metricsLevel = metricsLevel;
        this.roleToRuleFunction = roleToRuleFunction;
        this.staticIndexRules = new StaticRules.Index<SingleRule>(roles, roleToRuleFunction);
        this.staticAliasRules = new StaticRules.Alias<SingleRule>(roles, roleToRuleFunction);
        this.staticDataStreamRules = new StaticRules.DataStream<SingleRule>(roles, roleToRuleFunction);
        if (indexMetadata != null) {
            try (Meter meter = Meter.basic((MetricsLevel)metricsLevel, (TimeAggregation)this.statefulIndexRebuild);){
                this.statefulRules = new StatefulRules<SingleRule>(roles, indexMetadata, roleToRuleFunction);
            }
        }
        this.componentState.addPart(this.staticIndexRules.getComponentState());
        this.componentState.setConfigVersion(roles.getDocVersion());
        this.componentState.updateStateFromParts();
        if (metricsLevel.basicEnabled()) {
            this.componentState.addMetrics("stateful_index_rebuilds", (Measurement)this.statefulIndexRebuild);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasRestrictions(PrivilegesEvaluationContext context, ResolvedIndices resolved, Meter meter) throws PrivilegesEvaluationException {
        try (Meter subMeter = meter.detail(this.hasRestrictionsMetricName());){
            if (context.getMappedRoles().isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (this.staticIndexRules.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                boolean bl = false;
                return bl;
            }
            if (resolved == null) {
                boolean bl = true;
                return bl;
            }
            if (resolved.getLocal().hasNonExistingObjects()) {
                log.debug("ResolvedIndices {} contain non-existing indices. Assuming full document restriction.", (Object)resolved);
                boolean bl = true;
                return bl;
            }
            if (this.staticIndexRules.roleWithIndexWildcardToRule.keySet().containsAny((Collection)context.getMappedRoles())) {
                boolean bl = true;
                return bl;
            }
            StatefulRules<SingleRule> statefulRules = this.statefulRules;
            for (Meta.Index index : resolved.getLocal().getPureIndices()) {
                if (!this.hasRestrictions(context, statefulRules, index)) continue;
                boolean bl = true;
                return bl;
            }
            if (!this.staticAliasRules.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                for (Meta.Alias alias : resolved.getLocal().getAliases()) {
                    if (!this.hasRestrictions(context, statefulRules, alias)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            if (!this.staticDataStreamRules.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                for (Meta.DataStream dataStream : resolved.getLocal().getDataStreams()) {
                    if (!this.hasRestrictions(context, statefulRules, dataStream)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (PrivilegesEvaluationException e) {
            this.componentState.addLastException("has_restriction", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.componentState.addLastException("has_restriction_u", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasRestrictions(PrivilegesEvaluationContext context, Meta.Index index, Meter meter) throws PrivilegesEvaluationException {
        try (Meter subMeter = meter.detail(this.hasRestrictionsMetricName());){
            if (context.getMappedRoles().isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (!index.exists()) {
                log.debug("Index {} does not exist. Assuming full document restriction.", (Object)index);
                boolean bl = true;
                return bl;
            }
            if (this.staticIndexRules.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.hasRestrictions(context, this.statefulRules, index);
            return bl;
        }
        catch (PrivilegesEvaluationException e) {
            this.componentState.addLastException("has_dls_restriction", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.componentState.addLastException("has_dls_restriction_u", (Throwable)e);
            throw e;
        }
    }

    private boolean hasRestrictions(PrivilegesEvaluationContext context, StatefulRules<SingleRule> statefulRules, Meta.Index index) throws PrivilegesEvaluationException {
        ImmutableCompactSubSet roleWithoutRule;
        if (statefulRules != null && statefulRules.covers(index.name()) ? (roleWithoutRule = (ImmutableCompactSubSet)statefulRules.index.indexToRoleWithoutRule.get((Object)index)) != null && roleWithoutRule.containsAny((Collection)context.getMappedRoles()) : this.staticIndexRules.hasUnrestrictedPatterns(context, index)) {
            return false;
        }
        if (this.staticIndexRules.hasUnrestrictedDynamicPatterns(context, index)) {
            return false;
        }
        if (!index.parentAliases().isEmpty() && !this.hasRestrictions(context, statefulRules, (Collection<Meta.Alias>)index.parentAliases())) {
            return false;
        }
        return index.parentDataStream() == null || this.hasRestrictions(context, statefulRules, index.parentDataStream());
    }

    private boolean hasRestrictions(PrivilegesEvaluationContext context, StatefulRules<SingleRule> statefulRules, Meta.Alias alias) throws PrivilegesEvaluationException {
        ImmutableCompactSubSet roleWithoutRule;
        if (statefulRules != null && statefulRules.covers(alias.name()) ? (roleWithoutRule = (ImmutableCompactSubSet)statefulRules.alias.aliasToRoleWithoutRule.get((Object)alias)) != null && roleWithoutRule.containsAny((Collection)context.getMappedRoles()) : this.staticAliasRules.hasUnrestrictedPatterns(context, alias)) {
            return false;
        }
        return !this.staticAliasRules.hasUnrestrictedDynamicPatterns(context, alias);
    }

    private boolean hasRestrictions(PrivilegesEvaluationContext context, StatefulRules<SingleRule> statefulRules, Collection<Meta.Alias> aliases) throws PrivilegesEvaluationException {
        if (aliases.isEmpty()) {
            return true;
        }
        if (this.staticAliasRules.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
            return false;
        }
        for (Meta.Alias alias : aliases) {
            ImmutableCompactSubSet roleWithoutRule;
            if (statefulRules != null && statefulRules.covers(alias.name()) ? (roleWithoutRule = (ImmutableCompactSubSet)statefulRules.alias.aliasToRoleWithoutRule.get((Object)alias)) != null && roleWithoutRule.containsAny((Collection)context.getMappedRoles()) : this.staticAliasRules.hasUnrestrictedPatterns(context, alias)) {
                return false;
            }
            if (!this.staticAliasRules.hasUnrestrictedDynamicPatterns(context, alias)) continue;
            return false;
        }
        return true;
    }

    private boolean hasRestrictions(PrivilegesEvaluationContext context, StatefulRules<SingleRule> statefulRules, Meta.DataStream dataStream) throws PrivilegesEvaluationException {
        ImmutableCompactSubSet roleWithoutRule;
        if (statefulRules != null && statefulRules.covers(dataStream.name()) ? (roleWithoutRule = (ImmutableCompactSubSet)statefulRules.dataStream.dataStreamToRoleWithoutRule.get((Object)dataStream)) != null && roleWithoutRule.containsAny((Collection)context.getMappedRoles()) : this.staticDataStreamRules.hasUnrestrictedPatterns(context, dataStream)) {
            return false;
        }
        if (this.staticDataStreamRules.hasUnrestrictedDynamicPatterns(context, dataStream)) {
            return false;
        }
        return dataStream.parentAliases().isEmpty() || this.hasRestrictions(context, statefulRules, (Collection<Meta.Alias>)dataStream.parentAliases());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JoinedRule getRestriction(PrivilegesEvaluationContext context, Meta.Index index, Meter meter) throws PrivilegesEvaluationException {
        try (Meter subMeter = meter.detail(this.evaluateRestrictionsMetricName());){
            JoinedRule JoinedRule = this.getRestrictionImpl(context, index);
            return JoinedRule;
        }
        catch (PrivilegesEvaluationException e) {
            this.componentState.addLastException("get_restriction", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.componentState.addLastException("get_restriction_u", (Throwable)e);
            throw e;
        }
    }

    protected JoinedRule getRestrictionImpl(PrivilegesEvaluationContext context, Meta.Index index) throws PrivilegesEvaluationException {
        ImmutableCompactSubSet roleWithoutQuery;
        if (context.getMappedRoles().isEmpty()) {
            return this.fullyRestricted();
        }
        Meta.DataStream parentDataStream = index.parentDataStream();
        if (this.staticIndexRules.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
            return this.unrestricted();
        }
        if (parentDataStream != null && this.staticDataStreamRules.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
            return this.unrestricted();
        }
        if (!index.parentAliases().isEmpty() && this.staticAliasRules.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
            return this.unrestricted();
        }
        StatefulRules<SingleRule> statefulRules = this.statefulRules;
        Map roleToQueryForIndex = null;
        Map roleToQueryForDataStream = null;
        if (statefulRules != null && !statefulRules.covers(index.name())) {
            statefulRules = null;
        }
        if (statefulRules != null) {
            roleWithoutQuery = (ImmutableCompactSubSet)statefulRules.index.indexToRoleWithoutRule.get((Object)index);
            if (roleWithoutQuery != null && roleWithoutQuery.containsAny((Collection)context.getMappedRoles())) {
                return this.unrestricted();
            }
            roleToQueryForIndex = (Map)statefulRules.index.indexToRoleToRule.get((Object)index);
        }
        if (statefulRules != null && parentDataStream != null) {
            roleWithoutQuery = (ImmutableCompactSubSet)statefulRules.dataStream.dataStreamToRoleWithoutRule.get((Object)parentDataStream);
            if (roleWithoutQuery != null && roleWithoutQuery.containsAny((Collection)context.getMappedRoles())) {
                return this.unrestricted();
            }
            roleToQueryForDataStream = (Map)statefulRules.dataStream.dataStreamToRoleToRule.get((Object)parentDataStream);
        }
        HashSet<Object> rules = new HashSet<Object>();
        for (String role : context.getMappedRoles()) {
            ImmutableMap dataStreamPatternTemplateToRule;
            ImmutableSet dataStreamPatternTemplateWithoutRule;
            Pattern pattern;
            ImmutableSet dateMathExpressionsWithoutRule;
            ImmutableMap indexPatternTemplateToRule;
            ImmutableSet indexPatternTemplatesWithoutRule;
            Pattern pattern2;
            Map.Entry entry2;
            Object rule = this.staticIndexRules.roleWithIndexWildcardToRule.get((Object)role);
            if (rule != null) {
                rules.add(rule);
            }
            if (parentDataStream != null && (rule = this.staticDataStreamRules.roleWithIndexWildcardToRule.get((Object)role)) != null) {
                rules.add(rule);
            }
            if (roleToQueryForIndex != null && (rule = roleToQueryForIndex.get(role)) != null) {
                rules.add(rule);
            }
            if (roleToQueryForDataStream != null && (rule = roleToQueryForDataStream.get(role)) != null) {
                rules.add(rule);
            }
            if (statefulRules == null) {
                Pattern indexPatternWithoutRule = (Pattern)this.staticIndexRules.rolesToIndexPatternWithoutRule.get((Object)role);
                if (indexPatternWithoutRule != null && indexPatternWithoutRule.matches(index.name())) {
                    return this.unrestricted();
                }
                UnmodifiableIterator indexPatternToRule = (ImmutableMap)this.staticIndexRules.rolesToIndexPatternToRule.get((Object)role);
                if (indexPatternToRule != null) {
                    for (Map.Entry entry2 : indexPatternToRule.entrySet()) {
                        pattern2 = (Pattern)entry2.getKey();
                        if (!pattern2.matches(index.name())) continue;
                        rules.add(entry2.getValue());
                    }
                }
            }
            if ((indexPatternTemplatesWithoutRule = (ImmutableSet)this.staticIndexRules.rolesToIndexPatternTemplateWithoutRule.get((Object)role)) != null) {
                for (Role.IndexPatterns.IndexPatternTemplate indexPatternTemplate : indexPatternTemplatesWithoutRule) {
                    try {
                        Pattern pattern3 = context.getRenderedPattern(indexPatternTemplate.getTemplate());
                        if (!pattern3.matches(index.name()) || indexPatternTemplate.getExclusions().matches(index.name())) continue;
                        return this.unrestricted();
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                    }
                }
            }
            if ((indexPatternTemplateToRule = (ImmutableMap)this.staticIndexRules.rolesToIndexPatternTemplateToRule.get((Object)role)) != null) {
                Role.IndexPatterns.IndexPatternTemplate indexPatternTemplate;
                indexPatternTemplate = indexPatternTemplateToRule.entrySet().iterator();
                while (indexPatternTemplate.hasNext()) {
                    entry2 = (Map.Entry)indexPatternTemplate.next();
                    try {
                        pattern2 = context.getRenderedPattern(((Role.IndexPatterns.IndexPatternTemplate)entry2.getKey()).getTemplate());
                        if (!pattern2.matches(index.name()) || ((Role.IndexPatterns.IndexPatternTemplate)entry2.getKey()).getExclusions().matches(index.name())) continue;
                        rules.add(entry2.getValue());
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                    }
                }
            }
            if ((dateMathExpressionsWithoutRule = (ImmutableSet)this.staticIndexRules.rolesToIndexDateMathExpressionWithoutRule.get((Object)role)) != null) {
                entry2 = dateMathExpressionsWithoutRule.iterator();
                while (entry2.hasNext()) {
                    Role.IndexPatterns.DateMathExpression dateMathExpression = (Role.IndexPatterns.DateMathExpression)entry2.next();
                    try {
                        Pattern pattern4 = context.getRenderedDateMathExpression(dateMathExpression.getDateMathExpression());
                        if (!pattern4.matches(index.name()) || dateMathExpression.getExclusions().matches(index.name())) continue;
                        return this.unrestricted();
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                    }
                }
            }
            if (!index.parentAliases().isEmpty()) {
                if (statefulRules == null && this.staticAliasRules.isUnrestrictedViaParentAlias(context, (Meta.IndexLikeObject)index, role)) {
                    return this.unrestricted();
                }
                if (this.staticAliasRules.isUnrestrictedViaTemplatesOnParentAlias(context, (Meta.IndexLikeObject)index, role)) {
                    return this.unrestricted();
                }
                this.staticAliasRules.collectRulesViaTemplatesOnParentAlias(context, (Meta.IndexLikeObject)index, role, rules);
                if (statefulRules == null) {
                    this.staticAliasRules.collectRulesViaParentAlias(context, (Meta.IndexLikeObject)index, role, rules);
                }
            }
            if (parentDataStream == null) continue;
            if (statefulRules == null) {
                Pattern dataStreamPatternWithoutRule = (Pattern)this.staticDataStreamRules.rolesToIndexPatternWithoutRule.get((Object)role);
                if (dataStreamPatternWithoutRule != null && dataStreamPatternWithoutRule.matches(parentDataStream.name())) {
                    return this.unrestricted();
                }
                UnmodifiableIterator dataStreamPatternToRule = (ImmutableMap)this.staticDataStreamRules.rolesToIndexPatternToRule.get((Object)role);
                if (dataStreamPatternToRule != null) {
                    for (Map.Entry entry3 : dataStreamPatternToRule.entrySet()) {
                        pattern = (Pattern)entry3.getKey();
                        if (!pattern.matches(parentDataStream.name())) continue;
                        rules.add(entry3.getValue());
                    }
                }
            }
            if ((dataStreamPatternTemplateWithoutRule = (ImmutableSet)this.staticDataStreamRules.rolesToIndexPatternTemplateWithoutRule.get((Object)role)) != null) {
                for (Role.IndexPatterns.IndexPatternTemplate indexPatternTemplate : dataStreamPatternTemplateWithoutRule) {
                    try {
                        Pattern pattern5 = context.getRenderedPattern(indexPatternTemplate.getTemplate());
                        if (!pattern5.matches(parentDataStream.name()) || indexPatternTemplate.getExclusions().matches(parentDataStream.name())) continue;
                        return this.unrestricted();
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                    }
                }
            }
            if ((dataStreamPatternTemplateToRule = (ImmutableMap)this.staticDataStreamRules.rolesToIndexPatternTemplateToRule.get((Object)role)) != null) {
                for (Map.Entry entry3 : dataStreamPatternTemplateToRule.entrySet()) {
                    try {
                        pattern = context.getRenderedPattern(((Role.IndexPatterns.IndexPatternTemplate)entry3.getKey()).getTemplate());
                        if (!pattern.matches(parentDataStream.name()) || ((Role.IndexPatterns.IndexPatternTemplate)entry3.getKey()).getExclusions().matches(parentDataStream.name())) continue;
                        rules.add(entry3.getValue());
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                    }
                }
            }
            if (parentDataStream.parentAliases().isEmpty()) continue;
            if (statefulRules == null && this.staticAliasRules.isUnrestrictedViaParentAlias(context, (Meta.IndexLikeObject)parentDataStream, role)) {
                return this.unrestricted();
            }
            if (this.staticAliasRules.isUnrestrictedViaTemplatesOnParentAlias(context, (Meta.IndexLikeObject)parentDataStream, role)) {
                return this.unrestricted();
            }
            this.staticAliasRules.collectRulesViaTemplatesOnParentAlias(context, (Meta.IndexLikeObject)parentDataStream, role, rules);
            if (statefulRules != null) continue;
            this.staticAliasRules.collectRulesViaParentAlias(context, (Meta.IndexLikeObject)parentDataStream, role, rules);
        }
        if (rules.isEmpty()) {
            return this.fullyRestricted();
        }
        return this.compile(context, rules);
    }

    protected abstract JoinedRule unrestricted();

    protected abstract JoinedRule fullyRestricted();

    protected abstract JoinedRule compile(PrivilegesEvaluationContext var1, Collection<SingleRule> var2) throws PrivilegesEvaluationException;

    protected abstract String hasRestrictionsMetricName();

    protected abstract String evaluateRestrictionsMetricName();

    protected abstract String componentName();

    public void updateIndices(Meta indexMetadata) {
        StatefulRules<SingleRule> statefulRules = this.statefulRules;
        if (statefulRules == null || !statefulRules.indexMetadata.equals((Object)indexMetadata)) {
            try (Meter meter = Meter.basic((MetricsLevel)this.metricsLevel, (TimeAggregation)this.statefulIndexRebuild);){
                this.statefulRules = new StatefulRules<SingleRule>(this.roles, indexMetadata, this.roleToRuleFunction);
                this.componentState.replacePart(this.statefulRules.getComponentState());
            }
        }
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    static class StaticRules<MetaDataObject extends Meta.IndexLikeObject, RolePermissions extends Role.Index, SingleRule>
    implements ComponentStateProvider {
        private final ComponentState componentState;
        protected final ImmutableSet<String> rolesWithIndexWildcardWithoutRule;
        protected final ImmutableMap<String, SingleRule> roleWithIndexWildcardToRule;
        protected final ImmutableMap<String, ImmutableMap<Role.IndexPatterns.IndexPatternTemplate, SingleRule>> rolesToIndexPatternTemplateToRule;
        protected final ImmutableMap<String, ImmutableSet<Role.IndexPatterns.IndexPatternTemplate>> rolesToIndexPatternTemplateWithoutRule;
        protected final ImmutableMap<String, ImmutableSet<Role.IndexPatterns.DateMathExpression>> rolesToIndexDateMathExpressionWithoutRule;
        protected final ImmutableMap<String, ImmutableMap<Pattern, SingleRule>> rolesToIndexPatternToRule;
        protected final ImmutableMap<String, Pattern> rolesToIndexPatternWithoutRule;
        protected final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;
        protected final Function<Role.Index, SingleRule> roleToRuleFunction;

        StaticRules(SgDynamicConfiguration<Role> roles, String objectName, Function<Role, Collection<RolePermissions>> getPermissionsFunction, Function<Role.Index, SingleRule> roleToRuleFunction) {
            this.componentState = new ComponentState("static_rules_" + objectName);
            this.roleToRuleFunction = roleToRuleFunction;
            ImmutableSet.Builder rolesWithIndexWildcardWithoutRule = new ImmutableSet.Builder();
            ImmutableMap.Builder roleWithIndexWildcardToRule = new ImmutableMap.Builder();
            ImmutableMap.Builder rolesToIndexPatternTemplateToRule = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder());
            ImmutableMap.Builder rolesToIndexPatternTemplateWithoutRule = new ImmutableMap.Builder().defaultValue(k -> new ImmutableSet.Builder());
            ImmutableMap.Builder rolesToIndexPatternToRule = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder());
            ImmutableMap.Builder rolesToIndexDateMathExpressionWithoutRule = new ImmutableMap.Builder().defaultValue(k -> new ImmutableSet.Builder());
            ImmutableMap.Builder rolesToIndexPatternWithoutRule = new ImmutableMap.Builder().defaultValue(k -> new ArrayList());
            ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.Index rolePermissions : getPermissionsFunction.apply(role)) {
                        SingleRule singleRule;
                        if (rolePermissions.getIndexPatterns().getPattern().isWildcard()) {
                            singleRule = this.roleToRule(rolePermissions);
                            if (singleRule == null) {
                                rolesWithIndexWildcardWithoutRule.add((Object)roleName);
                                continue;
                            }
                            roleWithIndexWildcardToRule.put((Object)roleName, singleRule);
                            continue;
                        }
                        singleRule = this.roleToRule(rolePermissions);
                        for (Role.IndexPatterns.IndexPatternTemplate indexPatternTemplate : rolePermissions.getIndexPatterns().getPatternTemplates()) {
                            if (singleRule == null) {
                                ((ImmutableSet.Builder)rolesToIndexPatternTemplateWithoutRule.get((Object)roleName)).add((Object)indexPatternTemplate);
                                continue;
                            }
                            ((ImmutableMap.Builder)rolesToIndexPatternTemplateToRule.get((Object)roleName)).put((Object)indexPatternTemplate, singleRule);
                        }
                        for (Role.IndexPatterns.DateMathExpression dateMathExpression : rolePermissions.getIndexPatterns().getDateMathExpressions()) {
                            if (singleRule != null) continue;
                            ((ImmutableSet.Builder)rolesToIndexDateMathExpressionWithoutRule.get((Object)roleName)).add((Object)dateMathExpression);
                        }
                        if (rolePermissions.getIndexPatterns().getPattern().isBlank()) continue;
                        if (singleRule == null) {
                            ((List)rolesToIndexPatternWithoutRule.get((Object)roleName)).add(rolePermissions.getIndexPatterns().getPattern());
                            continue;
                        }
                        ((ImmutableMap.Builder)rolesToIndexPatternToRule.get((Object)roleName)).put((Object)rolePermissions.getIndexPatterns().getPattern(), singleRule);
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)((String)entry.getKey()))).with((Object)e);
                }
            }
            this.rolesWithIndexWildcardWithoutRule = rolesWithIndexWildcardWithoutRule.build();
            this.roleWithIndexWildcardToRule = roleWithIndexWildcardToRule.build();
            this.rolesToIndexPatternTemplateToRule = rolesToIndexPatternTemplateToRule.build(b -> b.build());
            this.rolesToIndexPatternTemplateWithoutRule = rolesToIndexPatternTemplateWithoutRule.build(b -> b.build());
            this.rolesToIndexDateMathExpressionWithoutRule = rolesToIndexDateMathExpressionWithoutRule.build(b -> b.build());
            this.rolesToInitializationErrors = rolesToInitializationErrors.build(b -> b.build());
            this.rolesToIndexPatternToRule = rolesToIndexPatternToRule.build(b -> b.build());
            this.rolesToIndexPatternWithoutRule = rolesToIndexPatternWithoutRule.build(b -> Pattern.join((Collection)b));
            if (this.rolesToInitializationErrors.isEmpty()) {
                this.componentState.initialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "roles_with_errors");
                this.componentState.addDetail((Object)rolesToInitializationErrors);
            }
        }

        protected SingleRule roleToRule(Role.Index rolePermissions) {
            return this.roleToRuleFunction.apply(rolePermissions);
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }

        boolean hasUnrestrictedPatterns(PrivilegesEvaluationContext context, MetaDataObject indexLike) throws PrivilegesEvaluationException {
            for (String role : context.getMappedRoles()) {
                Pattern pattern = (Pattern)this.rolesToIndexPatternWithoutRule.get((Object)role);
                if (pattern == null || !pattern.matches(indexLike.name())) continue;
                return true;
            }
            return false;
        }

        boolean hasUnrestrictedDynamicPatterns(PrivilegesEvaluationContext context, MetaDataObject indexLike) throws PrivilegesEvaluationException {
            for (String role : context.getMappedRoles()) {
                ImmutableSet indexDateMathExpressionWithoutRule;
                ImmutableSet indexPatternTemplatesWithoutRole = (ImmutableSet)this.rolesToIndexPatternTemplateWithoutRule.get((Object)role);
                if (indexPatternTemplatesWithoutRole != null) {
                    for (Role.IndexPatterns.IndexPatternTemplate indexPatternTemplate : indexPatternTemplatesWithoutRole) {
                        try {
                            Pattern pattern = context.getRenderedPattern(indexPatternTemplate.getTemplate());
                            if (!pattern.matches(indexLike.name()) || indexPatternTemplate.getExclusions().matches(indexLike.name())) continue;
                            return true;
                        }
                        catch (ExpressionEvaluationException e) {
                            log.error("Error while rendering index pattern of role " + role, (Throwable)e);
                        }
                    }
                }
                if ((indexDateMathExpressionWithoutRule = (ImmutableSet)this.rolesToIndexDateMathExpressionWithoutRule.get((Object)role)) == null) continue;
                for (Role.IndexPatterns.DateMathExpression dateMathExpression : indexDateMathExpressionWithoutRule) {
                    try {
                        Pattern pattern = context.getRenderedDateMathExpression(dateMathExpression.getDateMathExpression());
                        if (!pattern.matches(indexLike.name()) || dateMathExpression.getExclusions().matches(indexLike.name())) continue;
                        return true;
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new PrivilegesEvaluationException("Error while evaluating date math expression: " + dateMathExpression, (Throwable)e);
                    }
                }
            }
            return false;
        }

        static class DataStream<SingleRule>
        extends StaticRules<Meta.DataStream, Role.DataStream, SingleRule> {
            DataStream(SgDynamicConfiguration<Role> roles, Function<Role.Index, SingleRule> roleToRuleFunction) {
                super(roles, "data_stream", Role::getDataStreamPermissions, roleToRuleFunction);
            }
        }

        static class Alias<SingleRule>
        extends StaticRules<Meta.Alias, Role.Alias, SingleRule> {
            Alias(SgDynamicConfiguration<Role> roles, Function<Role.Index, SingleRule> roleToRuleFunction) {
                super(roles, "alias", Role::getAliasPermissions, roleToRuleFunction);
            }

            boolean isUnrestrictedViaParentAlias(PrivilegesEvaluationContext context, Meta.IndexLikeObject indexLike, String role) throws PrivilegesEvaluationException {
                Pattern aliasPatternWithoutRule = (Pattern)this.rolesToIndexPatternWithoutRule.get((Object)role);
                if (aliasPatternWithoutRule != null) {
                    for (Meta.Alias alias : indexLike.parentAliases()) {
                        if (!aliasPatternWithoutRule.matches(alias.name())) continue;
                        return true;
                    }
                }
                return false;
            }

            boolean isUnrestrictedViaTemplatesOnParentAlias(PrivilegesEvaluationContext context, Meta.IndexLikeObject indexLike, String role) throws PrivilegesEvaluationException {
                ImmutableSet aliasPatternTemplatesWithoutRule = (ImmutableSet)this.rolesToIndexPatternTemplateWithoutRule.get((Object)role);
                if (aliasPatternTemplatesWithoutRule != null) {
                    for (Meta.Alias alias : indexLike.parentAliases()) {
                        for (Role.IndexPatterns.IndexPatternTemplate indexPatternTemplate : aliasPatternTemplatesWithoutRule) {
                            try {
                                Pattern pattern = context.getRenderedPattern(indexPatternTemplate.getTemplate());
                                if (!pattern.matches(alias.name()) || indexPatternTemplate.getExclusions().matches(alias.name())) continue;
                                return true;
                            }
                            catch (ExpressionEvaluationException e) {
                                throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                            }
                        }
                    }
                }
                return false;
            }

            void collectRulesViaParentAlias(PrivilegesEvaluationContext context, Meta.IndexLikeObject indexLike, String role, Set<SingleRule> rulesSink) throws PrivilegesEvaluationException {
                ImmutableMap aliasPatternToRule = (ImmutableMap)this.rolesToIndexPatternToRule.get((Object)role);
                if (aliasPatternToRule != null) {
                    for (Meta.Alias alias : indexLike.parentAliases()) {
                        for (Map.Entry entry : aliasPatternToRule.entrySet()) {
                            if (!((Pattern)entry.getKey()).matches(alias.name())) continue;
                            rulesSink.add(entry.getValue());
                        }
                    }
                }
            }

            void collectRulesViaTemplatesOnParentAlias(PrivilegesEvaluationContext context, Meta.IndexLikeObject indexLike, String role, Set<SingleRule> rulesSink) throws PrivilegesEvaluationException {
                ImmutableMap aliasPatternTemplateToRule = (ImmutableMap)this.rolesToIndexPatternTemplateToRule.get((Object)role);
                if (aliasPatternTemplateToRule != null) {
                    for (Meta.Alias alias : indexLike.parentAliases()) {
                        for (Map.Entry entry : aliasPatternTemplateToRule.entrySet()) {
                            try {
                                Pattern pattern = context.getRenderedPattern(((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getTemplate());
                                if (!pattern.matches(alias.name()) || ((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getExclusions().matches(alias.name())) continue;
                                rulesSink.add(entry.getValue());
                            }
                            catch (ExpressionEvaluationException e) {
                                throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                            }
                        }
                    }
                }
            }
        }

        static class Index<SingleRule>
        extends StaticRules<Meta.Index, Role.Index, SingleRule> {
            Index(SgDynamicConfiguration<Role> roles, Function<Role.Index, SingleRule> roleToRuleFunction) {
                super(roles, "index", Role::getIndexPermissions, roleToRuleFunction);
            }
        }
    }

    static class StatefulRules<SingleRule>
    implements ComponentStateProvider {
        final Meta indexMetadata;
        final Index<SingleRule> index;
        final Alias<SingleRule> alias;
        final DataStream<SingleRule> dataStream;
        final ComponentState componentState;

        StatefulRules(SgDynamicConfiguration<Role> roles, Meta indexMetadata, Function<Role.Index, SingleRule> roleToRuleFunction) {
            this.index = new Index<SingleRule>(roles, indexMetadata, roleToRuleFunction);
            this.alias = new Alias<SingleRule>(roles, indexMetadata, roleToRuleFunction);
            this.dataStream = new DataStream<SingleRule>(roles, indexMetadata, roleToRuleFunction);
            this.indexMetadata = indexMetadata;
            this.componentState = new ComponentState("stateful_rules");
            this.componentState.addParts(new ComponentState[]{this.index.getComponentState(), this.alias.getComponentState(), this.dataStream.getComponentState()});
        }

        boolean covers(String index) {
            return this.indexMetadata.getIndexOrLike(index) != null;
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }

        static class Index<SingleRule>
        implements ComponentStateProvider {
            final ImmutableMap<Meta.Index, Map<String, SingleRule>> indexToRoleToRule;
            final ImmutableMap<Meta.Index, ImmutableCompactSubSet<String>> indexToRoleWithoutRule;
            final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;
            private final Function<Role.Index, SingleRule> roleToRuleFunction;
            private final ComponentState componentState = new ComponentState("index");

            Index(SgDynamicConfiguration<Role> roles, Meta indexMetadata, Function<Role.Index, SingleRule> roleToRuleFunction) {
                this.roleToRuleFunction = roleToRuleFunction;
                IndexedImmutableSet roleNames = IndexedImmutableSet.of((Set)roles.getCEntries().keySet());
                DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder((Set)roleNames);
                CompactMapGroupBuilder roleMapBuilder = new CompactMapGroupBuilder((Set)roleNames);
                ImmutableMap.Builder indexToRoleToRule = new ImmutableMap.Builder().defaultValue(k -> roleMapBuilder.createMapBuilder());
                ImmutableMap.Builder indexToRoleWithoutRule = new ImmutableMap.Builder().defaultValue(k -> roleSetBuilder.createSubSetBuilder());
                ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
                for (String roleName : roleNames) {
                    try {
                        Object rule;
                        Role role = (Role)roles.getCEntries().get((Object)roleName);
                        roleSetBuilder.next((Object)roleName);
                        for (Role.Index indexPermissions : role.getIndexPermissions()) {
                            Pattern indexPattern = indexPermissions.getIndexPatterns().getPattern();
                            if (indexPattern.isWildcard() || indexPattern.isBlank()) continue;
                            rule = this.roleToRule(indexPermissions);
                            if (rule != null) {
                                for (Meta.Index index : indexPattern.iterateMatching((Iterable)indexMetadata.indices(), Meta.IndexLikeObject::name)) {
                                    ((CompactMapGroupBuilder.MapBuilder)indexToRoleToRule.get((Object)index)).put((Object)roleName, rule);
                                }
                                continue;
                            }
                            for (Meta.Index index : indexPattern.iterateMatching((Iterable)indexMetadata.indices(), Meta.IndexLikeObject::name)) {
                                ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)indexToRoleWithoutRule.get((Object)index)).add((Object)roleName);
                            }
                        }
                        for (Role.Index aliasPermissions : role.getAliasPermissions()) {
                            Pattern aliasPattern = aliasPermissions.getIndexPatterns().getPattern();
                            if (aliasPattern.isBlank()) continue;
                            rule = this.roleToRule(aliasPermissions);
                            if (rule != null) {
                                for (Meta.Alias alias : aliasPattern.iterateMatching((Iterable)indexMetadata.aliases(), Meta.IndexLikeObject::name)) {
                                    alias.members().forEach(member -> {
                                        if (member instanceof Meta.Index) {
                                            ((CompactMapGroupBuilder.MapBuilder)indexToRoleToRule.get((Object)((Meta.Index)member))).put((Object)roleName, rule);
                                        }
                                    });
                                }
                                continue;
                            }
                            for (Meta.Alias alias : aliasPattern.iterateMatching((Iterable)indexMetadata.aliases(), Meta.IndexLikeObject::name)) {
                                alias.members().forEach(member -> {
                                    if (member instanceof Meta.Index) {
                                        ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)indexToRoleWithoutRule.get((Object)((Meta.Index)member))).add((Object)roleName);
                                    }
                                });
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)roleName, (Object)e);
                        ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)roleName)).with((Object)e);
                    }
                }
                DeduplicatingCompactSubSetBuilder.Completed completed = roleSetBuilder.build();
                this.indexToRoleToRule = indexToRoleToRule.build(b -> b.build());
                this.indexToRoleWithoutRule = indexToRoleWithoutRule.build(b -> b.build(completed));
                this.rolesToInitializationErrors = rolesToInitializationErrors.build(b -> b.build());
                if (this.rolesToInitializationErrors.isEmpty()) {
                    this.componentState.initialized();
                } else {
                    this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "roles_with_errors");
                    this.componentState.addDetail((Object)rolesToInitializationErrors);
                }
            }

            protected SingleRule roleToRule(Role.Index rolePermissions) {
                return this.roleToRuleFunction.apply(rolePermissions);
            }

            public ComponentState getComponentState() {
                return this.componentState;
            }
        }

        static class Alias<SingleRule>
        implements ComponentStateProvider {
            final ImmutableMap<Meta.Alias, Map<String, SingleRule>> aliasToRoleToRule;
            final ImmutableMap<Meta.Alias, ImmutableCompactSubSet<String>> aliasToRoleWithoutRule;
            final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;
            private final Function<Role.Index, SingleRule> roleToRuleFunction;
            private final ComponentState componentState = new ComponentState("alias");

            Alias(SgDynamicConfiguration<Role> roles, Meta indexMetadata, Function<Role.Index, SingleRule> roleToRuleFunction) {
                this.roleToRuleFunction = roleToRuleFunction;
                IndexedImmutableSet roleNames = IndexedImmutableSet.of((Set)roles.getCEntries().keySet());
                DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder((Set)roleNames);
                CompactMapGroupBuilder roleMapBuilder = new CompactMapGroupBuilder((Set)roleNames);
                ImmutableMap.Builder indexToRoleToQuery = new ImmutableMap.Builder().defaultValue(k -> roleMapBuilder.createMapBuilder());
                ImmutableMap.Builder indexToRoleWithoutQuery = new ImmutableMap.Builder().defaultValue(k -> roleSetBuilder.createSubSetBuilder());
                ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
                for (String roleName : roleNames) {
                    try {
                        Role role = (Role)roles.getCEntries().get((Object)roleName);
                        roleSetBuilder.next((Object)roleName);
                        for (Role.Alias aliasPermissions : role.getAliasPermissions()) {
                            Pattern aliasPattern = aliasPermissions.getIndexPatterns().getPattern();
                            if (aliasPattern.isWildcard() || aliasPattern.isBlank()) continue;
                            SingleRule rule = this.roleToRule((Role.Index)aliasPermissions);
                            if (rule != null) {
                                for (Meta.Alias alias : aliasPattern.iterateMatching((Iterable)indexMetadata.aliases(), Meta.IndexLikeObject::name)) {
                                    ((CompactMapGroupBuilder.MapBuilder)indexToRoleToQuery.get((Object)alias)).put((Object)roleName, rule);
                                }
                                continue;
                            }
                            for (Meta.Alias alias : aliasPattern.iterateMatching((Iterable)indexMetadata.aliases(), Meta.IndexLikeObject::name)) {
                                ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)indexToRoleWithoutQuery.get((Object)alias)).add((Object)roleName);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)roleName, (Object)e);
                        ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)roleName)).with((Object)e);
                    }
                }
                DeduplicatingCompactSubSetBuilder.Completed completed = roleSetBuilder.build();
                this.aliasToRoleToRule = indexToRoleToQuery.build(b -> b.build());
                this.aliasToRoleWithoutRule = indexToRoleWithoutQuery.build(b -> b.build(completed));
                this.rolesToInitializationErrors = rolesToInitializationErrors.build(b -> b.build());
                if (this.rolesToInitializationErrors.isEmpty()) {
                    this.componentState.initialized();
                } else {
                    this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "roles_with_errors");
                    this.componentState.addDetail((Object)rolesToInitializationErrors);
                }
            }

            protected SingleRule roleToRule(Role.Index rolePermissions) {
                return this.roleToRuleFunction.apply(rolePermissions);
            }

            public ComponentState getComponentState() {
                return this.componentState;
            }
        }

        static class DataStream<SingleRule>
        implements ComponentStateProvider {
            final ImmutableMap<Meta.DataStream, Map<String, SingleRule>> dataStreamToRoleToRule;
            final ImmutableMap<Meta.DataStream, ImmutableCompactSubSet<String>> dataStreamToRoleWithoutRule;
            final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;
            private final Function<Role.Index, SingleRule> roleToRuleFunction;
            private final ComponentState componentState = new ComponentState("data_stream");

            DataStream(SgDynamicConfiguration<Role> roles, Meta indexMetadata, Function<Role.Index, SingleRule> roleToRuleFunction) {
                this.roleToRuleFunction = roleToRuleFunction;
                IndexedImmutableSet roleNames = IndexedImmutableSet.of((Set)roles.getCEntries().keySet());
                DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder((Set)roleNames);
                CompactMapGroupBuilder roleMapBuilder = new CompactMapGroupBuilder((Set)roleNames);
                ImmutableMap.Builder indexToRoleToQuery = new ImmutableMap.Builder().defaultValue(k -> roleMapBuilder.createMapBuilder());
                ImmutableMap.Builder indexToRoleWithoutQuery = new ImmutableMap.Builder().defaultValue(k -> roleSetBuilder.createSubSetBuilder());
                ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
                for (String roleName : roleNames) {
                    try {
                        Object rule;
                        Role role = (Role)roles.getCEntries().get((Object)roleName);
                        roleSetBuilder.next((Object)roleName);
                        for (Role.DataStream dataStreamPermissions : role.getDataStreamPermissions()) {
                            Pattern dataStreamPattern = dataStreamPermissions.getIndexPatterns().getPattern();
                            if (dataStreamPattern.isWildcard() || dataStreamPattern.isBlank()) continue;
                            rule = this.roleToRule((Role.Index)dataStreamPermissions);
                            if (rule != null) {
                                for (Meta.DataStream dataStream : dataStreamPattern.iterateMatching((Iterable)indexMetadata.dataStreams(), Meta.IndexLikeObject::name)) {
                                    ((CompactMapGroupBuilder.MapBuilder)indexToRoleToQuery.get((Object)dataStream)).put((Object)roleName, rule);
                                }
                                continue;
                            }
                            for (Meta.DataStream dataStream : dataStreamPattern.iterateMatching((Iterable)indexMetadata.dataStreams(), Meta.IndexLikeObject::name)) {
                                ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)indexToRoleWithoutQuery.get((Object)dataStream)).add((Object)roleName);
                            }
                        }
                        for (Role.Index aliasPermissions : role.getAliasPermissions()) {
                            Pattern aliasPattern = aliasPermissions.getIndexPatterns().getPattern();
                            if (aliasPattern.isWildcard() || aliasPattern.isBlank()) continue;
                            rule = this.roleToRule(aliasPermissions);
                            if (rule != null) {
                                for (Meta.Alias alias : aliasPattern.iterateMatching((Iterable)indexMetadata.aliases(), Meta.IndexLikeObject::name)) {
                                    alias.members().forEach(member -> {
                                        if (member instanceof Meta.DataStream) {
                                            ((CompactMapGroupBuilder.MapBuilder)indexToRoleToQuery.get((Object)((Meta.DataStream)member))).put((Object)roleName, rule);
                                        }
                                    });
                                }
                                continue;
                            }
                            for (Meta.Alias alias : aliasPattern.iterateMatching((Iterable)indexMetadata.aliases(), Meta.IndexLikeObject::name)) {
                                alias.members().forEach(member -> {
                                    if (member instanceof Meta.DataStream) {
                                        ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)indexToRoleWithoutQuery.get((Object)((Meta.DataStream)member))).add((Object)roleName);
                                    }
                                });
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception while processing role: " + roleName + "\nIgnoring role.", (Throwable)e);
                        ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)roleName)).with((Object)e);
                    }
                }
                DeduplicatingCompactSubSetBuilder.Completed completed = roleSetBuilder.build();
                this.dataStreamToRoleToRule = indexToRoleToQuery.build(b -> b.build());
                this.dataStreamToRoleWithoutRule = indexToRoleWithoutQuery.build(b -> b.build(completed));
                this.rolesToInitializationErrors = rolesToInitializationErrors.build(b -> b.build());
                if (this.rolesToInitializationErrors.isEmpty()) {
                    this.componentState.initialized();
                } else {
                    this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "roles_with_errors");
                    this.componentState.addDetail((Object)rolesToInitializationErrors);
                }
            }

            protected SingleRule roleToRule(Role.Index rolePermissions) {
                return this.roleToRuleFunction.apply(rolePermissions);
            }

            public ComponentState getComponentState() {
                return this.componentState;
            }
        }
    }
}

