/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.lucene;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsLicenseInfo;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldMasking;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.ShardId;

public class DlsFlsActionContext {
    private final RoleBasedFieldAuthorization.FlsRule flsRule;
    private final Query dlsQuery;
    private final IndexService indexService;
    private final ThreadContext threadContext;
    private final DlsFlsLicenseInfo licenseInfo;
    private final AuditLog auditlog;
    private final RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule;
    private final ShardId shardId;

    public DlsFlsActionContext(Query dlsQuery, RoleBasedFieldAuthorization.FlsRule flsRule, RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule, IndexService indexService, ThreadContext threadContext, DlsFlsLicenseInfo licenseInfo, AuditLog auditlog, ShardId shardId) {
        this.dlsQuery = dlsQuery;
        this.flsRule = flsRule;
        this.indexService = indexService;
        this.threadContext = threadContext;
        this.licenseInfo = licenseInfo;
        this.auditlog = auditlog;
        this.fieldMaskingRule = fieldMaskingRule;
        this.shardId = shardId;
    }

    public Index index() {
        return this.indexService.index();
    }

    public boolean hasFlsRestriction() {
        return !this.flsRule.isAllowAll();
    }

    public boolean hasFieldMasking() {
        return this.licenseInfo.isLicenseForFieldMaskingAvailable() && !this.fieldMaskingRule.isAllowAll();
    }

    public RoleBasedFieldAuthorization.FlsRule getFlsRule() {
        return this.flsRule;
    }

    public Query getDlsQuery() {
        return this.dlsQuery;
    }

    public IndexService getIndexService() {
        return this.indexService;
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    public AuditLog getAuditlog() {
        return this.auditlog;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public RoleBasedFieldMasking.FieldMaskingRule getFieldMaskingRule() {
        return this.fieldMaskingRule;
    }

    public String toString() {
        return this.indexService.index() + " [" + this.dlsQuery + "; " + this.flsRule + "; " + this.fieldMaskingRule + "]";
    }

    public boolean isAllowed(String field) {
        return DlsFlsActionContext.isAllowed(this.flsRule, this.fieldMaskingRule, field);
    }

    public static boolean isAllowed(RoleBasedFieldAuthorization.FlsRule flsRule, RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule, String field) {
        return flsRule.isAllowed(field) && fieldMaskingRule.isNotMasked(field);
    }

    public boolean isAllowedButPossiblyMasked(String field) {
        return this.flsRule.isAllowed(field);
    }
}

