/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.regexp;

import com.google.code.regexp.GroupInfo;
import com.google.code.regexp.Matcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;

public class Pattern
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME_PATTERN = "[^!=].*?";
    private static final java.util.regex.Pattern NAMED_GROUP_PATTERN = java.util.regex.Pattern.compile("\\(\\?<([^!=].*?)>", 32);
    private static final java.util.regex.Pattern BACKREF_NAMED_GROUP_PATTERN = java.util.regex.Pattern.compile("\\\\k<([^!=].*?)>", 32);
    private static final java.util.regex.Pattern PROPERTY_PATTERN = java.util.regex.Pattern.compile("\\$\\{([^!=].*?)\\}", 32);
    private static final int INDEX_GROUP_NAME = 1;
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    private java.util.regex.Pattern pattern;
    private String namedPattern;
    private List<String> groupNames;
    private Map<String, List<GroupInfo>> groupInfo;

    protected Pattern(String string, int n) {
        this.namedPattern = string;
        this.groupInfo = Pattern.extractGroupInfo(string);
        this.pattern = this.buildStandardPattern(string, n);
    }

    public static Pattern compile(String string) {
        return new Pattern(string, 0);
    }

    public static Pattern compile(String string, int n) {
        return new Pattern(string, n);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        int n2 = -1;
        if (this.groupInfo.containsKey(string)) {
            List<GroupInfo> list = this.groupInfo.get(string);
            n2 = list.get(n).groupIndex();
        }
        return n2;
    }

    public int flags() {
        return this.pattern.flags();
    }

    public Matcher matcher(CharSequence charSequence) {
        return new Matcher(this, charSequence);
    }

    public java.util.regex.Pattern pattern() {
        return this.pattern;
    }

    public String standardPattern() {
        return this.pattern.pattern();
    }

    public String namedPattern() {
        return this.namedPattern;
    }

    public List<String> groupNames() {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>(this.groupInfo.keySet());
        }
        return Collections.unmodifiableList(this.groupNames);
    }

    public Map<String, List<GroupInfo>> groupInfo() {
        return Collections.unmodifiableMap(this.groupInfo);
    }

    public String replaceProperties(String string) {
        return this.replaceGroupNameWithIndex(new StringBuilder(string), PROPERTY_PATTERN, "$").toString();
    }

    public String[] split(CharSequence charSequence, int n) {
        return this.pattern.split(charSequence, n);
    }

    public String[] split(CharSequence charSequence) {
        return this.pattern.split(charSequence);
    }

    public String toString() {
        return this.namedPattern;
    }

    private static boolean isEscapedChar(String string, int n) {
        return Pattern.isSlashEscapedChar(string, n) || Pattern.isQuoteEscapedChar(string, n);
    }

    private static boolean isSlashEscapedChar(String string, int n) {
        int n2 = 0;
        while (n > 0 && string.charAt(n - 1) == '\\') {
            --n;
            ++n2;
        }
        return n2 % 2 != 0;
    }

    private static boolean isQuoteEscapedChar(String string, int n) {
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string.substring(0, n);
        int n2 = n;
        while ((n2 = string2.lastIndexOf("\\Q", n2 - 1)) != -1) {
            if (Pattern.isSlashEscapedChar(string2, n2)) continue;
            bl = true;
            break;
        }
        if (bl && string2.indexOf("\\E", n2) != -1) {
            bl2 = true;
        }
        return bl && !bl2;
    }

    private static boolean isInsideCharClass(String string, int n) {
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string.substring(0, n);
        int n2 = n;
        while ((n2 = string2.lastIndexOf(91, n2 - 1)) != -1) {
            if (Pattern.isEscapedChar(string2, n2)) continue;
            bl = true;
            break;
        }
        if (bl) {
            String string3 = string.substring(n2, n);
            int n3 = -1;
            while ((n3 = string3.indexOf(93, n3 + 1)) != -1) {
                if (Pattern.isEscapedChar(string3, n3)) continue;
                bl2 = true;
                break;
            }
        }
        return bl && !bl2;
    }

    private static boolean isNoncapturingParen(String string, int n) {
        boolean bl = false;
        String string2 = string.substring(n, n + 4);
        bl = string2.equals("(?<=") || string2.equals("(?<!");
        return string.charAt(n + 1) == '?' && (bl || string.charAt(n + 2) != '<');
    }

    private static int countOpenParens(String string, int n) {
        java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("\\(");
        java.util.regex.Matcher matcher = pattern.matcher(string.subSequence(0, n));
        int n2 = 0;
        while (matcher.find()) {
            if (Pattern.isInsideCharClass(string, matcher.start()) || Pattern.isEscapedChar(string, matcher.start()) || Pattern.isNoncapturingParen(string, matcher.start())) continue;
            ++n2;
        }
        return n2;
    }

    public static Map<String, List<GroupInfo>> extractGroupInfo(String string) {
        LinkedHashMap<String, List<GroupInfo>> linkedHashMap = new LinkedHashMap<String, List<GroupInfo>>();
        java.util.regex.Matcher matcher = NAMED_GROUP_PATTERN.matcher(string);
        while (matcher.find()) {
            int n = matcher.start();
            if (Pattern.isEscapedChar(string, n)) continue;
            String string2 = matcher.group(1);
            int n2 = Pattern.countOpenParens(string, n);
            List list = linkedHashMap.containsKey(string2) ? (List)linkedHashMap.get(string2) : new ArrayList();
            list.add(new GroupInfo(n2, n));
            linkedHashMap.put(string2, list);
        }
        return linkedHashMap;
    }

    private static StringBuilder replace(StringBuilder stringBuilder, java.util.regex.Pattern pattern, String string) {
        java.util.regex.Matcher matcher = pattern.matcher(stringBuilder);
        while (matcher.find()) {
            if (Pattern.isEscapedChar(stringBuilder.toString(), matcher.start())) continue;
            stringBuilder.replace(matcher.start(), matcher.end(), string);
            matcher.reset(stringBuilder);
        }
        return stringBuilder;
    }

    private StringBuilder replaceGroupNameWithIndex(StringBuilder stringBuilder, java.util.regex.Pattern pattern, String string) {
        java.util.regex.Matcher matcher = pattern.matcher(stringBuilder);
        while (matcher.find()) {
            if (Pattern.isEscapedChar(stringBuilder.toString(), matcher.start())) continue;
            int n = this.indexOf(matcher.group(1));
            if (n < 0) {
                throw new PatternSyntaxException("unknown group name", stringBuilder.toString(), matcher.start(1));
            }
            stringBuilder.replace(matcher.start(), matcher.end(), string + ++n);
            matcher.reset(stringBuilder);
        }
        return stringBuilder;
    }

    private java.util.regex.Pattern buildStandardPattern(String string, Integer n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder = Pattern.replace(stringBuilder, NAMED_GROUP_PATTERN, "(");
        stringBuilder = this.replaceGroupNameWithIndex(stringBuilder, BACKREF_NAMED_GROUP_PATTERN, "\\");
        return java.util.regex.Pattern.compile(stringBuilder.toString(), n);
    }

    private boolean groupInfoMatches(Map<String, List<GroupInfo>> map, Map<String, List<GroupInfo>> map2) {
        if (map == null && map2 == null) {
            return true;
        }
        boolean bl = false;
        if (map != null && map2 != null) {
            if (map.isEmpty() && map2.isEmpty()) {
                bl = true;
            } else if (map.size() == map2.size()) {
                for (Map.Entry<String, List<GroupInfo>> entry : map.entrySet()) {
                    List<GroupInfo> list;
                    List<GroupInfo> list2 = map2.get(entry.getKey());
                    boolean bl2 = bl = list2 != null;
                    if (bl && (bl = list2.containsAll(list = entry.getValue()) && list.containsAll(list2))) continue;
                    break;
                }
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Pattern)) {
            return false;
        }
        Pattern pattern = (Pattern)object;
        boolean bl = this.groupNames == null && pattern.groupNames == null || this.groupNames != null && !Collections.disjoint(this.groupNames, pattern.groupNames);
        boolean bl2 = bl && this.groupInfoMatches(this.groupInfo, pattern.groupInfo);
        return bl && bl2 && this.namedPattern.equals(pattern.namedPattern) && this.pattern.flags() == pattern.pattern.flags();
    }

    public int hashCode() {
        int n = this.namedPattern.hashCode() ^ this.pattern.hashCode();
        if (this.groupInfo != null) {
            n ^= this.groupInfo.hashCode();
        }
        if (this.groupNames != null) {
            n ^= this.groupNames.hashCode();
        }
        return n;
    }
}

