/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.cluster;

import com.floragunn.searchsupport.jobs.cluster.DistributedJobStore;
import com.floragunn.searchsupport.jobs.cluster.NodeComparator;
import com.floragunn.searchsupport.jobs.cluster.NodeIdComparator;
import com.floragunn.searchsupport.jobs.config.JobConfig;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;

public class JobDistributor
implements AutoCloseable {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final String name;
    private final String nodeFilter;
    private final String[] nodeFilterElements;
    private final ClusterService clusterService;
    private final NodeComparator<?> nodeComparator;
    private DistributedJobStore distributedJobStore;
    private int availableNodes = 0;
    private int currentNodeIndex = -1;
    private Object[] currentAvailableNodeIds;
    private final ClusterStateListener clusterStateListener = new ClusterStateListener(){

        public void clusterChanged(ClusterChangedEvent event) {
            if (event.state().blocks().hasGlobalBlockWithLevel(ClusterBlockLevel.READ)) {
                JobDistributor.this.log.debug("Cluster is not ready right now:\n" + event.state());
                return;
            }
            if (JobDistributor.this.log.isTraceEnabled()) {
                JobDistributor.this.log.trace("ClusterChangedEvent:\nblocksChanged: " + event.blocksChanged() + "\nmetadata: " + event.changedCustomMetadataSet() + "\nindices deleted: " + event.indicesDeleted() + "\nnew cluster: " + event.isNewCluster() + "\nlocalNodeMaster: " + event.localNodeMaster() + "\nmetadataChanged: " + event.metadataChanged() + "\nnodesAdded: " + event.nodesAdded() + "\nnodesChanged: " + event.nodesChanged() + "\nnodesRemoved: " + event.nodesRemoved() + "\nroutingTableChanged: " + event.routingTableChanged() + "\nsource: " + event.source() + "\ncurrent master: " + event.state().nodes().getMasterNodeId() + " " + (event.state().nodes().getMasterNode() != null ? event.state().nodes().getMasterNode().getName() : "-") + "\nall masters: " + event.state().nodes().getMasterNodes());
            }
            boolean distributionChanged = JobDistributor.this.update(event.state());
            if (JobDistributor.this.distributedJobStore != null && (!JobDistributor.this.distributedJobStore.isInitialized() || distributionChanged)) {
                JobDistributor.this.distributedJobStore.clusterConfigChanged(event);
            }
        }
    };

    public JobDistributor(String name, String nodeFilter, ClusterService clusterService, DistributedJobStore distributedJobStore) {
        this(name, nodeFilter, clusterService, distributedJobStore, new NodeIdComparator(clusterService));
    }

    public JobDistributor(String name, String nodeFilter, ClusterService clusterService, DistributedJobStore distributedJobStore, NodeComparator<?> nodeComparator) {
        this.name = name;
        this.nodeFilter = nodeFilter;
        this.nodeFilterElements = nodeFilter != null ? nodeFilter.split(",") : null;
        this.clusterService = clusterService;
        this.distributedJobStore = distributedJobStore;
        this.nodeComparator = nodeComparator;
        this.init();
    }

    public boolean isJobSelected(JobConfig jobConfig) {
        return this.isJobSelected(jobConfig, this.currentNodeIndex);
    }

    public boolean isJobSelected(JobConfig jobConfig, int nodeIndex) {
        if (this.availableNodes == 0) {
            return false;
        }
        int jobNodeIndex = Math.abs(jobConfig.hashCode()) % this.availableNodes;
        if (this.log.isTraceEnabled()) {
            this.log.trace("isJobSelected(  " + jobConfig + ", " + nodeIndex + ")\navailableNodes: " + this.availableNodes + "\njobNodeIndex: " + jobNodeIndex);
        }
        return jobNodeIndex == nodeIndex;
    }

    public String toString() {
        return "JobDistributor " + this.name;
    }

    @Override
    public void close() throws Exception {
        this.clusterService.removeListener(this.clusterStateListener);
    }

    private void init() {
        this.clusterService.addListener(this.clusterStateListener);
        this.update(this.clusterService.state());
    }

    private boolean update(ClusterState clusterState) {
        int oldAvailableNodes = this.availableNodes;
        int oldCurrentNodeIndex = this.currentNodeIndex;
        Object[] availableNodeIds = this.getAvailableNodeIds(clusterState);
        if (this.currentAvailableNodeIds != null && Arrays.equals(availableNodeIds, this.currentAvailableNodeIds)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Got cluster change event on " + clusterState.nodes().getLocalNodeId() + ", but nodes did not change");
            }
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Update of " + this + " on " + clusterState.nodes().getLocalNodeId() + ": " + Arrays.asList(availableNodeIds));
        }
        this.availableNodes = availableNodeIds.length;
        this.currentAvailableNodeIds = availableNodeIds;
        if (this.availableNodes == 0) {
            this.log.error("No nodes available for " + this + "\nnodeFilter: " + this.nodeFilter);
            this.currentNodeIndex = -1;
        } else {
            this.currentNodeIndex = Math.max(Arrays.binarySearch(availableNodeIds, this.nodeComparator.resolveNodeId(clusterState.nodes().getLocalNodeId())), -1);
        }
        if (oldAvailableNodes == this.availableNodes && oldCurrentNodeIndex == this.currentNodeIndex) {
            this.log.debug("Cluster state change does not require rescheduling of jobs. This node remains at index: " + oldCurrentNodeIndex + "; available nodes remains at: " + this.availableNodes);
            return false;
        }
        if (this.currentNodeIndex == -1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The current node is not configured to execute jobs for " + this + "\nnodeFilter: " + this.nodeFilter);
            }
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Node index of " + clusterState.nodes().getLocalNodeId() + " after update: " + this.currentNodeIndex);
        }
        return true;
    }

    private Object[] getAvailableNodeIds(ClusterState clusterState) {
        Object[] nodeIds = this.nodeComparator.resolveNodeFilters(this.nodeFilterElements);
        Arrays.sort(nodeIds);
        return nodeIds;
    }

    public DistributedJobStore getDistributedJobStore() {
        return this.distributedJobStore;
    }

    public void setDistributedJobStore(DistributedJobStore distributedJobStore) {
        this.distributedJobStore = distributedJobStore;
    }
}

