/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken.api;

import com.floragunn.searchguard.authtoken.api.CreateAuthTokenAction;
import com.floragunn.searchguard.authtoken.api.CreateAuthTokenRequest;
import com.floragunn.searchguard.authtoken.api.GetAuthTokenAction;
import com.floragunn.searchguard.authtoken.api.GetAuthTokenRequest;
import com.floragunn.searchguard.authtoken.api.GetAuthTokenResponse;
import com.floragunn.searchguard.authtoken.api.RevokeAuthTokenAction;
import com.floragunn.searchguard.authtoken.api.RevokeAuthTokenRequest;
import com.floragunn.searchguard.authtoken.api.RevokeAuthTokenResponse;
import com.floragunn.searchsupport.action.Responses;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;

public class AuthTokenRestAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(AuthTokenRestAction.class);

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, "/_searchguard/authtoken"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/authtoken/{id}"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_searchguard/authtoken/{id}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.method() == RestRequest.Method.POST) {
            return this.handlePost(request, client);
        }
        if (request.method() == RestRequest.Method.GET) {
            return this.handleGet(request.param("id"), client);
        }
        if (request.method() == RestRequest.Method.DELETE) {
            return this.handleDelete(request.param("id"), client);
        }
        return channel -> Responses.sendError((RestChannel)channel, (RestStatus)RestStatus.METHOD_NOT_ALLOWED, (String)("Method not allowed: " + request.method()));
    }

    private BaseRestHandler.RestChannelConsumer handlePost(RestRequest request, NodeClient client) {
        try {
            CreateAuthTokenRequest authTokenRequest = CreateAuthTokenRequest.parse((BytesReference)request.requiredContent(), request.getXContentType());
            return channel -> client.execute((ActionType)CreateAuthTokenAction.INSTANCE, (ActionRequest)authTokenRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (Exception e) {
            log.warn("Error while handling request", (Throwable)e);
            return channel -> Responses.sendError((RestChannel)channel, (Exception)e);
        }
    }

    private BaseRestHandler.RestChannelConsumer handleDelete(String id, NodeClient client) {
        try {
            return channel -> client.execute((ActionType)RevokeAuthTokenAction.INSTANCE, (ActionRequest)new RevokeAuthTokenRequest(id), (ActionListener)new RestToXContentListener(channel, RevokeAuthTokenResponse::status));
        }
        catch (Exception e) {
            return channel -> Responses.sendError((RestChannel)channel, (Exception)e);
        }
    }

    private BaseRestHandler.RestChannelConsumer handleGet(String id, NodeClient client) {
        try {
            return channel -> client.execute((ActionType)GetAuthTokenAction.INSTANCE, (ActionRequest)new GetAuthTokenRequest(id), (ActionListener)new RestToXContentListener(channel, GetAuthTokenResponse::status));
        }
        catch (Exception e) {
            return channel -> Responses.sendError((RestChannel)channel, (Exception)e);
        }
    }

    public String getName() {
        return "Search Guard Auth Token";
    }
}

