/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.validation;

import com.floragunn.codova.documents.BasicJsonPathDefaultConfiguration;
import com.floragunn.searchguard.dlic.rest.validation.AbstractConfigurationValidator;
import com.google.common.base.Splitter;
import com.google.common.primitives.Bytes;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.bouncycastle.util.encoders.Hex;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestRequest;

public class RolesValidator
extends AbstractConfigurationValidator {
    public RolesValidator(RestRequest request, BytesReference ref, Settings esSettings, Object ... param) {
        super(request, ref, esSettings, param);
        this.payloadMandatory = true;
        this.allowedKeys.put("cluster_permissions", AbstractConfigurationValidator.DataType.ARRAY);
        this.allowedKeys.put("tenant_permissions", AbstractConfigurationValidator.DataType.ARRAY);
        this.allowedKeys.put("index_permissions", AbstractConfigurationValidator.DataType.ARRAY);
        this.allowedKeys.put("exclude_cluster_permissions", AbstractConfigurationValidator.DataType.ARRAY);
        this.allowedKeys.put("description", AbstractConfigurationValidator.DataType.STRING);
        this.allowedKeys.put("alias_permissions", AbstractConfigurationValidator.DataType.ARRAY);
        this.allowedKeys.put("data_stream_permissions", AbstractConfigurationValidator.DataType.ARRAY);
    }

    @Override
    public boolean validate() {
        DocumentContext ctx;
        List maskedFields;
        if (!super.validate()) {
            return false;
        }
        boolean valid = true;
        if (this.content != null && this.content.length() > 0 && (maskedFields = (List)(ctx = JsonPath.parse((String)this.content.utf8ToString(), (Configuration)BasicJsonPathDefaultConfiguration.defaultConfiguration())).read("$..masked_fields[*]", new Predicate[0])) != null) {
            for (String mf : maskedFields) {
                if (this.validateMaskedFieldSyntax(mf)) continue;
                valid = false;
            }
        }
        if (!valid) {
            this.errorType = AbstractConfigurationValidator.ErrorType.WRONG_DATATYPE;
        }
        return valid;
    }

    private boolean validateMaskedFieldSyntax(String mf) {
        try {
            new MaskedField(mf, new byte[]{1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 6}, null, null).isValid();
        }
        catch (Exception e) {
            this.wrongDatatypes.put("Masked field not valid: " + mf, e.getMessage());
            return false;
        }
        return true;
    }

    private static class MaskedField {
        private String algo = null;
        private List<RegexReplacement> regexReplacements;
        private final byte[] defaultSalt;
        private final byte[] salt2;
        private final byte[] prefix;

        public MaskedField(String value, byte[] salt, byte[] salt2, byte[] prefix) {
            this.defaultSalt = salt;
            this.salt2 = salt2;
            this.prefix = prefix;
            List tokens = Splitter.on((String)"::").splitToList((CharSequence)Objects.requireNonNull(value));
            int tokenCount = tokens.size();
            if (tokenCount == 2) {
                this.algo = (String)tokens.get(1);
            } else if (tokenCount >= 3 && tokenCount % 2 == 1) {
                this.regexReplacements = new ArrayList<RegexReplacement>((tokenCount - 1) / 2);
                for (int i = 1; i < tokenCount - 1; i += 2) {
                    this.regexReplacements.add(new RegexReplacement((String)tokens.get(i), (String)tokens.get(i + 1)));
                }
            } else if (tokenCount != 1) {
                throw new IllegalArgumentException("Expected 1 or 2 or >=3 (but then odd count) tokens, got " + tokenCount);
            }
        }

        public final void isValid() throws Exception {
            this.mask(new byte[]{1, 2, 3, 4, 5});
        }

        public byte[] mask(byte[] value) {
            if (this.isDefault()) {
                return this.blake2bHash(value);
            }
            return this.customHash(value);
        }

        private boolean isDefault() {
            return this.regexReplacements == null && this.algo == null;
        }

        private byte[] customHash(byte[] in) {
            if (this.algo != null) {
                try {
                    MessageDigest digest = MessageDigest.getInstance(this.algo);
                    if (this.prefix != null) {
                        return Bytes.concat((byte[][])new byte[][]{this.prefix, Hex.encode((byte[])digest.digest(in))});
                    }
                    return Hex.encode((byte[])digest.digest(in));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (this.regexReplacements != null) {
                String cur = new String(in, StandardCharsets.UTF_8);
                for (RegexReplacement rr : this.regexReplacements) {
                    cur = cur.replaceAll(rr.getRegex(), rr.getReplacement());
                }
                if (this.prefix != null) {
                    return Bytes.concat((byte[][])new byte[][]{this.prefix, cur.getBytes(StandardCharsets.UTF_8)});
                }
                return cur.getBytes(StandardCharsets.UTF_8);
            }
            throw new IllegalArgumentException();
        }

        private byte[] blake2bHash(byte[] in) {
            Blake2bDigest hash = new Blake2bDigest(null, 32, this.salt2, this.defaultSalt);
            hash.update(in, 0, in.length);
            byte[] out = new byte[hash.getDigestSize()];
            hash.doFinal(out, 0);
            if (this.prefix != null) {
                return Bytes.concat((byte[][])new byte[][]{this.prefix, Hex.encode((byte[])out)});
            }
            return Hex.encode((byte[])out);
        }

        private static class RegexReplacement {
            private final String regex;
            private final String replacement;

            public RegexReplacement(String regex, String replacement) {
                this.regex = regex.substring(1).substring(0, regex.length() - 2);
                this.replacement = replacement;
            }

            public String getRegex() {
                return this.regex;
            }

            public String getReplacement() {
                return this.replacement;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
                result = 31 * result + (this.replacement == null ? 0 : this.replacement.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                RegexReplacement other = (RegexReplacement)obj;
                if (this.regex == null ? other.regex != null : !this.regex.equals(other.regex)) {
                    return false;
                }
                return !(this.replacement == null ? other.replacement != null : !this.replacement.equals(other.replacement));
            }

            public String toString() {
                return "RegexReplacement [regex=" + this.regex + ", replacement=" + this.replacement + "]";
            }
        }
    }
}

