/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgconf.history;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchguard.configuration.CType;
import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ConfigVersion
implements ToXContentObject,
Writeable,
Serializable {
    private static final long serialVersionUID = -3369133843964881336L;
    private final CType<?> configurationType;
    private final long version;

    public ConfigVersion(CType<?> configurationType, long version) {
        if (version <= 0L) {
            throw new IllegalArgumentException("version must be not <= 0: " + version + "; configurationType: " + configurationType);
        }
        this.configurationType = configurationType;
        this.version = version;
    }

    public ConfigVersion(StreamInput in) throws IOException {
        this.configurationType = CType.getByOrd((int)in.readVInt());
        this.version = in.readLong();
    }

    public CType<?> getConfigurationType() {
        return this.configurationType;
    }

    public long getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configurationType == null ? 0 : this.configurationType.hashCode());
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigVersion other = (ConfigVersion)obj;
        if (this.configurationType != other.configurationType) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return this.configurationType.name() + "@" + this.version;
    }

    public String toId() {
        return this.configurationType.name() + "_" + this.version;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", this.configurationType.name());
        builder.field("version", this.version);
        builder.endObject();
        return builder;
    }

    public static ConfigVersion fromId(String id) {
        int u = id.lastIndexOf(95);
        if (u == -1) {
            throw new IllegalArgumentException("Invalid ConfigurationVersion id: " + id);
        }
        try {
            long version = Long.parseLong(id.substring(u + 1));
            return new ConfigVersion(CType.valueOf((String)id.substring(0, u)), version);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid ConfigurationVersion id: " + id, e);
        }
    }

    public static ConfigVersion parse(DocNode jsonNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        CType configType = CType.fromString((String)vJsonNode.get("type").required().asString());
        long version = vJsonNode.get("version").required().asNumber().longValue();
        validationErrors.throwExceptionForPresentErrors();
        return new ConfigVersion(configType, version);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.configurationType.getOrd());
        out.writeLong(this.version);
    }
}

