/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.root;

import java.util.concurrent.Executor;
import org.elasticsearch.Build;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.root.MainRequest;
import org.elasticsearch.rest.root.MainResponse;
import org.elasticsearch.rest.root.MainRestPlugin;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportMainAction
extends TransportAction<MainRequest, MainResponse> {
    private final String nodeName;
    private final ClusterService clusterService;

    @Inject
    public TransportMainAction(Settings settings, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService) {
        super(MainRestPlugin.MAIN_ACTION.name(), actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.nodeName = (String)Node.NODE_NAME_SETTING.get(settings);
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, MainRequest request, ActionListener<MainResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        listener.onResponse((Object)new MainResponse(this.nodeName, IndexVersion.current().luceneVersion().toString(), clusterState.getClusterName(), clusterState.metadata().clusterUUIDCommitted() ? clusterState.metadata().clusterUUID() : "_na_", Build.current()));
    }
}

