/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.service.persistence;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchsupport.indices.IndexMapping;
import com.floragunn.signals.truststore.service.persistence.CertificateData;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

public class TruststoreData
implements Document<TruststoreData> {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_PEM = "raw_pem";
    public static final String FIELD_CERTIFICATES = "certificates";
    public static final String FIELD_STORE_TIME = "store_time";
    public static final String FIELD_SIZE = "size";
    public static final IndexMapping.DynamicIndexMapping MAPPINGS = new IndexMapping.DynamicIndexMapping(new IndexMapping.Property[]{new IndexMapping.TextWithKeywordProperty("name"), new IndexMapping.TextProperty("raw_pem"), new IndexMapping.DateProperty("store_time"), new IndexMapping.LongProperty("size"), new IndexMapping.ObjectProperty("certificates", new IndexMapping.Property[]{new IndexMapping.TextWithKeywordProperty("issuer"), new IndexMapping.TextWithKeywordProperty("subject"), new IndexMapping.TextWithKeywordProperty("serial_number"), new IndexMapping.TextProperty("pem"), new IndexMapping.DateProperty("not_after"), new IndexMapping.DateProperty("not_before")})});
    private final String id;
    private final String name;
    private final String pem;
    private final Instant storeTime;
    private final ImmutableList<CertificateData> certificates;

    public TruststoreData(String id, String name, Instant storeTime, String pem, ImmutableList<CertificateData> certificates) {
        this.id = id;
        this.name = name;
        this.pem = pem;
        this.certificates = Objects.requireNonNull(certificates, "Certificates are required");
        this.storeTime = storeTime;
    }

    TruststoreData(String id, DocNode document) throws ConfigValidationException {
        Objects.requireNonNull(document, "Doc node is required to parse truststore data");
        this.id = id;
        this.name = document.getAsString(FIELD_NAME);
        this.storeTime = Instant.parse(document.getAsString(FIELD_STORE_TIME));
        this.pem = document.getAsString(FIELD_PEM);
        this.certificates = document.getAsListFromNodes(FIELD_CERTIFICATES, CertificateData::parse);
    }

    public ImmutableMap<String, Object> toBasicObject() {
        return ImmutableMap.of((Object)FIELD_NAME, (Object)this.name, (Object)FIELD_STORE_TIME, (Object)this.storeTime, (Object)FIELD_SIZE, (Object)this.certificates.size(), (Object)FIELD_PEM, (Object)this.pem, (Object)FIELD_CERTIFICATES, this.certificates);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPem() {
        return this.pem;
    }

    public List<CertificateData> getCertificates() {
        return this.certificates;
    }
}

